/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.trace.Trace;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.security.Security;

public class FXLoader {
    private static final String POLICY_URL = "policy.url.";
    private static final String JAVAFX_RUNTIME_PROPERTY = "javafx.runtime.home";

    private static void registerJavaFXPolicy(JfxRuntime rt) throws MalformedURLException {
        int idx = 1;
        while (Security.getProperty(POLICY_URL + idx) != null) {
            ++idx;
        }
        File home = rt.getHome();
        File policyFile = new File(home, "lib/security/javafx.policy");
        if (policyFile.exists() && policyFile.canRead()) {
            Security.setProperty(POLICY_URL + idx, policyFile.toURI().toURL().toString());
            System.setProperty(JAVAFX_RUNTIME_PROPERTY, home.toString());
            Policy.getPolicy().refresh();
        }
    }

    private static void addURL(URLClassLoader classLoader, URL url) throws Exception {
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, url);
    }

    private static void loadFX(JfxRuntime jfx) throws ClassNotFoundException {
        if (null == jfx) {
            throw new ClassNotFoundException();
        }
        URL fx2URL = jfx.getFX2URL();
        if (fx2URL == null) {
            return;
        }
        URLClassLoader lastCL = null;
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            lastCL = (URLClassLoader)cl;
        }
        try {
            FXLoader.addURL(lastCL, fx2URL);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException("Failed to add JavaFX Runtime", ex);
        }
        try {
            FXLoader.registerJavaFXPolicy(jfx);
        }
        catch (Exception e) {
            Trace.ignored(e);
            throw new ClassNotFoundException("Failed to register jfx Policy");
        }
    }

    public static void loadFX() throws ClassNotFoundException {
        JfxRuntime jfx = JREInfo.getHomeJRE().getJfxRuntime();
        FXLoader.loadFX(jfx);
    }
}

