/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.SignedAsBlobJarFile;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.EnhancedJarVerifier;
import com.sun.deploy.security.JarAsBLOBVerifier;
import com.sun.deploy.security.SimpleJarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import com.sun.deploy.util.JarUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.AlgorithmId;

public abstract class JarVerifier {
    private static final String WEAK_ALGORITHM_CTX_KEY = "jarverifier.weak.ctx_key";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    protected File jarFile;
    protected File nativePath;
    protected URL jarLocation;
    protected String jarVersion;
    protected boolean hasSingleCodeSource = false;
    protected boolean hasOnlySignedEntries = false;
    protected boolean hasOnlyUnsignedEntries = true;
    protected boolean hasMissingSignedEntries = false;
    protected Manifest manifest;
    protected Map<String, int[]> signerMapCert = new HashMap<String, int[]>();
    protected CodeSourceCache codeSourceCertCache = new CodeSourceCache();
    protected int[] singleSignerIndicesCert;
    protected List<Certificate> signerCerts = new ArrayList<Certificate>();
    protected Map<String, int[]> signerMap = new HashMap<String, int[]>();
    protected CodeSourceCache codeSourceCache = new CodeSourceCache();
    protected List<CodeSigner> signersCS = new ArrayList<CodeSigner>();
    protected int[] singleSignerIndicesCS;
    private String signingInfoMessage;
    private static boolean TEST_INJECT_HAS_UNSIGNED = false;

    protected JarVerifier(URL location, String jarVersion, File f, File nativePath) {
        this.jarFile = f;
        this.nativePath = nativePath;
        this.jarLocation = location;
        this.jarVersion = jarVersion;
    }

    public URL getJarLocation() {
        return this.jarLocation;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public abstract void validate(DownloadDelegate var1) throws IOException, JARSigningException;

    public Manifest getManifest() {
        return this.manifest;
    }

    public Map<String, int[]> getSignerMapCert() {
        return this.signerMapCert;
    }

    public CodeSourceCache getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public Map<String, int[]> getSignerMap() {
        return this.signerMap;
    }

    public CodeSourceCache getCodeSourceCache() {
        return this.codeSourceCache;
    }

    public List<Certificate> getSignerCerts() {
        return this.signerCerts;
    }

    public List<CodeSigner> getSignersCS() {
        return this.signersCS;
    }

    public int[] getSingleSignerIndicesCert() {
        if (this.singleSignerIndicesCert != null) {
            return (int[])this.singleSignerIndicesCert.clone();
        }
        return null;
    }

    public int[] getSingleSignerIndicesCS() {
        if (this.singleSignerIndicesCS != null) {
            return (int[])this.singleSignerIndicesCS.clone();
        }
        return null;
    }

    public boolean hasOnlySignedEntries() {
        if (TEST_INJECT_HAS_UNSIGNED) {
            return false;
        }
        return this.hasOnlySignedEntries;
    }

    public boolean hasSingleCodeSource() {
        return this.hasSingleCodeSource;
    }

    public boolean hasMissingSignedEntries() {
        return this.hasMissingSignedEntries;
    }

    public static JarVerifier create(URL location, String version, File f, File nativeLibPath) {
        JarVerifier jv = JarAsBLOBVerifier.create(location, version, f, nativeLibPath);
        if (jv == null && (jv = EnhancedJarVerifier.create(location, version, f, nativeLibPath)) == null) {
            jv = SimpleJarVerifier.create(location, version, f, nativeLibPath);
        }
        return jv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readAndMaybeSaveStreamTo(InputStream in, boolean needToSave, String entryName, File outputDir) throws IOException {
        FilterOutputStream bost = null;
        byte[] buffer = new byte[16384];
        try {
            int n;
            File extractFile;
            if (needToSave && outputDir != null && (extractFile = new File(outputDir, entryName).getCanonicalFile()).getParentFile().equals(outputDir)) {
                extractFile.getParentFile().mkdirs();
                bost = new BufferedOutputStream(new FileOutputStream(extractFile));
            }
            while ((n = in.read(buffer, 0, buffer.length)) != -1) {
                if (bost == null) continue;
                ((BufferedOutputStream)bost).write(buffer, 0, n);
            }
        }
        finally {
            if (bost != null) {
                bost.close();
                bost = null;
            }
            if (in != null) {
                in.close();
            }
        }
    }

    protected void processCertificates(JarFile jar, JarEntry entry, String name) throws MalformedURLException {
        HashMap<Object, int[]> signerIndicesCertCache = new HashMap<Object, int[]>();
        Certificate[] certs = null;
        if (this.hasSingleCodeSource) {
            this.signerMapCert.put(name, this.singleSignerIndicesCert);
        } else {
            if (entry != null) {
                certs = entry.getCertificates();
            } else {
                CodeSource cs = null;
                DeployJavaUtilJarAccess jarAccess = DeployJavaUtilJarAccess.instance();
                cs = jarAccess.getCodeSource(jar, this.jarLocation, name);
                Certificate[] certificateArray = certs = cs != null ? cs.getCertificates() : null;
            }
            if (certs != null && certs.length > 0) {
                int[] signerIndicesCert = new int[certs.length];
                for (int i = 0; i < certs.length; ++i) {
                    int signerIndexCert = this.signerCerts.indexOf(certs[i]);
                    if (signerIndexCert == -1) {
                        signerIndexCert = this.signerCerts.size();
                        this.signerCerts.add(certs[i]);
                    }
                    signerIndicesCert[i] = signerIndexCert;
                }
                Object certLine = String.valueOf(signerIndicesCert.length);
                for (int i = 0; i < signerIndicesCert.length; ++i) {
                    certLine = (String)certLine + " " + signerIndicesCert[i];
                }
                int[] indices = (int[])signerIndicesCertCache.get(certLine);
                if (indices == null) {
                    signerIndicesCertCache.put(certLine, signerIndicesCert);
                    CodeSource codeSource = new CodeSource(this.jarLocation, certs);
                    this.codeSourceCertCache.put(signerIndicesCert, codeSource);
                } else {
                    signerIndicesCert = indices;
                }
                this.signerMapCert.put(name, signerIndicesCert);
            }
        }
    }

    protected void processSigners(JarFile jar, JarEntry entry, String name) throws MalformedURLException {
        CodeSigner[] entrySigners = null;
        HashMap<Object, int[]> signerIndicesCache = new HashMap<Object, int[]>();
        if (this.hasSingleCodeSource) {
            this.signerMap.put(name, this.singleSignerIndicesCS);
        } else {
            if (entry != null) {
                entrySigners = entry.getCodeSigners();
            } else {
                DeployJavaUtilJarAccess jarAccess = DeployJavaUtilJarAccess.instance();
                CodeSource cs = jarAccess.getCodeSource(jar, this.jarLocation, name);
                CodeSigner[] codeSignerArray = entrySigners = cs != null ? cs.getCodeSigners() : null;
            }
            if (entrySigners != null && entrySigners.length > 0) {
                int[] signerIndicesCS = new int[entrySigners.length];
                for (int i = 0; i < entrySigners.length; ++i) {
                    int signerIndexCS = this.signersCS.indexOf(entrySigners[i]);
                    if (signerIndexCS == -1) {
                        signerIndexCS = this.signersCS.size();
                        this.signersCS.add(entrySigners[i]);
                    }
                    signerIndicesCS[i] = signerIndexCS;
                }
                Object lineCS = String.valueOf(signerIndicesCS.length);
                for (int i = 0; i < signerIndicesCS.length; ++i) {
                    lineCS = (String)lineCS + " " + signerIndicesCS[i];
                }
                int[] indices = (int[])signerIndicesCache.get(lineCS);
                if (indices == null) {
                    signerIndicesCache.put(lineCS, signerIndicesCS);
                    CodeSource codeSource = new CodeSource(this.jarLocation, entrySigners);
                    this.codeSourceCache.put(signerIndicesCS, codeSource);
                } else {
                    signerIndicesCS = indices;
                }
                this.signerMap.put(name, signerIndicesCS);
            }
        }
    }

    protected void authenticateJarEntry(JarFile jar, JarEntry entry) throws IOException, JARSigningException {
        if (entry == null) {
            return;
        }
        String name = entry.getName();
        boolean needToSave = this.nativePath != null && name.indexOf("/") == -1 && name.indexOf("\\") == -1;
        try {
            JarVerifier.readAndMaybeSaveStreamTo(jar.getInputStream(entry), needToSave, name, this.nativePath);
        }
        catch (SecurityException se) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, se);
        }
    }

    public static JarFile getValidatedJarFile(File tempFile, URL resourceURL, URL requestURL, String versionString, DownloadDelegate dd) throws IOException {
        boolean success = false;
        JarVerifier jv = JarVerifier.create(requestURL, versionString, tempFile, null);
        JarFile result = JarUtil.createJarFile(tempFile, true);
        if (dd != null) {
            dd.validating(resourceURL, 0, result.size());
        }
        try {
            jv.validate(dd);
            if (jv instanceof JarAsBLOBVerifier) {
                result = new SignedAsBlobJarFile(tempFile, (JarAsBLOBVerifier)jv);
            }
            if (BlackList.getInstance().checkJarFile(result)) {
                JarFile jarFile = null;
                return jarFile;
            }
            success = true;
        }
        catch (ZipException ze) {
            throw new JARSigningException(resourceURL, versionString, 2, ze);
        }
        catch (SecurityException se) {
            throw new JARSigningException(resourceURL, versionString, 2, se);
        }
        finally {
            if (!success) {
                result.close();
            }
        }
        return success ? result : null;
    }

    protected void warnIfUnsigned() {
        try {
            if (this.signersCS.isEmpty() && this.isJarWeaklySigned()) {
                String securityPropertyValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty(JarVerifier.PROPERTY_JAR_DISABLED_ALGS);
                    }
                });
                String securityPropertyString = "jdk.jar.disabledAlgorithms=" + securityPropertyValue;
                String warningMsg = ResourceManager.getString("deployment.console.weak.text", this.signingInfoMessage, securityPropertyString, this.jarFile.getAbsolutePath());
                Trace.println(warningMsg, TraceLevel.SECURITY);
                JarVerifier.setWeakAlgorithmMessage(this.signingInfoMessage);
            }
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
    }

    private static void setWeakAlgorithmMessage(String message) {
        ToolkitStore.get().getAppContext().put(WEAK_ALGORITHM_CTX_KEY, message);
    }

    public static String getWeakAlgorithmMessage() {
        return (String)ToolkitStore.get().getAppContext().get(WEAK_ALGORITHM_CTX_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isJarWeaklySigned() {
        Object key;
        DisabledAlgorithmConstraints VERIFY_CHECK = new DisabledAlgorithmConstraints(PROPERTY_JAR_DISABLED_ALGS);
        Set<CryptoPrimitive> DIGEST_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.MESSAGE_DIGEST));
        Set<CryptoPrimitive> SIG_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
        HashMap<String, String> digestMap = new HashMap<String, String>();
        HashMap<String, PKCS7> sigMap = new HashMap<String, PKCS7>();
        JarFile jf = null;
        try {
            jf = JarUtil.createJarFile(this.jarFile, true);
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = jf.entries();
            block15: while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                try {
                    InputStream is = jf.getInputStream(je);
                    String name = je.getName();
                    if (!SignatureFileVerifier.isSigningRelated(name) || !SignatureFileVerifier.isBlockOrSF(name)) continue;
                    String alias = name.substring(name.lastIndexOf(47) + 1, name.lastIndexOf(46));
                    if (name.endsWith(".SF")) {
                        Manifest sf = new Manifest(is);
                        for (Object obj : sf.getMainAttributes().keySet()) {
                            key = obj.toString();
                            if (!((String)key).endsWith("-Digest-Manifest")) continue;
                            digestMap.put(alias, ((String)key).substring(0, ((String)key).length() - 16));
                            continue block15;
                        }
                        continue;
                    }
                    sigMap.put(alias, new PKCS7(is));
                }
                catch (IOException ioe) {
                    Trace.ignored(ioe);
                }
            }
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException ex) {
                    Trace.ignored(ex);
                }
            }
        }
        boolean isWeak = false;
        for (String s : digestMap.keySet()) {
            PKCS7 p7 = (PKCS7)sigMap.get(s);
            if (p7 == null) continue;
            try {
                SignerInfo si = p7.getSignerInfos()[0];
                X509Certificate signer = si.getCertificate(p7);
                String digestAlg = (String)digestMap.get(s);
                String sigAlg = AlgorithmId.makeSigAlg((String)si.getDigestAlgorithmId().getName(), (String)si.getDigestEncryptionAlgorithmId().getName());
                key = signer.getPublicKey();
                if (!VERIFY_CHECK.permits(DIGEST_PRIMITIVE_SET, digestAlg, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.digest", digestAlg, this.jarLocation);
                    isWeak = true;
                    break;
                }
                if (!VERIFY_CHECK.permits(SIG_PRIMITIVE_SET, sigAlg, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.signature", sigAlg, this.jarLocation);
                    isWeak = true;
                    break;
                }
                if (!VERIFY_CHECK.permits(SIG_PRIMITIVE_SET, (Key)key)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.key", sigAlg, KeyUtil.getKeySize((Key)key), this.jarLocation);
                    isWeak = true;
                    break;
                }
                PKCS7 tsToken = si.getTsToken();
                if (tsToken == null) continue;
                SignerInfo tsSi = tsToken.getSignerInfos()[0];
                X509Certificate tsSigner = tsSi.getCertificate(tsToken);
                byte[] encTsTokenInfo = tsToken.getContentInfo().getData();
                TimestampToken tsTokenInfo = new TimestampToken(encTsTokenInfo);
                PublicKey tsKey = tsSigner.getPublicKey();
                String tsDigestAlg = tsTokenInfo.getHashAlgorithm().getName();
                String tsSigAlg = AlgorithmId.makeSigAlg((String)tsSi.getDigestAlgorithmId().getName(), (String)tsSi.getDigestEncryptionAlgorithmId().getName());
                if (!VERIFY_CHECK.permits(DIGEST_PRIMITIVE_SET, tsDigestAlg, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.digest", sigAlg, this.jarLocation);
                    isWeak = true;
                    break;
                }
                if (!VERIFY_CHECK.permits(SIG_PRIMITIVE_SET, tsSigAlg, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.signature", sigAlg, this.jarLocation);
                    isWeak = true;
                    break;
                }
                if (VERIFY_CHECK.permits(SIG_PRIMITIVE_SET, tsKey)) continue;
                this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.key", sigAlg, KeyUtil.getKeySize((Key)key), this.jarLocation);
                isWeak = true;
                break;
            }
            catch (Throwable t) {
                Trace.ignored(t);
            }
        }
        return isWeak;
    }

    public static class CodeSourceCache {
        private final Map<IndicesKey, CodeSource> map = new HashMap<IndicesKey, CodeSource>();

        public void put(int[] indices, CodeSource cs) {
            this.map.put(CodeSourceCache.wrapKey(indices), cs);
        }

        public CodeSource get(int[] indices) {
            return this.map.get(CodeSourceCache.wrapKey(indices));
        }

        public Collection<CodeSource> getCodeSources() {
            return Collections.unmodifiableCollection(this.map.values());
        }

        public int[] findMatchingIndices(CodeSource cs) {
            for (Map.Entry<IndicesKey, CodeSource> e : this.map.entrySet()) {
                CodeSource v = e.getValue();
                if (v == null || !v.equals(cs)) continue;
                return e.getKey().getIndices();
            }
            return null;
        }

        private static IndicesKey wrapKey(int[] indices) {
            return new IndicesKey(indices);
        }

        private static class IndicesKey {
            private final int[] indices;

            public IndicesKey(int[] indices) {
                this.indices = indices;
            }

            public int[] getIndices() {
                return this.indices != null ? (int[])this.indices.clone() : null;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + Arrays.hashCode(this.indices);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                IndicesKey other = (IndicesKey)obj;
                return Arrays.equals(this.indices, other.indices);
            }
        }
    }
}

