/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.trace.Trace;

public class VerboseDefaultConfig
extends DefaultConfig {
    private static final long serialVersionUID = 3852155788681360441L;
    private static DefaultConfig _defaultConfigInstance;
    private static boolean _constructionComplete;

    public static synchronized DefaultConfig getDefaultConfig() {
        if (_defaultConfigInstance == null) {
            _defaultConfigInstance = new VerboseDefaultConfig();
            _constructionComplete = true;
        }
        return _defaultConfigInstance;
    }

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (_constructionComplete && Config.getDebug()) {
            Trace.println("--- Warning --- VerboseDefaultConfig.getProperty(" + key + "); called, returning default value: " + value);
            new Throwable().printStackTrace();
        }
        return value;
    }

    @Override
    public Object setProperty(String key, String value) {
        if (_constructionComplete && Config.getDebug()) {
            Trace.println("--- Warning --- VerboseDefaultConfig.setProperty(" + key + ", " + value + "); called,  value was: " + super.getProperty(key));
            new Throwable().printStackTrace();
        }
        return super.setProperty(key, value);
    }

    @Override
    public void storeIfNeeded() {
        if (Config.getDebug()) {
            Trace.println("--- Warning --- VerboseDefaultConfig.storeIfNeeded()");
        }
    }

    static {
        _constructionComplete = false;
    }
}

