/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.ConfigTrustManager;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import javax.net.ssl.HttpsURLConnection;
import sun.net.www.protocol.https.Handler;

public class ClientConfig
extends Config {
    private static final long serialVersionUID = -7637841456257547672L;
    private boolean _configOK = false;
    private Properties _systemProps;
    private Properties _internalProps;
    private Properties _lockedProps;
    protected Properties _changedProps;
    private boolean _userConfigStore;
    protected boolean _dirty;
    private File _userConfigFile;
    private SyncFileAccess _userConfigFileSyncAccess;
    private String _enterprizeConfig = null;
    private long _lastChanged;
    private long _sysPropsModified = 0L;
    static final AccessControlContext ACC_FILE_INSTANCE;
    static final AccessControlContext ACC_REFRESH_PROP_INSTANCE;
    private static final AccessControlContext ACC_PROP_INSTANCE;
    private static final String[] UNCACHABLE_PROPS;
    private String initVersionOverride = null;

    public ClientConfig() {
        this.init(null, null);
    }

    @Override
    public Object setProperty(String key, String value) {
        if (this.isDiskNewer()) {
            this.refreshIfNeeded();
        }
        String old = super.getProperty(key);
        if (value == null || value.length() == 0) {
            if (this.containsKey(key) && !this.isInternalProp(key)) {
                this._dirty = true;
            }
            this.remove(key);
            this._changedProps.remove(key);
        } else if (!value.equals(old)) {
            if (!this.isInternalProp(key)) {
                this._dirty = true;
            }
            super.setProperty(key, value);
            this._changedProps.setProperty(key, value);
        }
        return old;
    }

    @Override
    public boolean init(String userPath, String systemPath) {
        String enabled;
        int i;
        boolean retval = true;
        this._systemProps = new Properties();
        this._internalProps = this.getInternalProps();
        this._changedProps = new Properties();
        this._userConfigStore = false;
        if (userPath == null) {
            this._userConfigFile = this.useRoamingProfile() ? new File(ClientConfig.getRoamingUserPropertiesFile()) : new File(ClientConfig.getUserPropertiesFile());
            this._userConfigStore = true;
        } else if (!userPath.equals("")) {
            this._userConfigFile = new File(userPath);
            if (!this._userConfigFile.exists()) {
                this._userConfigFile = null;
                Trace.println("Test user config file given: " + userPath + " is non existant", TraceLevel.BASIC);
            }
        } else {
            this._userConfigFile = null;
        }
        if (this._userConfigFile != null) {
            this._userConfigFileSyncAccess = new SyncFileAccess(this._userConfigFile);
        }
        if (systemPath == null) {
            Properties configProps;
            boolean mandatory = false;
            File config = new File(ClientConfig.getSystemHome() + File.separator + "deployment.config");
            if (!config.exists()) {
                config = new File(Environment.getDeploymentHomePath() + File.separator + "lib" + File.separator + "deployment.config");
            }
            if (!config.exists()) {
                config = new File(Environment.getJavaHome() + File.separator + "lib" + File.separator + "deployment.config");
            }
            if (config.exists() && (configProps = this.loadPropertiesFile(new Properties(), config)) != null) {
                String urlStr;
                String mandatory_str = configProps.getProperty("deployment.system.config.mandatory");
                mandatory = mandatory_str != null && !mandatory_str.equalsIgnoreCase("false");
                this._enterprizeConfig = urlStr = configProps.getProperty("deployment.system.config");
            }
            if (!this.initializeSysProps(this._enterprizeConfig, this._systemProps)) {
                retval = !mandatory;
            }
        } else {
            retval = true;
            if (!systemPath.equals("")) {
                File sysPropsFile = new File(systemPath);
                if (sysPropsFile.exists()) {
                    this.loadPropertiesFile(this._systemProps, sysPropsFile);
                    this._sysPropsModified = sysPropsFile.lastModified();
                } else {
                    Trace.println("Test system config file given: " + systemPath + " is non existant", TraceLevel.BASIC);
                }
            }
        }
        Properties userProps = this.refreshProperties();
        String sysAppliedString = userProps.getProperty("deployment.system.jre.applied");
        long sysApplied = 0L;
        if (sysAppliedString != null) {
            try {
                sysApplied = Long.parseLong(sysAppliedString);
            }
            catch (Exception nfe) {
                Trace.ignored(nfe);
            }
        }
        boolean anySysJreProps = false;
        for (i = 0; i < 2; ++i) {
            boolean isPlatform = i == 0;
            Enumeration<?> allPropsEnum = this.propertyNames();
            while (allPropsEnum.hasMoreElements()) {
                boolean inUser;
                String key = (String)allPropsEnum.nextElement();
                if (!key.startsWith("deployment.system.jre.") || key.equals("deployment.system.jre.applied")) continue;
                String value = this.getProperty(key);
                String sysValue = this._systemProps.getProperty(key);
                boolean inSys = sysValue != null;
                boolean bl = inUser = value != null && !value.equals(sysValue);
                if (!inUser && sysApplied >= this._sysPropsModified) continue;
                String ver = key.substring("deployment.system.jre.".length());
                if (value != null && ver != null) {
                    int comma = value.indexOf(",");
                    if (comma > 0) {
                        boolean enabled2 = Boolean.valueOf(value.substring(0, comma));
                        JREInfo.setEnabled(ver, enabled2, isPlatform);
                    }
                    if (comma >= 0 && comma < value.length() - 2) {
                        String args = value.substring(comma + 1);
                        JREInfo.setArgs(ver, args, isPlatform);
                    }
                }
                if (!isPlatform && inUser) {
                    this.setProperty(key, sysValue);
                }
                if (!inSys) continue;
                anySysJreProps = true;
            }
            if (!anySysJreProps) continue;
            this.setProperty("deployment.system.jre.applied", String.valueOf(System.currentTimeMillis()));
        }
        this.versionUpdateCheck();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Properties systemProperties = System.getProperties();
                Enumeration<?> en = ClientConfig.this.propertyNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String value = ClientConfig.this.getProperty(key);
                    if (value == null) continue;
                    systemProperties.put(key, Config.replaceVariables(value));
                }
                System.setProperties(systemProperties);
                ClientConfig.this.setPolicyFiles();
                return null;
            }
        }, ACC_PROP_INSTANCE);
        if (this._userConfigFile != null) {
            for (i = 0; i < PROXY_KEYS.length; ++i) {
                String deployKey = PROXY_KEYS[i];
                String activeKey = "active." + deployKey;
                this.setProperty(activeKey, this.getProperty(deployKey));
            }
        }
        if ((enabled = this.getProperty("deployment.webjava.enabled")) != null && !Boolean.valueOf(enabled).booleanValue() && Environment.isWebJava()) {
            retval = false;
        }
        if (this._systemProps != null) {
            Enumeration<Object> sysEnum = this._systemProps.keys();
            while (sysEnum.hasMoreElements()) {
                String key = (String)sysEnum.nextElement();
                String value = this._systemProps.getProperty(key);
                if (value == null || value.equals(userProps.get(key))) continue;
                this._dirty = true;
                break;
            }
        }
        long modified = 0L;
        try {
            modified = Long.parseLong(this.getProperty("deployment.modified.timestamp"));
        }
        catch (Exception value) {
            // empty catch block
        }
        if (this._sysPropsModified > modified && this._systemProps.containsKey("deployment.webjava.enabled")) {
            this.setProperty("deployment.webjava.enabled", this._systemProps.getProperty("deployment.webjava.enabled"));
        }
        String expireCheckProp = null;
        if (userProps != null && userProps.containsKey("deployment.expiration.check.enabled")) {
            expireCheckProp = userProps.getProperty("deployment.expiration.check.enabled");
        }
        if (this._systemProps != null && this._systemProps.containsKey("deployment.expiration.check.enabled")) {
            expireCheckProp = this._systemProps.getProperty("deployment.expiration.check.enabled");
        }
        if (expireCheckProp != null) {
            ClientConfig.setExpirationCheckEnabled(Boolean.valueOf(expireCheckProp));
        }
        this._configOK = retval;
        return retval;
    }

    private Properties refreshProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                String value;
                String key;
                Properties userProps = new Properties();
                Properties jwsJreProps = new Properties();
                Properties sysJreProps = new Properties();
                ClientConfig.this._lockedProps = new Properties();
                ClientConfig.this.clear();
                ClientConfig.this.putAll((Map<?, ?>)Config.getDefaults());
                if (ClientConfig.this._userConfigFile == null) {
                    userProps.clear();
                } else if (ClientConfig.this._userConfigFile.exists()) {
                    ClientConfig.this.loadPropertiesFile(userProps, ClientConfig.this._userConfigFile);
                    ClientConfig.this._lastChanged = ClientConfig.this._userConfigFile.lastModified();
                } else {
                    ClientConfig.this._lastChanged = System.currentTimeMillis();
                }
                Enumeration<Object> en = ClientConfig.this._systemProps.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    value = ClientConfig.this._systemProps.getProperty(key);
                    if (key.startsWith("deployment.javaws.jre.")) {
                        sysJreProps.setProperty(key, value);
                        continue;
                    }
                    if (key.endsWith(".locked")) {
                        int end = key.length() - ".locked".length();
                        key = key.substring(0, end);
                        String lockedValue = ClientConfig.this._systemProps.getProperty(key);
                        if (lockedValue == null) continue;
                        ClientConfig.this.lockProperty(key, lockedValue);
                        continue;
                    }
                    if (!key.startsWith("deployment.")) continue;
                    ClientConfig.this.setProperty(key, value);
                }
                en = userProps.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    value = userProps.getProperty(key);
                    if (key.startsWith("deployment.javaws.jre.")) {
                        jwsJreProps.setProperty(key, value);
                        continue;
                    }
                    if (key.startsWith("deployment.javapi.jre.") || key.startsWith("deployment.javapi.jdk.") || !key.startsWith("deployment.") && !key.startsWith("javaplugin")) continue;
                    ClientConfig.this.setProperty(key, value);
                }
                boolean changed = JREInfo.initialize(sysJreProps, jwsJreProps);
                ClientConfig.this.getInternalPropValues();
                if (ClientConfig.this._userConfigFile != null) {
                    for (int i = 0; i < Config.PROXY_KEYS.length; ++i) {
                        String deployKey = Config.PROXY_KEYS[i];
                        String activeKey = "active." + deployKey;
                        ClientConfig.this.setProperty(activeKey, ClientConfig.this.getProperty(deployKey));
                    }
                }
                en = ClientConfig.this._lockedProps.keys();
                while (en.hasMoreElements()) {
                    String key2 = (String)en.nextElement();
                    ClientConfig.this.setProperty(key2, ClientConfig.this._lockedProps.getProperty(key2));
                }
                ClientConfig.this._dirty = changed;
                ClientConfig.this._changedProps.clear();
                return userProps;
            }
        }, ACC_REFRESH_PROP_INSTANCE);
    }

    public void getInternalPropValues() {
    }

    private void setPolicyFiles() {
        String systemPolicyURL = this.getProperty("deployment.system.security.policy");
        if (systemPolicyURL != null) {
            systemPolicyURL = ClientConfig.replaceVariables(systemPolicyURL).trim();
        }
        String userPolicyURL = null;
        if ("true".equals(this.getProperty("deployment.security.use.user.home.java.policy"))) {
            userPolicyURL = this.getProperty("deployment.user.security.policy");
            if (userPolicyURL != null) {
                userPolicyURL = ClientConfig.replaceVariables(userPolicyURL).trim();
            }
        } else {
            Security.setProperty("policy.url.2", "");
        }
        if (systemPolicyURL != null || userPolicyURL != null) {
            int numPolicy = 1;
            String policyURL = null;
            while ((policyURL = Security.getProperty("policy.url." + numPolicy)) != null) {
                ++numPolicy;
            }
            if (systemPolicyURL != null) {
                Security.setProperty("policy.url." + numPolicy, systemPolicyURL);
                ++numPolicy;
            }
            if (userPolicyURL != null) {
                Security.setProperty("policy.url." + numPolicy, userPolicyURL);
                ++numPolicy;
            }
        }
        Policy.getPolicy().refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDownloading(String urlStr, Properties props) {
        URLConnection connection = null;
        try {
            URL url = null;
            url = urlStr.toLowerCase().startsWith("https:") ? new URL(null, urlStr, new Handler()) : new URL(urlStr);
            connection = url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                ConfigTrustManager.resetHttpsFactory((HttpsURLConnection)connection);
            }
            InputStream is = connection.getInputStream();
            props.load(is);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Trace.ignoredException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).disconnect();
            }
        }
    }

    private boolean initializeSysProps(String enterpriseConfigUrl, Properties sysProps) {
        File propsFile;
        boolean ret = true;
        if (enterpriseConfigUrl != null) {
            ret = this.tryDownloading(enterpriseConfigUrl, sysProps);
        }
        if (!(propsFile = new File(ClientConfig.getSystemHome() + File.separator + ClientConfig.getPropertiesFilename())).exists()) {
            propsFile = new File(Environment.getJavaHome() + File.separator + "lib" + File.separator + ClientConfig.getPropertiesFilename());
        }
        if (propsFile.exists()) {
            this._sysPropsModified = propsFile.lastModified();
            this.loadPropertiesFile(sysProps, propsFile);
        }
        return ret;
    }

    public void refreshUnchangedProps() {
        Properties savedChangedProps = this._changedProps;
        this.refreshProperties();
        Enumeration<Object> enumeration = savedChangedProps.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.setProperty(key, savedChangedProps.getProperty(key));
        }
    }

    public boolean isDiskNewer() {
        return this._userConfigFile != null && this._userConfigFile.exists() && this._userConfigFile.lastModified() > this._lastChanged;
    }

    private static boolean isPropertyCachable(String key) {
        for (int i = 0; i < UNCACHABLE_PROPS.length; ++i) {
            if (!UNCACHABLE_PROPS[i].equals(key)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidExpiredDecisionKey(String key) {
        if (key.equals("deployment.expiration.decision." + SecurityBaseline.getDeployVersion())) {
            return true;
        }
        if (key.equals("deployment.expiration.decision.timestamp." + SecurityBaseline.getDeployVersion())) {
            return true;
        }
        if (key.equals("deployment.expiration.decision.suppression." + SecurityBaseline.getDeployVersion())) {
            return true;
        }
        return key.equals("deployment.expiration.decision.ttl." + SecurityBaseline.getDeployVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfig() {
        Properties pending;
        if (!this._userConfigStore) {
            return;
        }
        if (this._dirty && this.isDiskNewer()) {
            Properties savedChangedProps = this._changedProps;
            this.refreshProperties();
            Enumeration<Object> enumeration = savedChangedProps.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                this.setProperty(key, savedChangedProps.getProperty(key));
            }
        }
        if ((pending = Platform.get().getPendingConfigProperties()) != null) {
            Object key = "deployment.webjava.enabled";
            String value = pending.getProperty((String)key);
            if (value != null) {
                this.setProperty((String)key, value);
            }
            if ((value = pending.getProperty((String)(key = "deployment.expiration.decision." + SecurityBaseline.getDeployVersion()))) != null) {
                this.setProperty((String)key, value);
            }
            if ((value = pending.getProperty((String)(key = "deployment.expiration.decision.timestamp." + SecurityBaseline.getDeployVersion()))) != null) {
                this.setProperty((String)key, value);
            }
            if ((value = pending.getProperty((String)(key = "deployment.expiration.decision.suppression." + SecurityBaseline.getDeployVersion()))) != null) {
                this.setProperty((String)key, value);
            }
        }
        Properties p = new Properties();
        Properties jp = new Properties();
        Properties toCache = new Properties();
        Enumeration<Object> en = this.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = this.getProperty(key);
            String sysVal = this._systemProps.getProperty(key);
            String defVal = ClientConfig.getDefaults().getProperty(key);
            if (this.isInternalProp(key) || key.startsWith("deployment.expiration.decision.") && !ClientConfig.isValidExpiredDecisionKey(key)) continue;
            if (!this.isPropertyLocked(key) && (value == null || sysVal != null && !value.equals(sysVal) || sysVal == null && !value.equals(defVal))) {
                p.setProperty(key, value);
            }
            if (value != null && value.equals(defVal) || !ClientConfig.isPropertyCachable(key)) continue;
            toCache.setProperty(key, value);
        }
        JREInfo[] jres = JREInfo.getAll();
        int jreIndex = 0;
        for (int i = 0; i < jres.length; ++i) {
            if (jres[i].isSystemJRE() || Environment.isForcedJreRoot(jres[i].getPath())) continue;
            if (jres[i].getPlatform() != null) {
                jp.setProperty("deployment.javaws.jre." + jreIndex + ".platform", jres[i].getPlatform());
            }
            if (jres[i].getProduct() != null) {
                jp.setProperty("deployment.javaws.jre." + jreIndex + ".product", jres[i].getProduct());
            }
            if (jres[i].getLocation() != null) {
                jp.setProperty("deployment.javaws.jre." + jreIndex + ".location", jres[i].getLocation());
            }
            if (jres[i].getPath() != null) {
                jp.setProperty("deployment.javaws.jre." + jreIndex + ".path", jres[i].getPath());
            }
            if (jres[i].getVmArgs() != null) {
                jp.setProperty("deployment.javaws.jre." + jreIndex + ".args", jres[i].getVmArgs());
            }
            if (jres[i].getOSArch() != null) {
                jp.setProperty("deployment.javaws.jre." + jreIndex + ".osarch", jres[i].getOSArch());
            }
            if (jres[i].getOSName() != null) {
                jp.setProperty("deployment.javaws.jre." + jreIndex + ".osname", jres[i].getOSName());
            }
            jp.setProperty("deployment.javaws.jre." + jreIndex + ".enabled", ClientConfig.booleanToString(jres[i].isEnabled()));
            jp.setProperty("deployment.javaws.jre." + jreIndex + ".registered", ClientConfig.booleanToString(jres[i].isRegistered()));
            ++jreIndex;
        }
        this._userConfigFile.getParentFile().mkdirs();
        try {
            p.setProperty("deployment.modified.timestamp", String.valueOf(System.currentTimeMillis()));
            SyncFileAccess.FileOutputStreamLock fosL = this._userConfigFileSyncAccess.openLockFileOutputStream(false, 2000, false);
            FileOutputStream fos = fosL != null ? fosL.getFileOutputStream() : new FileOutputStream(this._userConfigFile);
            try {
                if (fos != null) {
                    try {
                        p.store(fos, ClientConfig.getPropertiesFilename());
                        jp.store(fos, "Java Deployment jre's");
                    }
                    catch (IOException ioe) {
                        Trace.println("Exception: " + ioe, TraceLevel.BASIC);
                    }
                }
            }
            finally {
                if (fos != null) {
                    fos.flush();
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fosL != null) {
                    fosL.release();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._dirty = false;
        this._changedProps.clear();
        if (SecurityBaseline.isExpired()) {
            toCache.setProperty("deployment.expired.version", SecurityBaseline.getDeployVersion());
        }
        Platform.get().cacheCurrentConfig(toCache);
        this._lastChanged = this._userConfigFile.exists() ? this._userConfigFile.lastModified() : System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile(Properties props, File file) {
        SyncFileAccess.FileInputStreamLock fisL = null;
        FileInputStream fis = null;
        try {
            fisL = file.equals(this._userConfigFile) ? this._userConfigFileSyncAccess.openLockFileInputStream(1000, false) : null;
            fis = fisL != null ? fisL.getFileInputStream() : new FileInputStream(file);
            props.load(fis);
            Properties properties = props;
            return properties;
        }
        catch (FileNotFoundException fnfe) {
            Trace.println("Cannot find prop file: " + file.getAbsolutePath(), TraceLevel.BASIC);
            Properties properties = null;
            return properties;
        }
        catch (IOException ioe) {
            Trace.println("IO Execption: " + ioe, TraceLevel.BASIC);
            Properties properties = null;
            return properties;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fisL != null) {
                fisL.release();
            }
        }
    }

    private Properties getInternalProps() {
        Properties p = new Properties();
        p.setProperty("deployment.javafx.mode.enabled", "true");
        return p;
    }

    public boolean isInternalProp(String key) {
        return this._internalProps.containsKey(key) || key.startsWith("active.");
    }

    void setInitVersionOverride(String version) {
        this.initVersionOverride = version;
    }

    private void versionUpdateCheck() {
        String curSecLevel;
        VersionID ver;
        String verString;
        String currentDeployVersion = ClientConfig.isDeployVersionAtLeast11() ? "8" : "7.21";
        String string = verString = this.initVersionOverride == null ? currentDeployVersion : this.initVersionOverride;
        if (this._userConfigStore) {
            verString = this.getProperty("deployment.version");
        }
        VersionID versionID = ver = verString == null ? null : new VersionID(verString);
        if (ver == null || new VersionID("1.5.0").isGreaterThan(ver)) {
            String oldDefault;
            String path;
            Properties p1 = this.translateMantisProperties(this);
            if (p1.getProperty("deployment.javaws.cachedir") == null && new File(path = ClientConfig.getUserHome() + File.separator + "javaws" + File.separator + "cache").exists()) {
                p1.setProperty("deployment.javaws.cachedir", path);
            }
            Properties p2 = null;
            File home = new File(ClientConfig.getUserHome());
            String dir = home.getParent() + File.separator + ".deployment";
            String path2 = dir + File.separator + "deployment.properties";
            File propFile = new File(path2);
            if (propFile.exists() && (p2 = this.translateMantisProperties(this.loadPropertiesFile(new Properties(), propFile))).getProperty("deployment.javaws.cachedir") == null && new File(oldDefault = dir + File.separator + "javaws" + File.separator + "cache").exists()) {
                p2.setProperty("deployment.javaws.cachedir", oldDefault);
            }
            if (p2 != null) {
                this.setProperties(p2);
            }
            if (p1 != null) {
                this.setProperties(p1);
            }
            this.setProperty("deployment.browser.path", Platform.get().getBrowserPath());
            ver = new VersionID("1.5.0");
        }
        if (new VersionID("6.0").isGreaterThan(ver)) {
            this.setProperties(this.translateTigerProperties(this));
            ClientConfig.setBooleanProperty("deployment.javaws.cache.update", true);
            ClientConfig.setBooleanProperty("deployment.javapi.cache.update", true);
            ClientConfig.setBooleanProperty("deployment.capture.mime.types", true);
        }
        if (new VersionID("7.0").isGreaterThan(ver)) {
            // empty if block
        }
        if (!"VERY_HIGH".equals(curSecLevel = this.getProperty("deployment.security.level"))) {
            this.setProperty("deployment.security.level", "HIGH");
        }
        this.setProperty("deployment.version", currentDeployVersion);
    }

    private void setProperties(Properties p) {
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.setProperty(key, p.getProperty(key));
        }
    }

    private Properties translateMantisProperties(Properties p) {
        Properties out = new Properties();
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String newKey = null;
            String value = p.getProperty(key);
            if (key.startsWith("deployment.javaws.proxy")) {
                if (key.equals("deployment.javaws.proxy.httpport")) {
                    newKey = "deployment.proxy.http.port";
                } else if (key.equals("deployment.javaws.proxy.http")) {
                    newKey = "deployment.proxy.http.host";
                } else if (key.equals("deployment.javaws.proxy.httpproxyoverride")) {
                    newKey = "deployment.proxy.override.hosts";
                }
            } else if (key.startsWith("deployment.javaws.")) {
                if (key.equals("deployment.javaws.logFileName")) {
                    newKey = "deployment.javaws.traceFileName";
                } else if (key.equals("deployment.javaws.showConsole")) {
                    if (value.equals("true")) {
                        newKey = "deployment.console.startup.mode";
                        value = "SHOW";
                    }
                } else if (key.equals("deployment.javaws.updateTimeout")) {
                    newKey = "deployment.javaws.update.timeout";
                } else if (key.equals("deployment.javaws.version")) {
                    value = null;
                }
            } else if (key.startsWith("javaplugin")) {
                out.setProperty(key, value);
                if (key.equals("javaplugin.cache.disabled")) {
                    newKey = "deployment.cache.enabled";
                    value = value.equals("true") ? "false" : "true";
                } else if (key.equals("javaplugin.cache.size")) {
                    newKey = "deployment.cache.max.size";
                } else if (key.equals("javaplugin.cache.compression")) {
                    newKey = "deployment.cache.jarcompression";
                } else if (key.equals("javaplugin.console")) {
                    newKey = "deployment.console.startup.mode";
                    value = value.equals("show") ? "SHOW" : (value.equals("hide") ? "HIDE" : "DISABLE");
                } else if (key.equals("javaplugin.exception")) {
                    newKey = "deployment.javapi.lifecycle.exception";
                }
            }
            if (newKey == null || value == null || value.length() <= 0) continue;
            out.setProperty(newKey, value);
        }
        String cachePath = p.getProperty("deployment.javaws.cache.dir");
        if (cachePath != null) {
            out.setProperty("deployment.javaws.cachedir", cachePath);
        }
        return out;
    }

    private Properties translateTigerProperties(Properties p) {
        Properties out = new Properties();
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = p.getProperty(key);
            if (key.equals("deployment.javaws.associations") && (value.equals("NEW_ONLY") || value.equals("REPLACE_ASK"))) {
                value = "ASK_USER";
            }
            out.setProperty(key, value);
        }
        return out;
    }

    @Override
    public boolean getSponsorOffersDisabledSettings() {
        boolean isSponsorOfferDisabled = Platform.get().getSponsorOffersDisabledSettings();
        this.setProperty("install.disable.sponsor.offers", Boolean.toString(isSponsorOfferDisabled));
        return isSponsorOfferDisabled;
    }

    @Override
    public boolean useRoamingProfile() {
        final String roamingUserPropertiesFile = ClientConfig.getRoamingUserPropertiesFile();
        if (roamingUserPropertiesFile != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean isRoamingProfileEnabled = new File(roamingUserPropertiesFile).exists();
                    ClientConfig.this.setProperty("deployment.roaming.profile", Boolean.toString(isRoamingProfileEnabled));
                    return isRoamingProfileEnabled;
                }
            }, ACC_FILE_INSTANCE);
        }
        return false;
    }

    void lockProperty(String key, String value) {
        if (this._lockedProps == null) {
            this._lockedProps = new Properties();
        }
        this._lockedProps.setProperty(key, value);
    }

    void unlockProperty(String key) {
        if (this._lockedProps != null) {
            this._lockedProps.remove(key);
        }
    }

    @Override
    public boolean isPropertyLocked(String key) {
        if (this._lockedProps == null) {
            return false;
        }
        return this._lockedProps.containsKey(key);
    }

    @Override
    public void storeIfNeeded() {
        if (this._dirty) {
            this.storeConfig();
        }
    }

    @Override
    public void refreshIfNeeded() {
        if (!this._dirty && this.isDiskNewer()) {
            this.refreshProperties();
        }
    }

    @Override
    public boolean updateJREs() {
        if (JREInfo.updateJREs()) {
            this._dirty = true;
            this.storeIfNeeded();
            return true;
        }
        return false;
    }

    @Override
    public String getEnterpriseString() {
        return this._enterprizeConfig;
    }

    @Override
    public boolean isValid() {
        return this._configOK;
    }

    @Override
    public boolean isConfigDirty() {
        return this._dirty;
    }

    @Override
    public void markAsDirty() {
        this._dirty = true;
    }

    @Override
    public Properties getSystemProps() {
        return this._systemProps;
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        perms = new Permissions();
        Permission perm1 = new FilePermission("<<ALL FILES>>", "read");
        ((PermissionCollection)perms).add(perm1);
        RuntimePermission perm2 = new RuntimePermission("getenv.*");
        ((PermissionCollection)perms).add(perm2);
        Permission perm3 = new PropertyPermission("*", "read");
        ((PermissionCollection)perms).add(perm3);
        ACC_REFRESH_PROP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        perms = new Permissions();
        perm1 = new PropertyPermission("*", "read,write");
        ((PermissionCollection)perms).add(perm1);
        perm2 = new RuntimePermission("getenv.*");
        ((PermissionCollection)perms).add(perm2);
        perm3 = new FilePermission("<<ALL FILES>>", "read");
        ((PermissionCollection)perms).add(perm3);
        SecurityPermission perm4 = new SecurityPermission("setProperty.policy.url.*");
        ((PermissionCollection)perms).add(perm4);
        SecurityPermission perm5 = new SecurityPermission("getProperty.policy.url.*");
        ((PermissionCollection)perms).add(perm5);
        ((PermissionCollection)perms).add(new SecurityPermission("getPolicy"));
        ACC_PROP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        UNCACHABLE_PROPS = new String[]{"deployment.javaws.viewer.bounds"};
    }
}

