/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.xml.XMLAttribute;
import java.io.PrintWriter;
import java.io.StringWriter;

public class XMLNode {
    private boolean _isElement;
    private String _name;
    private XMLAttribute _attr;
    private XMLNode _parent;
    private XMLNode _nested;
    private XMLNode _next;
    public static final String WILDCARD = "*";

    public XMLNode(String name) {
        this._isElement = false;
        this._name = name;
        this._attr = null;
        this._nested = null;
        this._next = null;
        this._parent = null;
    }

    public XMLNode(String name, XMLAttribute attr) {
        this(name, attr, null, null);
    }

    public XMLNode(String name, XMLAttribute attr, XMLNode nested, XMLNode next) {
        this._isElement = true;
        this._name = XMLNode.stripNameSpace(name);
        this._attr = attr;
        this._nested = nested;
        this._next = next;
        this._parent = null;
    }

    public String getName() {
        return this._name;
    }

    public XMLAttribute getAttributes() {
        return this._attr;
    }

    public XMLNode getNested() {
        return this._nested;
    }

    public XMLNode getNext() {
        return this._next;
    }

    public boolean isElement() {
        return this._isElement;
    }

    public void setParent(XMLNode parent) {
        this._parent = parent;
    }

    public XMLNode getParent() {
        return this._parent;
    }

    public void setNext(XMLNode next) {
        this._next = next;
    }

    public void setNested(XMLNode nested) {
        this._nested = nested;
    }

    public static String stripNameSpace(String name) {
        int i;
        if (name != null && !name.startsWith("xmlns:") && (i = name.lastIndexOf(":")) >= 0 && i < name.length()) {
            return name.substring(i + 1);
        }
        return name;
    }

    public boolean equalsTemplate(Object o) {
        if (o == null || !(o instanceof XMLNode)) {
            return false;
        }
        XMLNode other = (XMLNode)o;
        boolean result = this.matchTemplateName(other._name) && XMLNode.matchTemplateAttribute(this._attr, other._attr) && XMLNode.matchTemplateNode(this._nested, other._nested) && XMLNode.matchTemplateNode(this._next, other._next);
        return result;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (this._name != null ? this._name.hashCode() : 0);
        hash = 83 * hash + (this._attr != null ? this._attr.hashCode() : 0);
        hash = 83 * hash + (this._nested != null ? this._nested.hashCode() : 0);
        hash = 83 * hash + (this._next != null ? this._next.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XMLNode)) {
            return false;
        }
        XMLNode other = (XMLNode)o;
        boolean result = XMLNode.match(this._name, other._name) && XMLNode.match(this._attr, other._attr) && XMLNode.match(this._nested, other._nested) && XMLNode.match(this._next, other._next);
        return result;
    }

    public String getAttribute(String name) {
        for (XMLAttribute cur = this._attr; cur != null; cur = cur.getNext()) {
            if (!name.equals(cur.getName())) continue;
            return cur.getValue();
        }
        return "";
    }

    private static boolean match(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private boolean matchTemplateName(String name) {
        if (this._name == null) {
            return name == null;
        }
        if (this._name.equals(name)) {
            return true;
        }
        return !this._isElement && name.equals(WILDCARD);
    }

    private static boolean matchTemplateNode(XMLNode n1, XMLNode n2) {
        if (n1 == null) {
            return n2 == null;
        }
        return n1.equalsTemplate(n2);
    }

    private static boolean matchTemplateAttribute(XMLAttribute a1, XMLAttribute a2) {
        if (a1 == null) {
            return a2 == null;
        }
        return a1.equalsTemplate(a2);
    }

    public void printToStream(PrintWriter out) {
        this.printToStream(out, false);
    }

    public void printToStream(PrintWriter out, boolean trim) {
        this.printToStream(out, 0, trim);
    }

    public void printToStream(PrintWriter out, int n, boolean trim) {
        if (!this.isElement()) {
            String value = this._name;
            if (trim && value.length() > 512) {
                value = "...";
            }
            out.print(value);
        } else if (this._nested == null) {
            String attrString = this._attr == null ? "" : " " + this._attr.toString();
            XMLNode.lineln(out, n, "<" + this._name + attrString + "/>");
        } else {
            String attrString = this._attr == null ? "" : " " + this._attr.toString();
            XMLNode.lineln(out, n, "<" + this._name + attrString + ">");
            this._nested.printToStream(out, n + 1, trim);
            if (this._nested.isElement()) {
                XMLNode.lineln(out, n, "</" + this._name + ">");
            } else {
                out.print("</" + this._name + ">");
            }
        }
        if (this._next != null) {
            this._next.printToStream(out, n, trim);
        }
    }

    private static void lineln(PrintWriter out, int indent, String s) {
        out.println("");
        for (int i = 0; i < indent; ++i) {
            out.print("  ");
        }
        out.print(s);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean hideLongElementValue) {
        StringWriter sw = new StringWriter(1000);
        PrintWriter pw = new PrintWriter(sw);
        this.printToStream(pw, hideLongElementValue);
        pw.close();
        return sw.toString();
    }
}

