/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.DynamicProxyManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.List;

public class DeployProxySelector
extends ProxySelector {
    public static void reset() {
        DynamicProxyManager.reset();
        ProxySelector.setDefault(new DeployProxySelector());
    }

    protected URL getURLFromURI(URI uri, boolean isSocketURI) {
        String auth;
        if (uri == null) {
            return null;
        }
        int port = uri.getPort();
        String host = uri.getHost();
        if (host == null && (auth = uri.getAuthority()) != null) {
            int i = auth.indexOf(64);
            if (i >= 0) {
                auth = auth.substring(i + 1);
            }
            if ((i = auth.lastIndexOf(58)) >= 0) {
                try {
                    port = Integer.parseInt(auth.substring(i + 1));
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
                auth = auth.substring(0, i);
            }
            host = auth;
        }
        URL url = null;
        try {
            String scheme = uri.getScheme();
            url = isSocketURI ? (port == -1 ? new URL("http://" + host + "/") : new URL("http://" + host + ":" + port + "/")) : uri.toURL();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return url;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        boolean isSocketURI = scheme.equalsIgnoreCase("socket") || scheme.equalsIgnoreCase("serversocket");
        URL url = this.getURLFromURI(uri, isSocketURI);
        List<Proxy> proxyList = null;
        try {
            proxyList = DynamicProxyManager.getProxyList(url, isSocketURI);
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.msgNetPrintln("net.proxy.connect", new Object[]{uri, proxyList.get(0)});
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return proxyList;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.msgNetPrintln("net.proxy.connectionFailure", new Object[]{uri.toString() + ", " + sa.toString() + ioe.toString()});
        }
        try {
            DynamicProxyManager.removeProxyFromCache(uri.toURL(), sa.toString());
        }
        catch (Exception e) {
            Trace.securityPrintException(e);
        }
    }
}

