/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.offline;

import com.sun.deploy.net.offline.NeverOfflineHandler;
import com.sun.deploy.net.offline.OfflineHandler;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import java.net.URL;

public class DeployOfflineManager {
    private static OfflineHandler handler = new NeverOfflineHandler();
    private static boolean forcedOffline = false;

    public static void setForcedOffline(boolean offline) {
        forcedOffline = offline;
    }

    public static boolean promptUserGoOnline(URL u) {
        if (DeployOfflineManager.isGlobalOffline() && !DeployOfflineManager.isForcedOffline() && !DeployOfflineManager.askUserGoOnline(u)) {
            DeployOfflineManager.setForcedOffline(true);
            return false;
        }
        return true;
    }

    public static boolean isForcedOffline() {
        return forcedOffline;
    }

    public static void reset() {
        Service service = ServiceManager.getService();
        handler = service.getOfflineHandler();
        if (handler == null) {
            handler = new NeverOfflineHandler();
        }
    }

    public static boolean isGlobalOffline() {
        if (forcedOffline) {
            return true;
        }
        return handler.isGlobalOffline();
    }

    public static boolean setGlobalOffline(boolean offline) {
        return handler.setGlobalOffline(offline);
    }

    public static boolean askUserGoOnline(URL url) {
        if (forcedOffline) {
            return false;
        }
        return handler.askUserGoOnline(url);
    }
}

