/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.HttpCookie;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

abstract class CookieStore {
    protected transient TreeMap<String, ArrayList<HttpCookie>> cookieJar = new TreeMap();

    CookieStore() {
    }

    public void recordCookie(HttpCookie cookie) {
        if (this.shouldRejectCookie(cookie)) {
            return;
        }
        this.loadCookieJar();
        String domain = cookie.getDomain().toLowerCase();
        ArrayList<HttpCookie> cookieList = this.cookieJar.get(domain);
        if (cookieList == null) {
            cookieList = new ArrayList();
        }
        if (this.addOrReplaceCookie(cookieList, cookie)) {
            this.cookieJar.put(domain, cookieList);
            this.saveCookieJar();
        }
    }

    protected abstract void loadCookieJar();

    protected abstract void saveCookieJar();

    protected abstract String getName();

    protected boolean addOrReplaceCookie(ArrayList<HttpCookie> cookies, HttpCookie cookie) {
        int numCookies = cookies.size();
        String path = cookie.getPath();
        String name = cookie.getName();
        HttpCookie replaced = null;
        int replacedIndex = -1;
        for (int i = 0; i < numCookies; ++i) {
            String existingName;
            HttpCookie existingCookie = cookies.get(i);
            String existingPath = existingCookie.getPath();
            if (!path.equals(existingPath) || !name.equals(existingName = existingCookie.getName())) continue;
            replaced = existingCookie;
            replacedIndex = i;
            break;
        }
        if (replaced != null) {
            cookies.set(replacedIndex, cookie);
        } else {
            cookies.add(cookie);
        }
        return true;
    }

    protected boolean shouldRejectCookie(HttpCookie cookie) {
        return cookie.getDomain() == null || cookie.getPath() == null || cookie.getName() == null;
    }

    public String getRelevantCookies(URL url) {
        int index;
        this.loadCookieJar();
        String host = url.getHost();
        Object cookieValue = this.getCookiesForHost(host, url);
        while ((index = host.indexOf(46, 1)) >= 0) {
            String value = this.getCookiesForHost(host = host.substring(index + 1), url);
            if (value == null) continue;
            if (cookieValue == null) {
                cookieValue = value;
                continue;
            }
            cookieValue = (String)cookieValue + "; " + value;
        }
        return cookieValue;
    }

    private String getCookiesForHost(String host, URL url) {
        ArrayList<HttpCookie> cookieList = this.cookieJar.get(host);
        if (cookieList == null) {
            return null;
        }
        String path = url.getFile();
        int queryInd = path.indexOf(63);
        if (queryInd > 0) {
            path = path.substring(0, queryInd);
        }
        Iterator<HttpCookie> cookies = cookieList.iterator();
        ArrayList<HttpCookie> cookiesToSend = new ArrayList<HttpCookie>(10);
        while (cookies.hasNext()) {
            String protocol;
            HttpCookie cookie = cookies.next();
            String cookiePath = cookie.getPath();
            if (!path.startsWith(cookiePath) || cookie.hasExpired() || !(protocol = url.getProtocol()).equals("https") && (!protocol.equals("http") || cookie.isSecure())) continue;
            cookiesToSend.add(cookie);
        }
        Collections.sort(cookiesToSend);
        cookies = cookiesToSend.iterator();
        StringBuffer cookieBuffer = null;
        while (cookies.hasNext()) {
            HttpCookie cookie = cookies.next();
            if (cookieBuffer == null) {
                cookieBuffer = new StringBuffer(cookie.getNameValue());
                continue;
            }
            cookieBuffer.append("; ").append(cookie.getNameValue());
        }
        if (cookieBuffer == null) {
            return null;
        }
        return cookieBuffer.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("\n[\n");
        for (List list : this.cookieJar.values()) {
            for (HttpCookie cookie : list) {
                sb.append("\t");
                sb.append(cookie.toString());
                sb.append("\n");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

