/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

final class HttpDownloadHelper
implements HttpDownload {
    private static final int BUF_SIZE = 32768;
    private static final int BUFFER_SIZE = 8192;
    private static final String JAR_FILE_EXT = ".jar";
    private static final String JARJAR_FILE_EXT = ".jarjar";
    private static final String META_FILE_DIR = "meta-inf/";
    private HttpRequest _httpRequest;
    private static int jarCompression = -1;

    public HttpDownloadHelper(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    private static int getJarCompressionLevel() {
        if (jarCompression == -1) {
            String prop = Config.getStringProperty("deployment.cache.jarcompression");
            prop = prop.trim();
            try {
                jarCompression = Integer.valueOf(prop);
                if (jarCompression < 0 || jarCompression > 9) {
                    jarCompression = 0;
                }
            }
            catch (NumberFormatException e) {
                jarCompression = 0;
            }
        }
        return jarCompression;
    }

    static int checkAndNotifyProgress(Pack200.Unpacker unpacker, HttpDownloadListener listener, int previousValue, int total) {
        SortedMap props = unpacker.properties();
        String progress = (String)props.get("unpack.progress");
        if (progress == null) {
            return previousValue;
        }
        int newValue = Integer.parseInt(progress);
        if (listener != null && newValue != previousValue) {
            try {
                listener.downloadProgress(newValue * total / 100, total);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
        return newValue;
    }

    static void unpack(Pack200.Unpacker unpacker, InputStream in, JarOutputStream out, HttpDownloadListener listener, int total) throws IOException {
        IOException ioe;
        UnpackerTask task = new UnpackerTask(unpacker, in, out);
        Thread t = SafeThreadFactory.createThread(task);
        t.start();
        int progress = 0;
        boolean interrupted = false;
        while (t.isAlive()) {
            progress = HttpDownloadHelper.checkAndNotifyProgress(unpacker, listener, progress, total);
            try {
                t.join(200L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        HttpDownloadHelper.checkAndNotifyProgress(unpacker, listener, progress, total);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if ((ioe = task.ioe()) != null) {
            throw ioe;
        }
    }

    public MessageHeader download(int contentLength, URL url, InputStream in, String encoding, File file, HttpDownloadListener dl, int contentType) throws CanceledDownloadException, IOException {
        return this.download(contentLength, url, in, encoding, file, dl, contentType, true);
    }

    @Override
    public MessageHeader download(int contentLength, URL url, InputStream in, String encoding, File file, HttpDownloadListener dl, int contentType, boolean uncompress) throws CanceledDownloadException, IOException {
        MessageHeader adjustment = null;
        boolean doGUnzip = HttpDownloadHelper.needsGUnzip(uncompress, encoding);
        int length = contentLength;
        if (dl != null) {
            dl.downloadProgress(0, length);
        }
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", url == null ? "" : url.toString(), contentLength, encoding), TraceLevel.NETWORK);
        }
        OutputStream out = null;
        ZipOutputStream jarout = null;
        ZipInputStream zin = null;
        ZipInputStream jarjarIn = null;
        boolean deleteFile = false;
        try {
            out = Platform.get().getNativeSandboxBroker().getOutputStream(file, true);
            if ("pack200-gzip".equals(encoding)) {
                Pack200.Unpacker upkr200 = Pack200.newUnpacker();
                JarOutputStream jout = new JarOutputStream(out);
                if (Environment.isJavaPlugin() && HttpDownloadHelper.getJarCompressionLevel() != 0) {
                    jout.setLevel(HttpDownloadHelper.getJarCompressionLevel());
                }
                HttpDownloadHelper.unpack(upkr200, new GZIPInputStream(in), jout, dl, length);
                jout.close();
                adjustment = this.createHeaderAdjustment(file.length(), null);
            } else {
                String plainUrl = HttpUtils.removeQueryStringFromURL(url).toString().toLowerCase();
                String actualEncoding = encoding;
                if (this.isJarOrJarjar(plainUrl) && (!HttpUtils.hasGzipEncoding(encoding) || doGUnzip)) {
                    jarout = new JarOutputStream(out);
                    if (HttpDownloadHelper.getJarCompressionLevel() != 0) {
                        jarout.setLevel(HttpDownloadHelper.getJarCompressionLevel());
                    }
                    if (doGUnzip) {
                        zin = new ZipInputStream(new GZIPInputStream((InputStream)new BufferedInputStream(in), 8192));
                        this.decompressWrite(zin, jarout, length, dl);
                        actualEncoding = HttpUtils.removeGzipEncoding(encoding);
                    } else {
                        ZipEntry entry;
                        zin = new ZipInputStream(new BufferedInputStream(in, 8192));
                        if (plainUrl.endsWith(JARJAR_FILE_EXT)) {
                            Trace.msgPrintln("cache.jarjar.deprecated", new Object[]{plainUrl});
                            entry = zin.getNextEntry();
                            while (entry != null) {
                                if (entry.toString().toLowerCase().startsWith(META_FILE_DIR)) {
                                    entry = zin.getNextEntry();
                                    continue;
                                }
                                if (entry.toString().toLowerCase().endsWith(JAR_FILE_EXT)) break;
                                throw new IOException("cache.jarjar.invalid_file");
                            }
                            jarjarIn = zin;
                            zin = new ZipInputStream(zin);
                        }
                        this.decompressWrite(zin, jarout, length, dl);
                        if (jarjarIn != null && (entry = jarjarIn.getNextEntry()) != null) {
                            String msg = null;
                            msg = !entry.toString().toLowerCase().endsWith(JAR_FILE_EXT) ? "cache.jarjar.invalid_file" : "cache.jarjar.multiple_jar";
                            throw new IOException(msg);
                        }
                    }
                    if (jarout != null) {
                        jarout.close();
                        jarout = null;
                    }
                    adjustment = this.createHeaderAdjustment(file.length(), actualEncoding);
                } else {
                    FilterInputStream is = new BufferedInputStream(in);
                    if (doGUnzip) {
                        is = new GZIPInputStream((InputStream)is, 8192);
                        actualEncoding = HttpUtils.removeGzipEncoding(encoding);
                    }
                    int read = 0;
                    int totalRead = 0;
                    byte[] buf = new byte[32768];
                    int i = 0;
                    while ((read = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
                        if (DownloadEngine.isJarContentType(contentType) && i == 0 && !DownloadEngine.isJarHeaderValid(buf)) {
                            throw new IOException("Invalid jar file");
                        }
                        out.write(buf, 0, read);
                        totalRead += read;
                        if (dl != null) {
                            int downloaded = totalRead;
                            if (downloaded > length && length != 0) {
                                downloaded = length;
                            }
                            dl.downloadProgress(downloaded, length);
                        }
                        ++i;
                    }
                    if (doGUnzip) {
                        adjustment = this.createHeaderAdjustment(totalRead, actualEncoding);
                    }
                }
            }
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("httpDownloadHelper.wroteUrlToFile", url == null ? "" : url.toString(), file == null ? "" : file.toString()), TraceLevel.NETWORK);
            }
        }
        catch (IOException ioe) {
            deleteFile = true;
            throw ioe;
        }
        finally {
            if (jarjarIn != null) {
                jarjarIn.close();
            } else if (zin != null) {
                zin.close();
            } else if (in != null) {
                in.close();
            }
            if (jarout != null) {
                jarout.close();
            } else if (out != null) {
                out.close();
            }
            if (deleteFile && file != null) {
                Platform.get().getNativeSandboxBroker().deleteFile(file);
            }
        }
        if (dl != null) {
            dl.downloadProgress(length, length);
        }
        return adjustment;
    }

    private static boolean needsGUnzip(boolean uncompress, String encoding) {
        return uncompress && HttpUtils.hasGzipEncoding(encoding);
    }

    private MessageHeader createHeaderAdjustment(long contentLength, String encoding) {
        MessageHeader res = new MessageHeader();
        res.add("content-encoding", encoding);
        String length = contentLength > -1L ? String.valueOf(contentLength) : null;
        res.add("content-length", length);
        return res;
    }

    private void decompressWrite(ZipInputStream in, ZipOutputStream out, int length, HttpDownloadListener dl) throws IOException {
        byte[] buffer = new byte[8192];
        ZipEntry entry = in.getNextEntry();
        int totalRead = 0;
        while (entry != null) {
            ZipEntry outEntry = (ZipEntry)entry.clone();
            outEntry.setCompressedSize(-1L);
            out.putNextEntry(outEntry);
            int read = 0;
            while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, read);
                if ((totalRead += read) > length && length != 0) {
                    totalRead = length;
                }
                if (dl == null) continue;
                dl.downloadProgress(totalRead, length);
            }
            out.closeEntry();
            entry = in.getNextEntry();
        }
        out.flush();
    }

    private boolean isJarOrJarjar(String url) {
        return url.endsWith(JAR_FILE_EXT) || url.endsWith(JARJAR_FILE_EXT);
    }

    private static class UnpackerTask
    implements Runnable {
        private final Pack200.Unpacker unpacker;
        private final InputStream in;
        private final JarOutputStream out;
        private volatile IOException ioe;

        UnpackerTask(Pack200.Unpacker unpacker, InputStream in, JarOutputStream out) {
            this.unpacker = unpacker;
            this.in = in;
            this.out = out;
        }

        IOException ioe() {
            return this.ioe;
        }

        @Override
        public void run() {
            try {
                this.unpacker.unpack(this.in, this.out);
            }
            catch (IOException x) {
                this.ioe = x;
            }
        }
    }
}

