/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.Cache6Upgrader;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.CacheUpgradeHelper;
import com.sun.deploy.cache.UpgradeStatus;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.FileTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.VersionString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;

abstract class CacheUpgrader {
    private static CacheUpgrader instance;
    private static CacheUpgrader systemInstance;
    private static boolean backgroundRunning;
    private final String name;
    protected final File oldCacheDir;
    protected final File newCacheDir;
    protected UpgradeStatus old;
    protected UpgradeStatus current;
    private static final UpgradeStatus NOOP_STATUS;
    private static final String SEP;
    private static File oldDefaultCacheDir;
    private static File oldDefaultSystemCacheDir;

    protected CacheUpgrader(String name, File oldCacheDir, File newcacheDir) {
        this.name = name;
        this.oldCacheDir = oldCacheDir;
        this.newCacheDir = newcacheDir;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static synchronized CacheUpgrader getInstance() {
        File old6;
        if (instance == null && !Config.get().isCacheUpgradeSkipped() && UpgradeStatus.beenInitialized("Cache6Upgrader") && (old6 = CacheUpgrader.getOldDefaultCacheDir()) != null) {
            Cache6Upgrader cu;
            boolean isRelocated;
            File defaultCacheDir = new File(Config.get().getDefaultCacheVersionDirectory());
            File cacheDir = Cache.getCacheDir();
            boolean isDefaultCache = defaultCacheDir.equals(cacheDir);
            boolean bl = isRelocated = !old6.equals(cacheDir);
            if (isDefaultCache && isRelocated && !(cu = Cache6Upgrader.createInstance(false, old6, cacheDir)).isUpgradeDone()) {
                instance = cu;
                CacheUpgrader.startBackgroundUpgradeIfNeeded();
            }
        }
        if (instance == null) {
            instance = new NoopUpgrader();
        }
        return instance;
    }

    static synchronized CacheUpgrader getSystemInstance() {
        if (systemInstance == null && !Config.get().isCacheUpgradeSkipped() && UpgradeStatus.beenInitialized("SystemCache6Upgrader")) {
            File old6 = CacheUpgrader.getOldDefaultSystemCacheDir();
            File sysCacheDir = Cache.getSystemCacheDir();
            if (old6 != null && sysCacheDir != null) {
                Cache6Upgrader cu;
                boolean isRelocated;
                String path = Config.get().getDefaultSystemCacheVersionDirectory();
                File defaultSysCacheDir = path != null ? new File(path) : null;
                boolean isDefault = sysCacheDir.equals(defaultSysCacheDir);
                boolean bl = isRelocated = !old6.equals(sysCacheDir);
                if (isDefault && isRelocated && !(cu = Cache6Upgrader.createInstance(false, old6, sysCacheDir)).isUpgradeDone()) {
                    systemInstance = cu;
                    CacheUpgrader.startBackgroundUpgradeIfNeeded();
                }
            }
        }
        if (systemInstance == null) {
            systemInstance = new NoopUpgrader();
        }
        return systemInstance;
    }

    static void setInstance(CacheUpgrader testInstance) {
        instance = testInstance;
    }

    static void setSystemInstance(CacheUpgrader testInstance) {
        systemInstance = testInstance;
    }

    public void upgrade() throws IOException {
        if (this.oldCacheDir == null) {
            if (CacheUpgrader.isTracing()) {
                CacheUpgrader.trace(this + ": No old cache, no upgrade");
            }
            return;
        }
        if (!this.incrementUpgradeAttempts()) {
            return;
        }
        this.upgradeImpl();
        this.setUpgradeCompleted();
        if (CacheUpgrader.isTracing()) {
            CacheUpgrader.trace(this + ": End upgrade");
        }
    }

    public CacheEntry upgradeItem(URL itemRef, String version, int contentType) {
        if (this.oldCacheDir == null) {
            return null;
        }
        if (this.oldCacheDir.equals(this.newCacheDir)) {
            return null;
        }
        return this.upgradeItemImpl(itemRef, version, contentType);
    }

    protected abstract void upgradeImpl();

    protected abstract CacheEntry upgradeItemImpl(URL var1, String var2, int var3);

    protected UpgradeStatus getStatus() {
        this.old = this.current;
        this.current = UpgradeStatus.getUpgradeStatus(this.getName());
        return this.current;
    }

    protected boolean incrementUpgradeAttempts() {
        this.getStatus();
        int lastCount = this.old == null ? 0 : this.old.getUpgradeAttempts();
        return this.current.incrementUpgradeAttempt(lastCount);
    }

    protected void setUpgradeCompleted() {
        this.getStatus().setCompleted();
    }

    protected static File getOldDefaultCacheDir() {
        if (oldDefaultCacheDir == null) {
            oldDefaultCacheDir = CacheUpgrader.getOldDefaultCache6Dir();
        }
        if (oldDefaultCacheDir != null && SystemUtils.priviledgedIsDirectory(oldDefaultCacheDir)) {
            return oldDefaultCacheDir;
        }
        return null;
    }

    static void setOldDefaultCacheDir(File path) {
        oldDefaultCacheDir = path;
    }

    protected static File getOldDefaultSystemCacheDir() {
        if (oldDefaultSystemCacheDir == null) {
            oldDefaultSystemCacheDir = CacheUpgrader.getOldDefaultSystemCache6Dir();
        }
        if (oldDefaultSystemCacheDir != null && SystemUtils.priviledgedIsDirectory(oldDefaultSystemCacheDir)) {
            return oldDefaultSystemCacheDir;
        }
        return null;
    }

    static void setOldDefaultSystemCacheDir(File path) {
        oldDefaultSystemCacheDir = path;
    }

    static File getOldDefaultCache6Dir() {
        return new File(Config.getUserHome() + SEP + "cache" + SEP + "6.0");
    }

    static File getOldDefaultSystemCache6Dir() {
        return new File(Config.getUserHome() + SEP + "SystemCache" + SEP + "6.0");
    }

    protected CacheEntry getCacheEntryFromIndexFile(File indexFile) {
        CacheEntry ce = new CacheEntry(indexFile);
        if (ce != null && ce.isValidEntry()) {
            return ce;
        }
        return null;
    }

    protected CacheEntry getOldCacheEntry(URL href, String version, int contentType) {
        if (this.oldCacheDir == null) {
            throw new IllegalStateException("Should never called w/o old cache");
        }
        CacheEntry matched = null;
        File[] idxFiles = Cache.getMatchingIndexFiles(this.oldCacheDir, href);
        if (idxFiles != null) {
            File nativeDir;
            for (int i = 0; i < idxFiles.length; ++i) {
                CacheEntry ce = new CacheEntry(idxFiles[i]);
                if (!ce.isValidEntry() || !ce.getURL().equals(href.toString())) continue;
                matched = CacheUpgrader.getBetterMatch(version, ce, matched);
            }
            if (matched != null && DownloadEngine.isNativeContentType(contentType) && !(nativeDir = new File(matched.getNativeLibPath())).isDirectory()) {
                matched = null;
            }
        }
        return matched;
    }

    protected boolean resourcePresentInNewCache(URL href) {
        if (this.newCacheDir == null) {
            throw new IllegalStateException("Should never called w/o new cache");
        }
        File[] idxFiles = Cache.getMatchingIndexFiles(this.newCacheDir, href);
        return idxFiles != null && idxFiles.length > 0;
    }

    static CacheEntry getBetterMatch(String version, CacheEntry candidate, CacheEntry matched) {
        if (version == null) {
            if (candidate.getVersion() == null) {
                matched = candidate;
            } else if (matched != null && matched.getVersion() != null && candidate.getVersion().compareTo(matched.getVersion()) > 0) {
                matched = candidate;
            }
        } else if (new VersionString(version).contains(candidate.getVersion())) {
            if (matched == null) {
                matched = candidate;
            } else if (candidate.getVersion() != null && candidate.getVersion().compareTo(matched.getVersion()) > 0) {
                matched = candidate;
            }
        }
        return matched;
    }

    protected static void copyDirIgnoresErrors(File src, File dst) {
        CacheUpgrader.copyDirIgnoresErrors(src, dst, null);
    }

    protected static void copyDirIgnoresErrors(File src, File dst, FilenameFilter filter) {
        if (src.isDirectory()) {
            dst.mkdirs();
            File[] files = src.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                File source = files[i];
                File target = new File(dst, source.getName());
                if (files[i].isDirectory()) {
                    CacheUpgrader.copyDirIgnoresErrors(source, target, filter);
                    continue;
                }
                if (target.exists()) continue;
                try {
                    Cache.copyFile(source, target);
                    continue;
                }
                catch (IOException e) {
                    Trace.ignored(e);
                }
            }
        }
    }

    protected CacheEntry copyToNewCache(final CacheEntry oldEntry) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<CacheEntry>(){

                @Override
                public CacheEntry run() throws IOException {
                    return CacheUpgrader.this._copyToNewCache(oldEntry);
                }
            });
        }
        catch (Exception e) {
            Trace.ignoredException(e);
            return null;
        }
    }

    private CacheEntry _copyToNewCache(CacheEntry oldEntry) {
        if (CacheUpgrader.isTracing()) {
            CacheUpgrader.trace(this + " start copying entry: " + oldEntry.getDataFile());
        }
        CacheEntry ce = null;
        try {
            URL url = new URL(oldEntry.getURL());
            String version = oldEntry.getVersion();
            String cacheFileName = Cache.generateCacheFileName(url, version);
            File indexFile = new File(this.newCacheDir, cacheFileName + ".idx");
            ce = new CacheEntry(indexFile);
            File dataFile = new File(oldEntry.getResourceFilename());
            File newDataFile = new File(this.newCacheDir, cacheFileName);
            newDataFile.getParentFile().mkdirs();
            Cache.copyFile(dataFile, newDataFile);
            File nativeDir = new File(oldEntry.getNativeLibPath());
            if (nativeDir.isDirectory()) {
                CacheUpgrader.copyDirIgnoresErrors(nativeDir, new File(ce.getNativeLibPath()));
            }
            ce.setURL(url.toString());
            ce.setContentLength(oldEntry.getContentLength());
            ce.setLastModified(oldEntry.getLastModified());
            ce.setExpirationDate(oldEntry.getExpirationDate());
            if (version != null) {
                ce.setVersion(version);
            }
            ce.setHeaders(oldEntry.cloneHeaders());
            ce.setBusy(0);
            ce.setIncomplete(0);
            ce.writeFileToDisk();
            Cache.recordLastAccessed();
            if (ce.isJNLPFile()) {
                this.upgradeLocalAppProperties(ce, oldEntry);
            }
        }
        catch (Exception e) {
            if (ce != null) {
                Cache.removeCacheEntry(ce);
            }
            Trace.ignoredException(e);
            ce = null;
        }
        if (CacheUpgrader.isTracing()) {
            String upgraded = ce == null ? " failed" : ce.getDataFile() + " done.";
            System.out.println(this + " copy entry: " + upgraded);
        }
        return ce;
    }

    protected void upgradeLocalAppProperties(CacheEntry newEntry, CacheEntry oldEntry) {
        CacheUpgradeHelper.upgradeLocalAppProperties(newEntry, oldEntry);
    }

    boolean isUpgradeDone() {
        return this.getStatus().isDone();
    }

    private static String getClassPath() {
        String rtJar = SystemUtils.getJarPath(Object.class);
        File jsseJar = new File(rtJar, "jsse.jar");
        String myJar = SystemUtils.getJarPath(CacheUpgrader.class);
        return CacheUpgradeHelper.getHelperJarPaths() + ";" + myJar + ";" + rtJar + ";" + jsseJar.getPath();
    }

    private static synchronized void startBackgroundUpgradeIfNeeded() {
        if (backgroundRunning) {
            return;
        }
        backgroundRunning = true;
        try {
            if (CacheUpgrader.noBackgroundUpgradeStartedRecenty()) {
                final String[] cmd = new String[]{Environment.getJavawCommand(), "-Xbootclasspath:" + CacheUpgrader.getClassPath(), CacheUpgrader.class.getName()};
                if (CacheUpgrader.isTracing()) {
                    String cmdString = Arrays.asList(cmd).toString();
                    CacheUpgrader.trace("Starting background upgrade: " + cmdString);
                }
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        Process p = Runtime.getRuntime().exec(cmd);
                        Thread drainOut = SafeThreadFactory.createThread(new ProcesOutputHandler(p.getInputStream()));
                        drainOut.setDaemon(true);
                        drainOut.start();
                        Thread drainError = SafeThreadFactory.createThread(new ProcesOutputHandler(p.getErrorStream()));
                        drainError.setDaemon(true);
                        drainError.start();
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            Trace.ignored(e);
        }
    }

    private static boolean noBackgroundUpgradeStartedRecenty() throws IOException {
        return !CacheUpgrader.getInstance().isBackgroundUpgradeStartedRecenty() && !CacheUpgrader.getSystemInstance().isBackgroundUpgradeStartedRecenty();
    }

    boolean isBackgroundUpgradeStartedRecenty() {
        return this.getStatus().wasStartedRecently();
    }

    public static void setupServices() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Win")) {
            ServiceManager.setService(33024);
        } else if (osName.indexOf("OS X") != -1) {
            ServiceManager.setService(40960);
        } else {
            ServiceManager.setService(36864);
        }
    }

    private static void initTrace() {
        if (Config.getBooleanProperty("deployment.trace")) {
            File dir = new File(Config.getStringProperty("deployment.user.logdir"));
            if (dir.exists() && dir.isDirectory()) {
                FileTraceListener ftl = new FileTraceListener(new File(dir, "cacheUpgrade.trace"), false);
                Trace.addTraceListener(ftl);
            }
            Trace.redirectStdioStderr();
            Trace.setEnabled(TraceLevel.CACHE, true);
            Trace.setEnabled(TraceLevel.BASIC, true);
            Trace.setEnabled(TraceLevel.TEMP, true);
        }
    }

    protected static boolean isTracing() {
        return Trace.isEnabled(TraceLevel.CACHE);
    }

    protected static void trace(String message) {
        Trace.println(message, TraceLevel.CACHE);
    }

    protected static void trace(Exception ex) {
        Trace.ignoredException(ex);
    }

    static void initializeUpgraderKeys() {
        if (!UpgradeStatus.beenInitialized("Cache6Upgrader")) {
            UpgradeStatus.initialized("Cache6Upgrader");
        }
        if (!UpgradeStatus.beenInitialized("SystemCache6Upgrader")) {
            UpgradeStatus.initialized("SystemCache6Upgrader");
        }
    }

    public static void main(String[] args) {
        backgroundRunning = true;
        CacheUpgrader.initTrace();
        CacheUpgrader.trace("Start upgraders");
        try {
            CacheUpgrader.setupServices();
            CacheUpgrader.getSystemInstance().upgrade();
            CacheUpgrader.getInstance().upgrade();
        }
        catch (IOException ioe) {
            CacheUpgrader.trace(ioe);
        }
        CacheUpgrader.trace("End upgraders");
    }

    static {
        NOOP_STATUS = UpgradeStatus.getUpgradeStatus("noopUpgradeBegin", Long.MAX_VALUE, "noopUpgradeCount", Integer.MAX_VALUE);
        SEP = File.separator;
    }

    static class ProcesOutputHandler
    implements Runnable {
        private BufferedReader reader;

        public ProcesOutputHandler(InputStream in) {
            this.reader = new BufferedReader(new InputStreamReader(in));
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.reader.readLine()) != null) {
                    Trace.print(line, TraceLevel.CACHE);
                }
            }
            catch (IOException e) {
                Trace.ignored(e);
            }
        }
    }

    private static class NoopUpgrader
    extends CacheUpgrader {
        public NoopUpgrader() {
            super("Noop-Upgrader", null, null);
        }

        @Override
        protected void upgradeImpl() {
        }

        @Override
        protected CacheEntry upgradeItemImpl(URL itemRef, String version, int contentType) {
            return null;
        }

        @Override
        protected UpgradeStatus getStatus() {
            return NOOP_STATUS;
        }

        @Override
        protected boolean incrementUpgradeAttempts() {
            return true;
        }

        @Override
        protected void setUpgradeCompleted() {
        }

        @Override
        boolean isBackgroundUpgradeStartedRecenty() {
            return false;
        }

        @Override
        boolean isUpgradeDone() {
            return true;
        }
    }
}

