/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.resources.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class JNLPRandomAccessFileNSBImpl
implements JNLPRandomAccessFile {
    private FileContents _contents = null;
    private final String _file;
    private String _message = null;
    private NativeSandboxBroker broker = null;

    JNLPRandomAccessFileNSBImpl(File file, String mode, FileContents callback) throws IOException {
        this._contents = callback;
        if (!mode.equals("rw")) {
            throw new IllegalArgumentException("Only \"rw\" mode is supported");
        }
        if (this._contents == null) {
            throw new IllegalArgumentException("FileContents can not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File can not be null");
        }
        this._file = file.getAbsolutePath();
        this.broker = Platform.get().getNativeSandboxBroker();
        if (this.broker == null) {
            throw new IllegalArgumentException("Broker can not be null");
        }
        if (this._message == null) {
            this._message = ResourceManager.getString((String)"api.persistence.filesizemessage");
        }
    }

    public void close() throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(0, this._file);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
    }

    public long length() throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(2, this._file);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
        return response.getLongValue();
    }

    public long getFilePointer() throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(1, this._file);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
        return response.getLongValue();
    }

    private DataInputStream getDIS(int size) throws EOFException, IOException {
        if (size <= 0) {
            throw new IOException("b.length <= 0");
        }
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(1, this._file);
        request.setLongValue((long)size);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getEOFException() != null) {
            throw new EOFException(response.getEOFException());
        }
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(response.getData());
        return new DataInputStream(bais);
    }

    private RAFDataOutputStream getDOS() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return new RAFDataOutputStream(baos);
    }

    private void sendDOS(RAFDataOutputStream dos) throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(9, this._file);
        request.setData(dos.toByteArray());
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
    }

    public int read() throws IOException {
        return this.getDIS(4).read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.getDIS(len).read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.getDIS(b.length).read(b);
    }

    public void readFully(byte[] b) throws IOException {
        this.getDIS(b.length).readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.getDIS(b.length).readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(8, this._file);
        request.setLongValue((long)n);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
        return (int)response.getLongValue();
    }

    public boolean readBoolean() throws IOException {
        return this.getDIS(1).readBoolean();
    }

    public byte readByte() throws IOException {
        return this.getDIS(1).readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.getDIS(1).readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.getDIS(2).readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.getDIS(2).readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.getDIS(1).readChar();
    }

    public int readInt() throws IOException {
        return this.getDIS(4).readInt();
    }

    public long readLong() throws IOException {
        return this.getDIS(8).readLong();
    }

    public float readFloat() throws IOException {
        return this.getDIS(4).readFloat();
    }

    public double readDouble() throws IOException {
        return this.getDIS(8).readDouble();
    }

    public String readLine() throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(4, this._file);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getEOFException() != null) {
            throw new EOFException(response.getEOFException());
        }
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
        return response.getString();
    }

    public String readUTF() throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(5, this._file);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getEOFException() != null) {
            throw new EOFException(response.getEOFException());
        }
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
        return response.getString();
    }

    public void seek(long pos) throws IOException {
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(6, this._file);
        request.setLongValue(pos);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
    }

    public void setLength(long newLength) throws IOException {
        if (newLength > this._contents.getMaxLength()) {
            throw new IOException(this._message);
        }
        NativeSandboxBroker.RAF request = new NativeSandboxBroker.RAF(7, this._file);
        request.setLongValue(newLength);
        NativeSandboxBroker.RAF response = this.broker.sendRAF(request);
        if (response.getIOException() != null) {
            throw new IOException(response.getIOException());
        }
    }

    public void write(int b) throws IOException {
        this.checkWrite(1);
        RAFDataOutputStream dos = this.getDOS();
        dos.write(b);
        this.sendDOS(dos);
    }

    public void write(byte[] b) throws IOException {
        if (b != null) {
            this.checkWrite(b.length);
        }
        RAFDataOutputStream dos = this.getDOS();
        dos.write(b);
        this.sendDOS(dos);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkWrite(len);
        RAFDataOutputStream dos = this.getDOS();
        dos.write(b, off, len);
        this.sendDOS(dos);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.checkWrite(1);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeBoolean(v);
        this.sendDOS(dos);
    }

    public void writeByte(int v) throws IOException {
        this.checkWrite(1);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeByte(v);
        this.sendDOS(dos);
    }

    public void writeShort(int v) throws IOException {
        this.checkWrite(2);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeShort(v);
        this.sendDOS(dos);
    }

    public void writeChar(int v) throws IOException {
        this.checkWrite(2);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeChar(v);
        this.sendDOS(dos);
    }

    public void writeInt(int v) throws IOException {
        this.checkWrite(4);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeInt(v);
        this.sendDOS(dos);
    }

    public void writeLong(long v) throws IOException {
        this.checkWrite(8);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeLong(v);
        this.sendDOS(dos);
    }

    public void writeFloat(float v) throws IOException {
        this.checkWrite(4);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeFloat(v);
        this.sendDOS(dos);
    }

    public void writeDouble(double v) throws IOException {
        this.checkWrite(8);
        RAFDataOutputStream dos = this.getDOS();
        dos.writeDouble(v);
        this.sendDOS(dos);
    }

    public void writeBytes(String s) throws IOException {
        if (s != null) {
            this.checkWrite(s.length());
        }
        RAFDataOutputStream dos = this.getDOS();
        dos.writeBytes(s);
        this.sendDOS(dos);
    }

    public void writeChars(String s) throws IOException {
        if (s != null) {
            this.checkWrite(s.length() * 2);
        }
        RAFDataOutputStream dos = this.getDOS();
        dos.writeChars(s);
        this.sendDOS(dos);
    }

    public void writeUTF(String s) throws IOException {
        if (s != null) {
            this.checkWrite(this.getUTFLen(s));
        }
        RAFDataOutputStream dos = this.getDOS();
        dos.writeUTF(s);
        this.sendDOS(dos);
    }

    private int getUTFLen(String str) {
        int strlen = str.length();
        char[] charr = new char[strlen];
        str.getChars(0, strlen, charr, 0);
        int count = 2;
        for (int i = 0; i < strlen; ++i) {
            char c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++count;
                continue;
            }
            if (c > '\u07ff') {
                count += 3;
                continue;
            }
            count += 2;
        }
        return count;
    }

    private void checkWrite(int len) throws IOException {
        if (len < 0 || this._contents.getMaxLength() - this.getFilePointer() < (long)len) {
            throw new IOException(this._message);
        }
    }

    private class RAFDataOutputStream
    extends DataOutputStream {
        private final ByteArrayOutputStream baos;

        public RAFDataOutputStream(ByteArrayOutputStream baos) {
            super(baos);
            this.baos = baos;
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }
}

