/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileSaveServiceNSBImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;

public final class FileSaveServiceImpl
implements FileSaveService {
    static FileSaveService _sharedInstance = null;
    private ApiDialog _apiDialog = new ApiDialog();
    private String _lastPath;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });
    private static final AccessControlContext ACC_DIALOG_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write"));
            ((PermissionCollection)perms).add(new RuntimePermission("setContextClassLoader"));
            ((PermissionCollection)perms).add(new RuntimePermission("accessClassInPackage.com.apple.*"));
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    FileSaveServiceImpl() {
    }

    public static synchronized FileSaveService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = Platform.get().isNativeSandbox() ? new FileSaveServiceNSBImpl(new FileSaveServiceImpl()) : new FileSaveServiceImpl();
        }
        return _sharedInstance;
    }

    String getLastPath() {
        return this._lastPath;
    }

    void setLastPath(String filePath) {
        this._lastPath = filePath;
    }

    public FileContents saveAsFileDialog(String pathHint, String[] extensions, FileContents fileContents) throws IOException {
        return this.saveFileDialog(pathHint, extensions, fileContents.getInputStream(), fileContents.getName());
    }

    public FileContents saveFileDialog(final String pathHint, final String[] extensions, final InputStream stream, final String filename) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                Object res = DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] f;
                        String initDir = pathHint;
                        if (initDir == null) {
                            initDir = FileSaveServiceImpl.this.getLastPath();
                        }
                        if ((f = ToolkitStore.getUI().showFileChooser(initDir, extensions, 9, false, filename))[0] != null) {
                            try {
                                byte[] buffer = new byte[8192];
                                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f[0]));
                                BufferedInputStream bis = new BufferedInputStream(stream);
                                int n = bis.read(buffer);
                                while (n != -1) {
                                    bos.write(buffer, 0, n);
                                    n = bis.read(buffer);
                                }
                                bos.close();
                                FileSaveServiceImpl.this.setLastPath(f[0].getPath());
                                return new FileContentsImpl(f[0], FileSaveServiceImpl.computeMaxLength(f[0].length()));
                            }
                            catch (IOException ioe) {
                                Trace.ignored((Throwable)ioe);
                                return ioe;
                            }
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
                if (res instanceof IOException) {
                    throw (IOException)res;
                }
                return (FileContents)res;
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    String saveFileDialogNSB(final String pathHint, final String[] extensions, final String filename) throws IOException {
        Waiter.WaiterTask task = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                Object res = DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] f;
                        String initDir = pathHint;
                        if (initDir == null) {
                            initDir = FileSaveServiceImpl.this.getLastPath();
                        }
                        if ((f = ToolkitStore.getUI().showFileChooser(initDir, extensions, 9, false, filename))[0] != null) {
                            return f[0].getAbsolutePath();
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
                if (res instanceof IOException) {
                    throw (IOException)res;
                }
                return (String)res;
            }
        };
        try {
            return (String)Waiter.runAndWait((Waiter.WaiterTask)task);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            Trace.ignored((Throwable)ex);
            return null;
        }
    }

    synchronized boolean askUser() {
        String key;
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        final LocalApplicationProperties lap = JNLPUtils.getLocalApplicationProperties();
        if (lap != null && (key = lap.get("jnlp.api.always.FileSaveService.save")) != null) {
            return true;
        }
        ApiDialog.DialogResult result = this._apiDialog.askUser(ResourceManager.getString((String)"api.file.save.title"), ResourceManager.getString((String)"api.file.save.message"), ResourceManager.getString((String)"api.file.save.always"));
        if (result == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    lap.put("jnlp.api.always.FileSaveService.save", "skip");
                    try {
                        lap.store();
                    }
                    catch (Throwable e) {
                        Trace.ignored((Throwable)e);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        return result == ApiDialog.DialogResult.OK || result == ApiDialog.DialogResult.ALWAYS;
    }

    static long computeMaxLength(long value) {
        return value * 3L;
    }
}

