/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.media.sound.JavaSoundAudioClip;
import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

final class AppletAudioClip
implements AudioClip {
    private URL url = null;
    private AudioClip audioClip = null;
    private static Map<URL, AudioClip> audioClips = new HashMap<URL, AudioClip>();

    public AppletAudioClip() {
    }

    public AppletAudioClip(URL url) {
        this.url = url;
        try {
            InputStream in = url.openStream();
            this.createAppletAudioClip(in);
        }
        catch (IOException e) {
            Trace.println((String)("IOException creating AppletAudioClip" + e), (TraceLevel)TraceLevel.BASIC);
        }
    }

    public static synchronized AudioClip get(URL url) {
        AppletAudioClip.checkConnect(url);
        AudioClip clip = audioClips.get(url);
        if (clip == null) {
            clip = new AppletAudioClip(url);
            audioClips.put(url, clip);
        }
        return clip;
    }

    void createAppletAudioClip(InputStream in) throws IOException {
        this.audioClip = new JavaSoundAudioClip(in);
    }

    private static void checkConnect(URL url) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                Permission perm = url.openConnection().getPermission();
                if (perm != null) {
                    security.checkPermission(perm);
                } else {
                    security.checkConnect(url.getHost(), url.getPort());
                }
            }
            catch (IOException ioe) {
                security.checkConnect(url.getHost(), url.getPort());
            }
        }
    }

    @Override
    public synchronized void play() {
        if (this.audioClip != null) {
            this.audioClip.play();
        }
    }

    @Override
    public synchronized void loop() {
        if (this.audioClip != null) {
            this.audioClip.loop();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
    }
}

