/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.javaws.Main;
import com.sun.javaws.security.AppContextUtil;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public final class JavawsSysRun
extends DeploySysRun {
    private final SecureThread t = new SecureThread();
    private static final Executor executor = Executors.newSingleThreadExecutor();

    private void delegateFromEDT(final Job job) throws Exception {
        DummyDialog dummyDialog = new DummyDialog();
        job.setDialog(dummyDialog);
        if (Config.getOSName().equals("Windows")) {
            dummyDialog.setLocation(-200, -200);
        } else {
            Rectangle rect = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
            dummyDialog.setLocation(rect.x + rect.width / 2 - 50, rect.y + rect.height / 2);
        }
        dummyDialog.setResizable(false);
        dummyDialog.toBack();
        dummyDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ((JavawsSysRun)JavawsSysRun.this).t.mutex;
                        synchronized (object) {
                            JavawsSysRun.this.t.addJob(job);
                            ((JavawsSysRun)JavawsSysRun.this).t.mutex.notifyAll();
                        }
                    }
                });
            }
        });
        dummyDialog.setVisible(true);
        dummyDialog.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object delegate(DeploySysAction action) throws Exception {
        if (Main.getSecurityThreadGroup() == null || Main.getSecurityThreadGroup().equals(Thread.currentThread().getThreadGroup())) {
            return action.execute();
        }
        Job job = new Job(action);
        if (AppContextUtil.isApplicationAppContext() && SwingUtilities.isEventDispatchThread()) {
            this.delegateFromEDT(job);
        } else {
            Object object = this.t.mutex;
            synchronized (object) {
                this.t.addJob(job);
                this.t.mutex.notifyAll();
                while (!job.done) {
                    try {
                        this.t.mutex.wait();
                    }
                    catch (InterruptedException e) {
                        Trace.ignoredException((Exception)e);
                    }
                }
                this.t.mutex.notifyAll();
            }
        }
        if (job.exception != null) {
            throw job.exception;
        }
        return job.result;
    }

    static void invokeLater(final Runnable runner) {
        if (Main.getSecurityThreadGroup() == null || Main.getSecurityThreadGroup().equals(Thread.currentThread().getThreadGroup())) {
            SwingUtilities.invokeLater(runner);
            return;
        }
        final Runnable invoker = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(runner);
            }
        };
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread t = new Thread(Main.getSecurityThreadGroup(), invoker);
                t.setContextClassLoader(Main.getSecureContextClassLoader());
                t.start();
                return null;
            }
        });
    }

    class SecureThread
    extends Thread {
        Object mutex;
        LinkedList<Job> jobList;

        SecureThread() {
            super(Main.getSecurityThreadGroup(), "Javaws Secure Thread");
            this.mutex = new Object();
            this.jobList = new LinkedList();
            this.setDaemon(true);
            this.setContextClassLoader(Main.getSecureContextClassLoader());
            this.start();
        }

        void addJob(Job job) {
            this.jobList.add(job);
        }

        private void doWork(Job job) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setContextClassLoader(Main.getSecureContextClassLoader());
                    }
                });
                job.result = job.action.execute();
            }
            catch (Exception e) {
                job.exception = e;
            }
            finally {
                job.done = true;
                if (job.dialog != null) {
                    job.dialog.secureHide();
                }
            }
        }

        @Override
        public void run() {
            Object object = this.mutex;
            synchronized (object) {
                while (true) {
                    if (!this.jobList.isEmpty()) {
                        Job job = this.jobList.removeFirst();
                        this.doWork(job);
                        continue;
                    }
                    this.mutex.notifyAll();
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException e) {
                        Trace.ignoredException((Exception)e);
                    }
                }
            }
        }
    }

    private class DummyDialog
    extends JDialog {
        private static final long serialVersionUID = 3889790620729238887L;
        private ThreadGroup _callingTG;

        DummyDialog() {
            super((Frame)null, true);
            this._callingTG = Thread.currentThread().getThreadGroup();
        }

        public void secureHide() {
            new Thread(this._callingTG, new Runnable(){

                @Override
                public void run() {
                    DummyDialog.this.setVisible(false);
                }
            }).start();
        }
    }

    class Job {
        final DeploySysAction action;
        DummyDialog dialog;
        Object result;
        Exception exception;
        boolean done;

        Job(DeploySysAction a) {
            this.action = a;
            this.done = false;
        }

        void setDialog(DummyDialog d) {
            this.dialog = d;
        }
    }
}

