/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.javaws.IconUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.LaunchErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ApplicationIconGenerator
extends Thread {
    private File _index;
    private File _dir;
    private final String _key;
    private final LaunchDesc _ld;
    private Properties _props = new Properties();

    public static void generate(LaunchDesc ld, boolean force) {
        if (!Cache.isCacheEnabled()) {
            return;
        }
        if (ld.isApplicationDescriptor()) {
            ApplicationIconGenerator aig = new ApplicationIconGenerator(ld);
            if (force || aig.needsCustomIcon()) {
                aig.start();
            }
        }
    }

    public static void removeCustomIcon(LaunchDesc ld) {
        if (ld.isApplicationDescriptor()) {
            ApplicationIconGenerator aig = new ApplicationIconGenerator(ld);
            aig.remove();
        }
    }

    public ApplicationIconGenerator(LaunchDesc ld) {
        this._ld = ld;
        this._dir = new File(Config.getAppIconDir());
        this._key = this._ld.getSplashCanonicalHome();
        String indexFile = Config.getAppIconIndex();
        this._index = new File(indexFile);
        Config.setAppIconCache();
        Config.get().storeIfNeeded();
        if (this._index.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this._index);
                if (fis != null) {
                    this._props.load(fis);
                    fis.close();
                }
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        }
    }

    public boolean needsCustomIcon() {
        return this._key != null ? !this._props.containsKey(this._key) : false;
    }

    public void remove() {
        this.addAppIconToCacheIndex(this._key, null);
    }

    @Override
    public void run() {
        if (!this._dir.getParentFile().canWrite() || this._dir.exists() && !this._dir.canWrite() || this._index.exists() && !this._index.canWrite()) {
            return;
        }
        try {
            this._dir.mkdirs();
        }
        catch (Throwable e) {
            this.appIconError(e);
        }
        try {
            this._index.createNewFile();
        }
        catch (Throwable e) {
            this.appIconError(e);
        }
        String iconPath = IconUtil.getIconPath(this._ld);
        if (iconPath == null) {
            return;
        }
        try {
            this.addAppIconToCacheIndex(this._key, iconPath);
        }
        catch (Throwable t) {
            Trace.ignored((Throwable)t);
        }
    }

    private void addAppIconToCacheIndex(String key, String value) {
        if (key == null) {
            return;
        }
        if (value != null) {
            this._props.setProperty(key, value);
        } else if (this._props.containsKey(key)) {
            this._props.remove(key);
        }
        File[] files = this._dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(this._index)) continue;
            try {
                String path = files[i].getCanonicalPath();
                if (this._props.containsValue(path)) continue;
                files[i].delete();
                continue;
            }
            catch (IOException ioe) {
                this.appIconError(ioe);
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(this._index);
            this._props.store(fos, "");
            fos.flush();
            fos.close();
        }
        catch (IOException ioe) {
            this.appIconError(ioe);
        }
    }

    private void appIconError(Throwable e) {
        LaunchErrorDialog.show(null, e, false);
        throw new Error(e.toString());
    }
}

