/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.OperaPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;

public abstract class OperaSupport {
    protected static final String OPERA_PREFERENCES = "opera.ini";
    protected static final String OPERA_6_PREFERENCES = "opera6.ini";
    protected boolean useDefault;
    private static final String INSTALL_SECTION = "INSTALL";
    private static final String VERSION_KEY = "OVER";
    private static final float OPERA_2_PREFERENCE_VERSION = 5.0f;
    private static final float LAST_TESTED_OPERA_PREFERENCE_VERSION = 7.11f;
    private static final String FILE_TYPES_SECTION_INFO = "File Types Section Info";
    private static final String FILE_TYPES_VERSION_KEY = "Version";
    private static final String FILE_TYPES = "File Types";
    private static final String FILE_TYPES_KEY = "application/x-java-jnlp-file";
    private static final String FILE_TYPES_VALUE = "{0},{1},,,jnlp,|";
    private static final String EXPLICIT_PATH = "3";
    private static final String IMPLICIT_PATH = "4";
    private static final String FILE_TYPES_EXTENSION = "File Types Extension";
    private static final String FILE_TYPES_EXTENSION_KEY = "application/x-java-jnlp-file";
    private static final String FILE_TYPES_EXTENSION_VALUE = ",0";

    public abstract boolean isInstalled();

    public abstract void enableJnlp(File var1, boolean var2);

    protected void enableJnlp(OperaPreferences prefs, File file, File jaws, boolean override) throws IOException {
        if (prefs == null) {
            prefs = this.getPreferences(file);
        }
        if (prefs != null) {
            float version = 5.0f;
            String versionStr = prefs.get(INSTALL_SECTION, VERSION_KEY);
            if (versionStr != null) {
                try {
                    version = Float.parseFloat(versionStr.trim());
                }
                catch (NumberFormatException nfe) {
                    Trace.println((String)"Unable to determine Opera version from the preference file; assuming 5.0 or higher.", (TraceLevel)TraceLevel.BASIC);
                }
            }
            if (version < 5.0f) {
                prefs.put(FILE_TYPES_SECTION_INFO, FILE_TYPES_VERSION_KEY, "1");
            } else if (!prefs.containsKey(FILE_TYPES_SECTION_INFO, FILE_TYPES_VERSION_KEY)) {
                if (version > 7.11f) {
                    Trace.println((String)"Setting '[File Types Section Info]Version=2' in the Opera preference file.", (TraceLevel)TraceLevel.BASIC);
                }
                prefs.put(FILE_TYPES_SECTION_INFO, FILE_TYPES_VERSION_KEY, "2");
            }
            if (override || !prefs.containsKey(FILE_TYPES, "application/x-java-jnlp-file")) {
                Object[] params = new Object[]{null, null};
                if (version < 5.0f || !this.useDefault) {
                    params[0] = EXPLICIT_PATH;
                    try {
                        params[1] = jaws.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        params[1] = jaws.getAbsolutePath();
                    }
                } else {
                    params[0] = IMPLICIT_PATH;
                    params[1] = "";
                }
                prefs.put(FILE_TYPES, "application/x-java-jnlp-file", MessageFormat.format(FILE_TYPES_VALUE, params));
            }
            if (version >= 5.0f && !prefs.containsKey(FILE_TYPES_EXTENSION, "application/x-java-jnlp-file")) {
                prefs.put(FILE_TYPES_EXTENSION, "application/x-java-jnlp-file", FILE_TYPES_EXTENSION_VALUE);
            }
            prefs.store(new FileOutputStream(file));
        }
    }

    protected OperaPreferences getPreferences(File file) throws IOException {
        OperaPreferences result = null;
        if (file.exists()) {
            if (file.canRead()) {
                if (file.canWrite()) {
                    result = new OperaPreferences();
                    result.load(new FileInputStream(file));
                } else {
                    Trace.println((String)("No write access to the Opera preference file (" + file.getAbsolutePath() + ")."), (TraceLevel)TraceLevel.BASIC);
                }
            } else {
                Trace.println((String)("No read access to the Opera preference file (" + file.getAbsolutePath() + ")."), (TraceLevel)TraceLevel.BASIC);
            }
        } else {
            Trace.println((String)("The Opera preference file (" + file.getAbsolutePath() + ") does not exist."), (TraceLevel)TraceLevel.BASIC);
        }
        return result;
    }

    protected OperaSupport(boolean useDefault) {
        this.useDefault = useDefault;
    }
}

