/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import java.util.TreeSet;

public final class ConsoleHelper {
    public static void dumpAllStacks(ConsoleController consoleController) {
        if (!consoleController.isDumpStackSupported()) {
            return;
        }
        Trace.println(ConsoleHelper.dumpAllStacksImpl());
    }

    private static native String dumpAllStacksImpl();

    public static void dumpThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            try {
                if (threadGroup.activeCount() == 0 && threadGroup.activeGroupCount() == 0 && !threadGroup.isDestroyed()) {
                    threadGroup.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Group ").append(threadGroup.getName());
            stringBuffer.append(",ac=").append(threadGroup.activeCount());
            stringBuffer.append(",agc=").append(threadGroup.activeGroupCount());
            stringBuffer.append(",pri=").append(threadGroup.getMaxPriority());
            if (threadGroup.isDestroyed()) {
                stringBuffer.append(",destoyed");
            }
            if (threadGroup.isDaemon()) {
                stringBuffer.append(",daemon");
            }
            Trace.println(stringBuffer.toString());
            Thread[] threadArray = new Thread[1000];
            threadGroup.enumerate(threadArray, false);
            for (int i = 0; i < threadArray.length; ++i) {
                if (threadArray[i] == null) continue;
                stringBuffer = new StringBuffer();
                stringBuffer.append("    ");
                stringBuffer.append(threadArray[i].getName());
                stringBuffer.append(",");
                stringBuffer.append(threadArray[i].getPriority());
                if (threadArray[i].isAlive()) {
                    stringBuffer.append(",alive");
                } else {
                    stringBuffer.append(",not alive");
                }
                if (threadArray[i].isDaemon()) {
                    stringBuffer.append(",daemon");
                }
                if (threadArray[i].isInterrupted()) {
                    stringBuffer.append(",interrupted");
                }
                Trace.println(stringBuffer.toString());
            }
            ThreadGroup[] threadGroupArray = new ThreadGroup[1000];
            threadGroup.enumerate(threadGroupArray, false);
            for (int i = 0; i < threadGroupArray.length; ++i) {
                if (threadGroupArray[i] == null) continue;
                ConsoleHelper.dumpThreadGroup(threadGroupArray[i]);
            }
        }
    }

    public static void displayHelp(ConsoleController consoleController, ConsoleWindow consoleWindow) {
        consoleWindow.append(ResourceManager.getString("console.menu.text.top"));
        consoleWindow.append(ResourceManager.getString("console.menu.text.c"));
        consoleWindow.append(ResourceManager.getString("console.menu.text.f"));
        consoleWindow.append(ResourceManager.getString("console.menu.text.g"));
        consoleWindow.append(ResourceManager.getString("console.menu.text.h"));
        if (consoleController.isDumpClassLoaderSupported()) {
            consoleWindow.append(ResourceManager.getString("console.menu.text.l"));
        }
        consoleWindow.append(ResourceManager.getString("console.menu.text.m"));
        if (consoleController.isLoggingSupported()) {
            consoleWindow.append(ResourceManager.getString("console.menu.text.o"));
        }
        if (consoleController.isProxyConfigReloadSupported()) {
            consoleWindow.append(ResourceManager.getString("console.menu.text.p"));
        }
        consoleWindow.append(ResourceManager.getString("console.menu.text.q"));
        if (consoleController.isSecurityPolicyReloadSupported()) {
            consoleWindow.append(ResourceManager.getString("console.menu.text.r"));
        }
        consoleWindow.append(ResourceManager.getString("console.menu.text.s"));
        consoleWindow.append(ResourceManager.getString("console.menu.text.t"));
        if (consoleController.isDumpStackSupported()) {
            consoleWindow.append(ResourceManager.getString("console.menu.text.v"));
        }
        if (consoleController.isClearClassLoaderSupported()) {
            consoleWindow.append(ResourceManager.getString("console.menu.text.x"));
        }
        consoleWindow.append(ResourceManager.getString("console.menu.text.0"));
        consoleWindow.append(ResourceManager.getString("console.menu.text.tail"));
    }

    public static void displayVersion(ConsoleController consoleController, ConsoleWindow consoleWindow) {
        consoleWindow.append(Trace.getIntro());
    }

    public static void displaySystemProperties() {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        Config config = Config.get();
        Object object = System.getProperties().propertyNames();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (config.containsKey(string2)) continue;
            treeSet.add(string2);
        }
        Trace.print(ResourceManager.getString("console.dump.system.properties"));
        Trace.print(ResourceManager.getString("console.menu.text.top"));
        for (String string2 : treeSet) {
            string = System.getProperty(string2);
            if (string != null) {
                if (string.equals("\n")) {
                    string = "\\n";
                } else if (string.equals("\r")) {
                    string = "\\r";
                } else if (string.equals("\r\n")) {
                    string = "\\r\\n";
                } else if (string.equals("\n\r")) {
                    string = "\\n\\r";
                } else if (string.equals("\n\n")) {
                    string = "\\n\\n";
                } else if (string.equals("\r\r")) {
                    string = "\\r\\r";
                }
            }
            Trace.println(string2 + " = " + string);
        }
        Trace.print(ResourceManager.getString("console.menu.text.tail"));
        treeSet.clear();
        object = config.propertyNames();
        while (object.hasMoreElements()) {
            treeSet.add((String)object.nextElement());
        }
        Trace.print(ResourceManager.getString("console.dump.deployment.properties"));
        Trace.print(ResourceManager.getString("console.menu.text.top"));
        for (String string2 : treeSet) {
            string = Config.getStringProperty(string2);
            if (string != null) {
                if (string.equals("\n")) {
                    string = "\\n";
                } else if (string.equals("\r")) {
                    string = "\\r";
                } else if (string.equals("\r\n")) {
                    string = "\\r\\n";
                } else if (string.equals("\n\r")) {
                    string = "\\n\\r";
                } else if (string.equals("\n\n")) {
                    string = "\\n\\n";
                } else if (string.equals("\r\r")) {
                    string = "\\r\\r";
                }
            }
            Trace.println(string2 + " = " + string);
        }
        Trace.print(ResourceManager.getString("console.menu.text.tail"));
        Trace.print(ResourceManager.getString("console.done"));
    }

    public static void setTraceLevel(int n) {
        Trace.setEnabled(TraceLevel.BASIC, n >= 1);
        Trace.setEnabled(TraceLevel.CACHE, n >= 2);
        Trace.setEnabled(TraceLevel.NETWORK, n >= 3);
        Trace.setEnabled(TraceLevel.SECURITY, n >= 3);
        Trace.setEnabled(TraceLevel.LIVECONNECT, n >= 5);
        Trace.setEnabled(TraceLevel.TEMP, n >= 5);
        Trace.setEnabled(TraceLevel.UI, n >= 5);
        Trace.setEnabled(TraceLevel.PRELOADER, n >= 5);
        Trace.setEnabled(TraceLevel.RULESET, n >= 5);
        Trace.print(ResourceManager.getString("console.trace.level." + Integer.toString(n)));
    }
}

