/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerTraceListener
implements TraceListener {
    private static LoggerTraceListener sharedInstance;
    private final Logger logger;

    public static synchronized LoggerTraceListener getOrCreateSharedInstance(String string, File file, File file2, String string2, String string3, boolean bl) {
        if ((sharedInstance == null || bl) && (file = LoggerTraceListener.ensureLogFileAvailable(file, file2, string2, string3)) != null) {
            sharedInstance = new LoggerTraceListener(string, file.getPath());
        }
        return sharedInstance;
    }

    public LoggerTraceListener(String string, String string2) {
        FileHandler fileHandler = null;
        this.logger = Logger.getLogger(string);
        this.logger.setUseParentHandlers(false);
        try {
            fileHandler = new FileHandler(string2, Config.getIntProperty("deployment.max.output.file.size") * 0x100000, 1);
            this.logger.addHandler(fileHandler);
            this.logger.setLevel(Level.OFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void print(String string) {
        this.logger.log(Level.FINE, string);
    }

    @Override
    public void flush() {
    }

    static File ensureLogFileAvailable(File file, File file2, String string, String string2) {
        if (!LoggerTraceListener.ensureExists(file)) {
            file = Trace.createTempFile(string, string2, file2);
        }
        return file;
    }

    private static boolean ensureExists(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (!file.exists()) {
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                file.createNewFile();
            }
            return true;
        }
        catch (IOException iOException) {
            Trace.println("Cannot write to file: " + file, TraceLevel.BASIC);
            return false;
        }
    }
}

