/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JarSigningData {
    private CodeSigner[] signers;
    private Map<String, int[]> signerMap;
    private JarVerifier.CodeSourceCache codeSourceCache;
    private Certificate[] certificates;
    private Map<String, int[]> signerMapCert;
    private JarVerifier.CodeSourceCache codeSourceCertCache;
    private final boolean hasOnlySignedEntries;
    private final boolean hasSingleCodeSource;
    private final boolean hasMissingSignedEntries;
    private static int[] emptySignerIndices = new int[0];

    JarSigningData(boolean bl, boolean bl2, boolean bl3) {
        this.hasOnlySignedEntries = bl;
        this.hasSingleCodeSource = bl2;
        this.hasMissingSignedEntries = bl3;
    }

    public static JarSigningData create(JarVerifier jarVerifier) {
        List<CodeSigner> list;
        JarSigningData jarSigningData = new JarSigningData(jarVerifier.hasOnlySignedEntries(), jarVerifier.hasSingleCodeSource(), jarVerifier.hasMissingSignedEntries());
        List<Certificate> list2 = jarVerifier.getSignerCerts();
        if (!list2.isEmpty()) {
            jarSigningData.certificates = list2.toArray(new Certificate[list2.size()]);
            jarSigningData.signerMapCert = jarVerifier.getSignerMapCert();
            jarSigningData.codeSourceCertCache = jarVerifier.getCodeSourceCertCache();
        }
        if (!(list = jarVerifier.getSignersCS()).isEmpty()) {
            CodeSigner[] codeSignerArray = new CodeSigner[list.size()];
            jarSigningData.signers = list.toArray(codeSignerArray);
            jarSigningData.signerMap = jarVerifier.getSignerMap();
            jarSigningData.codeSourceCache = jarVerifier.getCodeSourceCache();
        }
        Trace.println("Create from verifier: " + jarSigningData, TraceLevel.CACHE);
        return jarSigningData;
    }

    void updateSignerInfo(CodeSigner[] codeSignerArray, Map<String, int[]> map, JarVerifier.CodeSourceCache codeSourceCache) {
        this.signers = codeSignerArray;
        this.signerMap = map;
        this.codeSourceCache = codeSourceCache;
    }

    boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    synchronized Map<String, int[]> getCertificateMap() {
        return this.signerMapCert;
    }

    synchronized Map<String, int[]> getSignerMap() {
        return this.signerMap;
    }

    synchronized JarVerifier.CodeSourceCache getCodeSourceCache() {
        return this.codeSourceCache;
    }

    synchronized boolean matchStrictSingleSigning(CodeSource[] codeSourceArray) {
        if (!this.hasStrictSingleSigning()) {
            return false;
        }
        if (codeSourceArray == null || codeSourceArray.length != 1 || codeSourceArray[0] == null) {
            return false;
        }
        CodeSource codeSource = codeSourceArray[0];
        Map<String, int[]> map = this.getSignerMap();
        int[] nArray = map != null ? map.get(null) : null;
        JarVerifier.CodeSourceCache codeSourceCache = this.getCodeSourceCache();
        CodeSource codeSource2 = codeSourceCache != null ? codeSourceCache.get(nArray) : null;
        return codeSource.equals(codeSource2);
    }

    synchronized JarVerifier.CodeSourceCache getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public synchronized CodeSigner[] getCodeSigners() {
        return this.signers;
    }

    public synchronized Certificate[] getCertificates() {
        return this.certificates;
    }

    synchronized CodeSource[] getCodeSources(URL uRL) {
        CodeSource[] codeSourceArray;
        Collection<CodeSource> collection;
        JarVerifier.CodeSourceCache codeSourceCache = this.getCodeSourceCache();
        Collection<CodeSource> collection2 = collection = codeSourceCache != null ? codeSourceCache.getCodeSources() : null;
        if (collection != null) {
            int n = collection.size();
            if (this.hasOnlySignedEntries) {
                codeSourceArray = collection.toArray(new CodeSource[n]);
            } else {
                codeSourceArray = collection.toArray(new CodeSource[n + 1]);
                codeSourceArray[n] = JarSigningData.getUnsignedCS(uRL);
            }
        } else {
            codeSourceArray = new CodeSource[]{JarSigningData.getUnsignedCS(uRL)};
        }
        return codeSourceArray;
    }

    synchronized CodeSource getCodeSource(URL uRL, String string) {
        JarVerifier.CodeSourceCache codeSourceCache;
        int[] nArray = this.getSignerIndices(string);
        if (nArray != null && (codeSourceCache = this.getCodeSourceCache()) != null) {
            return codeSourceCache.get(nArray);
        }
        return JarSigningData.getUnsignedCS(uRL);
    }

    private int[] findMatchingSignerIndices(CodeSource codeSource) {
        JarVerifier.CodeSourceCache codeSourceCache = this.getCodeSourceCache();
        if (codeSourceCache == null) {
            return emptySignerIndices;
        }
        int[] nArray = codeSourceCache.findMatchingIndices(codeSource);
        if (nArray == null && codeSource.getCodeSigners() == null) {
            return emptySignerIndices;
        }
        return nArray;
    }

    private int[] getSignerIndices(String string) {
        if (this.signerMap == null || this.signerMap.isEmpty()) {
            return null;
        }
        if (this.hasStrictSingleSigning()) {
            if (!JarUtil.isSigningRelated(string) && !string.endsWith("/")) {
                return this.signerMap.get(null);
            }
            return null;
        }
        return this.signerMap.get(string);
    }

    synchronized CodeSigner[] getCodeSigners(String string) {
        int[] nArray = this.getSignerIndices(string);
        CodeSigner[] codeSignerArray = null;
        if (this.signers != null && nArray != null) {
            codeSignerArray = new CodeSigner[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                if (this.signers == null) continue;
                codeSignerArray[i] = this.signers[nArray[i]];
            }
        }
        return codeSignerArray;
    }

    synchronized Certificate[] getCertificates(String string) {
        int[] nArray = this.getSignerIndices(string);
        if (this.signers != null && nArray != null) {
            ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.addAll(this.signers[nArray[i]].getSignerCertPath().getCertificates());
            }
            return arrayList.toArray(new Certificate[arrayList.size()]);
        }
        return null;
    }

    synchronized Certificate[] getCertificates14(String string) {
        int[] nArray = this.getCertIndices(string);
        Certificate[] certificateArray = null;
        if (this.certificates != null && nArray != null) {
            certificateArray = new Certificate[this.certificates.length];
            for (int i = 0; i < this.certificates.length; ++i) {
                certificateArray[i] = this.certificates[nArray[i]];
            }
        }
        return certificateArray;
    }

    private synchronized int[] getCertIndices(String string) {
        Map<String, int[]> map = this.getCertificateMap();
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (this.hasStrictSingleSigning()) {
            if (!JarUtil.isSigningRelated(string) && !string.endsWith("/")) {
                return map.get(null);
            }
            return null;
        }
        return map.get(string);
    }

    synchronized boolean collectEntryNamesBySigners(CodeSource[] codeSourceArray, List<String> list) {
        boolean bl = false;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(codeSourceArray.length);
        for (int i = 0; i < codeSourceArray.length; ++i) {
            int[] object = this.findMatchingSignerIndices(codeSourceArray[i]);
            if (object == null) continue;
            if (object.length > 0) {
                arrayList.add(object);
                continue;
            }
            bl = true;
        }
        if (this.signerMap != null) {
            for (String string : this.signerMap.keySet()) {
                if (JarSigningData.containsArrayElement(arrayList, this.signerMap.get(string))) {
                    list.add(string);
                    continue;
                }
                Trace.println("collectEntryNamesBySigners: unmatched entry " + string, TraceLevel.CACHE);
            }
        }
        return bl;
    }

    private static boolean containsArrayElement(List<int[]> list, int[] nArray) {
        for (int[] nArray2 : list) {
            if (!Arrays.equals(nArray2, nArray)) continue;
            return true;
        }
        return false;
    }

    private static CodeSource getUnsignedCS(URL uRL) {
        return new CodeSource(uRL, (Certificate[])null);
    }

    public String toString() {
        return "JarSigningData{hasOnlySignedEntries=" + this.hasOnlySignedEntries + ", hasSingleCodeSource=" + this.hasSingleCodeSource + ", hasMissingSignedEntries=" + this.hasMissingSignedEntries + '}';
    }
}

