/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.XMLFormat;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;

public final class SingleInstanceServiceImpl
extends SingleInstanceImpl
implements SingleInstanceService {
    private static SingleInstanceServiceImpl _sharedInstance = null;
    private static boolean listenerExists = false;

    public static synchronized SingleInstanceServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new SingleInstanceServiceImpl();
        }
        return _sharedInstance;
    }

    @Override
    public synchronized void addSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
        if (singleInstanceListener == null) {
            return;
        }
        final LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        URL uRL = launchDesc.getCanonicalHome();
        int n = uRL.toString().lastIndexOf(63);
        if (n != -1) {
            try {
                uRL = new URL(uRL.toString().substring(0, n));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
        }
        final String string = uRL.toString();
        if (!listenerExists) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (SingleInstanceManager.isServerRunning((String)string)) {
                        ApplicationDesc applicationDesc;
                        String[] stringArray = Globals.getApplicationArgs();
                        if (stringArray != null && (applicationDesc = launchDesc.getApplicationDescriptor()) != null) {
                            applicationDesc.setArguments(stringArray);
                        }
                        if (SingleInstanceManager.connectToServer((String)launchDesc.toString())) {
                            try {
                                Main.systemExit(0);
                            }
                            catch (ExitException exitException) {
                                Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
                                Trace.ignoredException((Exception)exitException);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        super.addSingleInstanceListener((DeploySIListener)new TransferListener(singleInstanceListener), string);
        listenerExists = true;
    }

    @Override
    public void removeSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
        super.removeSingleInstanceListener((DeploySIListener)new TransferListener(singleInstanceListener));
    }

    public boolean isSame(String string, String string2) {
        LaunchDesc launchDesc = null;
        try {
            launchDesc = XMLFormat.parse(string.getBytes(), this.getCodebaseFromLap(), null, null);
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        if (launchDesc != null) {
            URL uRL = launchDesc.getCanonicalHome();
            int n = uRL.toString().lastIndexOf(63);
            if (n != -1) {
                try {
                    uRL = new URL(uRL.toString().substring(0, n));
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignoredException((Exception)malformedURLException);
                }
            }
            String string3 = uRL.toString() + Platform.get().getSessionSpecificString();
            Trace.println((String)("GOT: " + string3), (TraceLevel)TraceLevel.BASIC);
            if (string2.equals(string3)) {
                return true;
            }
        }
        return false;
    }

    public String[] getArguments(String string, String string2) {
        LaunchDesc launchDesc = null;
        try {
            URL uRL = this.getCodebaseFromLap();
            launchDesc = XMLFormat.parse(string.getBytes(), uRL, null, null);
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        if (launchDesc != null) {
            if (launchDesc.getLocation() != null) {
                launchDesc = LaunchDownload.updateLaunchDescInCache(launchDesc);
            }
            if (launchDesc.isApplication()) {
                return launchDesc.getApplicationDescriptor().getArguments();
            }
            return super.getArguments(string, string2);
        }
        return new String[0];
    }

    private URL getCodebaseFromLap() {
        String string;
        LocalApplicationProperties localApplicationProperties;
        LaunchDesc launchDesc;
        JNLPClassLoaderIf jNLPClassLoaderIf = JNLPClassLoader.getInstance();
        if (jNLPClassLoaderIf != null && (launchDesc = jNLPClassLoaderIf.getLaunchDesc()) != null && (localApplicationProperties = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome())) != null && (string = localApplicationProperties.getCodebase()) != null) {
            try {
                return new URL(string);
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        return null;
    }

    private class TransferListener
    implements DeploySIListener {
        SingleInstanceListener _sil;

        public TransferListener(SingleInstanceListener singleInstanceListener) {
            this._sil = singleInstanceListener;
        }

        public void newActivation(String[] stringArray) {
            if (stringArray.length == 2) {
                String string = SingleInstanceManager.getOpenPrintFilePath();
                String string2 = SingleInstanceManager.getActionName();
                if (string != null && string2 != null && (string2.equals("-open") || string2.equals("-print")) && string.equals(stringArray[1]) && string2.equals(stringArray[0])) {
                    JnlpxArgs.getFileReadWriteList().add(stringArray[1]);
                    SingleInstanceManager.setOpenPrintFilePath(null);
                    SingleInstanceManager.setActionName(null);
                }
            }
            this._sil.newActivation(stringArray);
        }

        public Object getSingleInstanceListener() {
            return this._sil;
        }
    }
}

