/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;

public final class FileSaveServiceNSBImpl
implements FileSaveService {
    private final FileSaveServiceImpl service;
    private static final AccessControlContext ACC_DIALOG_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new FilePermission("<<ALL FILES>>", "read,write"));
            ((PermissionCollection)permissions).add(new RuntimePermission("setContextClassLoader"));
            ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.apple.*"));
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });

    public FileSaveServiceNSBImpl(FileSaveServiceImpl fileSaveServiceImpl) {
        this.service = fileSaveServiceImpl;
    }

    @Override
    public FileContents saveFileDialog(final String string, final String[] stringArray, final InputStream inputStream, final String string2) throws IOException {
        if (!this.service.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                Object object = DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        String string = Platform.get().getNativeSandboxBroker().saveFile(string, stringArray, string2);
                        if (string == null) {
                            return null;
                        }
                        File file = new File(string);
                        if (file != null) {
                            try {
                                byte[] byArray = new byte[8192];
                                OutputStream outputStream = Platform.get().getNativeSandboxBroker().getOutputStream(file, true);
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                                int n = bufferedInputStream.read(byArray);
                                while (n != -1) {
                                    outputStream.write(byArray, 0, n);
                                    n = bufferedInputStream.read(byArray);
                                }
                                outputStream.flush();
                                outputStream.close();
                                return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                }, null, (AccessControlContext)ACC_DIALOG_INSTANCE);
                if (object instanceof IOException) {
                    throw (IOException)object;
                }
                return (FileContents)object;
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    @Override
    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        return this.saveFileDialog(string, stringArray, fileContents.getInputStream(), fileContents.getName());
    }
}

