/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.BasicService;
import sun.awt.DesktopBrowse;

public final class BasicServiceImpl
implements BasicService {
    private URL _codebase = null;
    private String _codebaseProtocol = null;
    private boolean _isWebBrowserSupported;
    private static BasicServiceImpl _sharedInstance = null;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new FilePermission("<<ALL FILES>>", "read,write,delete,execute"));
            ((PermissionCollection)permissions).add(new SocketPermission("*", "connect,resolve"));
            if (Config.isJavaVersionAtLeast18()) {
                ((PermissionCollection)permissions).add(new URLPermission("http:*", "*:*"));
                ((PermissionCollection)permissions).add(new URLPermission("https:*", "*:*"));
            }
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        }
    });

    private BasicServiceImpl(URL uRL, boolean bl, String string) {
        this._codebaseProtocol = string;
        this._codebase = uRL;
        this._isWebBrowserSupported = bl;
        try {
            DesktopBrowse.setInstance((DesktopBrowse)new BasicServiceBrowser());
        }
        catch (IllegalStateException illegalStateException) {
            if (Config.getDebug()) {
                illegalStateException.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
        }
    }

    public static BasicServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static void initialize(URL uRL, boolean bl, String string) {
        if (_sharedInstance == null) {
            _sharedInstance = new BasicServiceImpl(uRL, bl, string);
        }
    }

    @Override
    public URL getCodeBase() {
        return this._codebase;
    }

    @Override
    public boolean isOffline() {
        return DeployOfflineManager.isGlobalOffline();
    }

    private boolean isFileProtocolCodebase() {
        return this._codebaseProtocol != null && this._codebaseProtocol.equalsIgnoreCase("file");
    }

    private boolean isValidURL(URL uRL) {
        LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        URL uRL2 = launchDesc.getMainJarURL();
        return uRL2 == null || URLUtil.checkDocumentURL((URL)uRL2, (URL)uRL);
    }

    static boolean isArgumentOkay(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (' ' >= c || c >= '~') {
                return false;
            }
            if (c != '\\' && c != '\"') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean showDocument(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return false;
        }
        if (!URLUtil.checkDocumentURL((URL)this._codebase, (URL)uRL)) {
            return false;
        }
        DesktopBrowse desktopBrowse = DesktopBrowse.getInstance();
        if (desktopBrowse != null && !(desktopBrowse instanceof BasicServiceBrowser)) {
            if (!this.isWebBrowserSupported()) {
                return false;
            }
            try {
                uRL = new URL(this._codebase, uRL.toString());
                if (!BasicServiceImpl.isArgumentOkay(uRL.toString())) {
                    return false;
                }
                if (!this.isValidURL(uRL)) {
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            desktopBrowse.browse(uRL);
            return true;
        }
        return this.showDocumentHelper(uRL);
    }

    private boolean showDocumentHelper(final URL uRL) {
        boolean bl = uRL.toString().toLowerCase().endsWith(".jnlp");
        boolean bl2 = ResourceProvider.get().isCached(uRL, null);
        Boolean bl3 = null;
        if ((bl || bl2) && (bl3 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                URL uRL2 = URLUtil.filterProtocols((URL)uRL);
                if (DownloadEngine.isJnlpURL((URL)uRL2)) {
                    try {
                        String string;
                        Resource resource = ResourceProvider.get().getResource(uRL2, null, false, 1, null);
                        String string2 = string = resource != null ? resource.getResourceFilename() : uRL.toString();
                        if (string != null && BasicServiceImpl.isArgumentOkay(string)) {
                            String[] stringArray = new String[]{Environment.getJavawsCommand(), "-Xnosplash", string};
                            Runtime.getRuntime().exec(stringArray);
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                }
                return false;
            }
        }, ACC_FILE_INSTANCE)) != null && bl3.booleanValue()) {
            return true;
        }
        if (!this.isWebBrowserSupported()) {
            return false;
        }
        try {
            final URL uRL2 = new URL(this._codebase, uRL.toString());
            if (!BasicServiceImpl.isArgumentOkay(uRL2.toString())) {
                return false;
            }
            if (!this.isValidURL(uRL2)) {
                return false;
            }
            bl3 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Platform.get().showDocument(uRL2);
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bl3 == null ? false : bl3;
    }

    @Override
    public boolean isWebBrowserSupported() {
        return this._isWebBrowserSupported;
    }

    public void logPerfStartMessage(String string) {
    }

    public void logPerfEndMessage(String string) {
    }

    public void logPerfTime(String string) {
    }

    private class BasicServiceBrowser
    extends DesktopBrowse {
        private BasicServiceBrowser() {
        }

        public void browse(URL uRL) {
            BasicServiceImpl.this.showDocument(uRL);
        }
    }
}

