/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.applet2.Applet2Host;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SafeThreadFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import sun.awt.AWTAccessor;
import sun.plugin2.uitoolkit.impl.awt.AWTGrayBoxPanel;

public class AWTGrayBoxPainter {
    private Color boxBGColor;
    private Color boxFGColor;
    private boolean boxBorder = true;
    private Image customImage;
    private URL customImageURL;
    private boolean customImageIsCentered;
    private String waitingMessage;
    private Container container;
    private ThreadGroup threadGroup;
    private MediaTracker tracker;
    private boolean stopOnError = false;
    private boolean animationReady = false;
    private boolean progressBarReady = false;
    private volatile boolean paintingSuspended = false;
    private volatile boolean paintingFinished = false;
    private AWTGrayBoxPanel m_grayboxPanel = null;
    private Applet2Host host = null;
    private int currentProgress = 0;

    public AWTGrayBoxPainter(Container container, Applet2Host applet2Host) {
        this.container = container;
        this.host = applet2Host;
    }

    public synchronized void beginPainting(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        this.tracker = new MediaTracker(this.container);
        this.loadCustomImage();
        final AWTGrayBoxPainter aWTGrayBoxPainter = this;
        this.paintingSuspended = false;
        Thread thread = SafeThreadFactory.createThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                }
                catch (Throwable throwable) {
                }
                finally {
                    aWTGrayBoxPainter.setAnimationReady();
                    aWTGrayBoxPainter.setProgressBarReady();
                    if (!AWTGrayBoxPainter.this.paintingSuspended && !AWTGrayBoxPainter.this.paintingFinished) {
                        aWTGrayBoxPainter.repaintGrayBox();
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void finishPainting() {
        try {
            if (this.m_grayboxPanel != null) {
                this.m_grayboxPanel.stop();
                this.container.remove(this.m_grayboxPanel);
                this.m_grayboxPanel = null;
            }
            this.paintingSuspended = false;
            this.paintingFinished = true;
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public synchronized void stopOnError() {
        if (this.m_grayboxPanel != null) {
            this.m_grayboxPanel.stopOnError();
        }
    }

    private void loadCustomImage() {
        if (this.customImageURL != null) {
            try {
                this.customImage = Toolkit.getDefaultToolkit().getImage(this.customImageURL);
                this.tracker.addImage(this.customImage, 1);
                this.tracker.waitForID(1);
                this.setAnimationReady();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (RuntimeException runtimeException) {
                Trace.ignoredException((Exception)runtimeException);
            }
        }
    }

    public void setCustomImageURL(URL uRL, boolean bl) {
        this.customImageURL = uRL;
        this.customImageIsCentered = bl;
    }

    public void setProgress(int n) {
        this.currentProgress = n;
        this.repaintGrayBox();
    }

    public void setBoxBGColor(Color color) {
        this.boxBGColor = color;
    }

    public Color getBoxBGColor() {
        return this.boxBGColor;
    }

    public void setBoxFGColor(Color color) {
        this.boxFGColor = color;
    }

    public Color getBoxFGColor() {
        return this.boxFGColor;
    }

    public void setBoxBorder(String string) {
        this.boxBorder = string == null ? true : Boolean.valueOf(string);
        if (this.m_grayboxPanel != null) {
            this.m_grayboxPanel.setBoxBorder(this.boxBorder);
        }
    }

    public void setWaitingMessage(String string) {
        this.waitingMessage = string;
    }

    public synchronized void suspendPainting() {
        try {
            if (!this.paintingSuspended) {
                if (this.m_grayboxPanel != null) {
                    this.m_grayboxPanel.stop();
                    this.container.remove(this.m_grayboxPanel);
                }
                this.paintingSuspended = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AWTGrayBoxPainter.this.validateContainer();
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public synchronized void resumePainting() {
        try {
            if (this.paintingSuspended) {
                if (this.m_grayboxPanel != null) {
                    this.m_grayboxPanel.start();
                    this.container.add((Component)this.m_grayboxPanel, "Center");
                }
                this.paintingSuspended = false;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AWTGrayBoxPainter.this.validateContainer();
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public void setAnimationReady() {
        this.animationReady = true;
    }

    public void setProgressBarReady() {
        this.progressBarReady = true;
    }

    private void repaintGrayBox() {
        try {
            this.paintGrayBox(this.container.getGraphics());
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    private void validateContainer() {
        try {
            AWTAccessor.getContainerAccessor().validateUnconditionally(this.container);
        }
        catch (Throwable throwable) {
            this.container.validate();
        }
    }

    private synchronized AWTGrayBoxPanel getGrayBoxPanel() {
        if (this.m_grayboxPanel == null) {
            this.m_grayboxPanel = new AWTGrayBoxPanel(this.container, this.boxBGColor, this.boxFGColor, this.host);
            if (!this.paintingSuspended) {
                this.container.add((Component)this.m_grayboxPanel, "Center");
                this.m_grayboxPanel.setBoxBorder(this.boxBorder);
                if (this.customImage == null) {
                    this.m_grayboxPanel.setMaxProgressValue(100);
                    this.m_grayboxPanel.start();
                } else {
                    this.m_grayboxPanel.setCustomImage(this.customImage, this.customImageIsCentered);
                }
                this.validateContainer();
            }
        }
        return this.m_grayboxPanel;
    }

    synchronized void paintGrayBox(Graphics graphics) {
        try {
            if (this.paintingSuspended || this.paintingFinished) {
                return;
            }
            if (graphics == null) {
                AWTGrayBoxPanel aWTGrayBoxPanel = this.getGrayBoxPanel();
                return;
            }
            Dimension dimension = this.container.getSize();
            if (!this.animationReady && !this.stopOnError) {
                if (dimension.width > 0 && dimension.height > 0) {
                    graphics.setColor(this.boxBGColor);
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                }
                return;
            }
            if (dimension.width > 0 && dimension.height > 0) {
                AWTGrayBoxPanel aWTGrayBoxPanel = this.getGrayBoxPanel();
                aWTGrayBoxPanel.progress(this.currentProgress);
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }
}

