/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.Launcher;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.InvalidArgumentException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppContextUtil;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SplashScreen;
import java.io.File;
import java.net.URL;
import sun.plugin2.applet.viewer.JNLP2Viewer;
import sun.plugin2.uitoolkit.PluginUIToolkit;

public class WebStart {
    private String[] _args = null;
    private Launcher _launcher = null;

    public static void main(String[] stringArray) {
        new WebStart().performLaunch(stringArray);
    }

    private void performLaunch(final String[] stringArray) {
        try {
            PluginUIToolkit.initPluginToolkit();
            Main.initApp((String[])stringArray);
            new Thread(Main.getSecurityThreadGroup(), new Runnable(){

                @Override
                public void run() {
                    AppContextUtil.createSecurityAppContext();
                    Thread.currentThread().setContextClassLoader(Main.getSecureContextClassLoader());
                    try {
                        WebStart.this.continueInSecureThread(stringArray);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    Trace.flush();
                }
            }, "Java Web Start Main Thread").start();
        }
        catch (Throwable throwable) {
            LaunchErrorDialog.show(null, (Throwable)throwable, (boolean)true);
        }
    }

    private void continueInSecureThread(String[] stringArray) {
        String[] stringArray2 = Main.prepareArguments((String[])stringArray);
        if (Cache.canWrite() || Main.isViewer()) {
            Main.initEnvironment();
            if (Main.isUninstall()) {
                Main.uninstallCache(stringArray2.length > 0 ? stringArray2[0] : null);
            } else if (Main.needToFixShortcut()) {
                CacheUtil.fixShortcut();
            } else if (Main.needToFixPermissions()) {
                Platform.get().verifyPermissionsForFileSystem();
            } else {
                if (DeployOfflineManager.isGlobalOffline()) {
                    JnlpxArgs.SetIsOffline();
                    DeployOfflineManager.setForcedOffline((boolean)true);
                }
                if (Main.needToUpdateBaseline()) {
                    SecurityBaseline.forceBaselineUpdate();
                } else if (!Main.isViewer()) {
                    if (Globals.TCKHarnessRun) {
                        Environment.setGlobalException((boolean)true);
                        Main.tckprintln((String)"Java Started");
                    }
                    if (stringArray2.length > 0) {
                        if (Environment.isImportMode()) {
                            for (int i = 0; i < stringArray2.length; ++i) {
                                int n = i == 0 ? stringArray2.length - 1 : i - 1;
                                boolean bl = i == stringArray2.length - 1;
                                this.launchApp(stringArray2[n], bl);
                            }
                        } else {
                            if (stringArray2.length != 1) {
                                JnlpxArgs.removeArgumentFile((String)stringArray2[stringArray2.length - 1]);
                                LaunchErrorDialog.show(null, (Throwable)new InvalidArgumentException(stringArray2), (boolean)true);
                                return;
                            }
                            DeploymentRuleSet.initialize();
                            this.launchApp(stringArray2[0], true);
                        }
                    }
                } else {
                    if (stringArray2.length > 0) {
                        JnlpxArgs.removeArgumentFile((String)stringArray2[0]);
                    }
                    try {
                        String string = Main.isSilent() ? "-store" : "-viewer";
                        String[] stringArray3 = new String[]{string};
                        Main.launchJavaControlPanel((String[])stringArray3);
                    }
                    catch (Exception exception) {
                        LaunchErrorDialog.show(null, (Throwable)exception, (boolean)true);
                    }
                }
            }
        } else {
            LaunchErrorDialog.show(null, (Throwable)new CacheAccessException(Environment.isSystemCacheMode()), (boolean)true);
        }
        Trace.flush();
        SplashScreen.hide();
    }

    private void launchApp(String string, boolean bl) {
        LaunchDesc launchDesc = Main.prepareLaunchDesc((String)string, (boolean)bl);
        if (launchDesc == null) {
            return;
        }
        if (launchDesc.getLaunchType() == 5) {
            JnlpxArgs.removeArgumentFile((String)string);
            String string2 = launchDesc.getInternalCommand();
            String[] stringArray = string2 != null && !string2.equals("player") && !string2.equals("viewer") ? new String[]{"-tab", launchDesc.getInternalCommand()} : new String[]{"-viewer"};
            Main.launchJavaControlPanel((String[])stringArray);
        } else if (Config.get().isValid()) {
            String[] stringArray = new String[]{string};
            this._launcher = new Launcher(launchDesc, stringArray, bl);
            this.launchApp();
        } else {
            LaunchErrorDialog.show(null, (Throwable)new LaunchDescException(launchDesc, ResourceManager.getString((String)"enterprize.cfg.mandatory", (Object[])new Object[]{Config.get().getEnterpriseString()}), null), (boolean)bl);
        }
    }

    private void launchApp() {
        if (this._launcher.checkForSingleInstance()) {
            return;
        }
        if (this.prepareToLaunch()) {
            this._launcher.initiateUpdateCheck();
            if (this._launcher.useAppletLifecycle()) {
                return;
            }
            new Thread(Main.getLaunchThreadGroup(), (Runnable)this._launcher, "javawsApplicationMain").start();
        } else if (!Environment.isImportMode()) {
            LaunchErrorDialog.show((Object)Progress.get(null).getOwner(), (Throwable)new Exception(ResourceManager.getString((String)"launch.error.category.unexpected")), (boolean)true);
        }
    }

    private boolean prepareToLaunch() {
        boolean bl = this._launcher.tryOffline();
        try {
            if (!bl && DeployOfflineManager.isForcedOffline()) {
                Launcher launcher = this._launcher;
                launcher.getClass();
                throw new Launcher.CacheUpdateRequiredException(launcher, "Forced offline mode!");
            }
            boolean bl2 = this.prepareToLaunch(bl);
            return bl2;
        }
        catch (Launcher.CacheUpdateRequiredException cacheUpdateRequiredException) {
            return this._launcher.handleCacheUpdateRequiredException(cacheUpdateRequiredException, bl);
        }
    }

    private boolean prepareToLaunch(boolean bl) throws Launcher.CacheUpdateRequiredException {
        try {
            LaunchDesc launchDesc = this._launcher.updateLaunchDesc(bl);
            if (this._launcher.useAppletLifecycle() && !this._launcher.isImport()) {
                this.launchAppUsingAppletLifecycle(launchDesc);
                return true;
            }
            this._launcher.prepareAllResources(bl);
        }
        catch (Launcher.CacheUpdateRequiredException cacheUpdateRequiredException) {
            throw cacheUpdateRequiredException;
        }
        catch (Throwable throwable) {
            this._launcher.handleExitException(throwable);
            return false;
        }
        return true;
    }

    private void launchAppUsingAppletLifecycle(LaunchDesc launchDesc) throws ExitException {
        Environment.setJavawsAppletLifecycle((boolean)true);
        if (launchDesc.getResources() == null) {
            this._launcher.handleJnlpFileException(launchDesc, (Exception)((Object)new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (Object[])new Object[]{launchDesc.getSpecVersion()}), null)));
        }
        this.executeApplet(launchDesc, this._launcher.getLap(), launchDesc.getCodebase().toString(), launchDesc.getDocumentBase().toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeApplet(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, String string2, boolean bl) {
        block16: {
            Object object;
            File file;
            block15: {
                URL uRL = launchDesc.getCanonicalHome();
                file = null;
                try {
                    object = ResourceProvider.get().getCachedResourceFilePath(uRL, null);
                    if (object != null) {
                        file = new File((String)object);
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isEnabled((TraceLevel)TraceLevel.CACHE)) break block15;
                    Trace.ignored((Throwable)exception);
                }
            }
            if (file != null) {
                if (!bl) {
                    object = SingleInstanceManager.getActionName();
                    if (object != null && (object.equals("-open") || object.equals("-print"))) {
                        this._args = new String[3];
                        this._args[0] = object;
                        this._args[1] = SingleInstanceManager.getOpenPrintFilePath();
                        this._args[2] = file.toString();
                    } else if (localApplicationProperties.isDraggedApplet()) {
                        this._args = new String[2];
                        this._args[0] = "-draggedApplet";
                        this._args[1] = file.toString();
                    } else {
                        this._args = new String[1];
                        this._args[0] = file.toString();
                    }
                } else {
                    this._args = new String[5];
                    this._args[0] = "-codebase";
                    this._args[1] = string;
                    this._args[2] = "-documentbase";
                    this._args[3] = string2;
                    this._args[4] = file.toString();
                }
                DeployOfflineManager.setForcedOffline((boolean)false);
                object = new Throwable[]{null};
                try {
                    Thread thread = new Thread(Main.getMainThreadGroup(), new Runnable((Throwable[])object){
                        final /* synthetic */ Throwable[] val$e;
                        {
                            this.val$e = throwableArray;
                        }

                        @Override
                        public void run() {
                            try {
                                JNLP2Viewer.main(WebStart.this._args);
                            }
                            catch (Throwable throwable) {
                                this.val$e[0] = throwable;
                            }
                        }
                    });
                    thread.start();
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                finally {
                    if (object[0] == null) break block16;
                    throw new RuntimeException(object[0]);
                }
            }
        }
    }
}

