/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc.windows;

import com.sun.deploy.util.ByteBufferWrapper;
import com.sun.deploy.util.SystemUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import sun.plugin2.ipc.NamedPipe;
import sun.plugin2.os.windows.Windows;

public class WindowsNamedPipe
extends NamedPipe {
    private long writeHandle = -1L;
    private long readHandle = -1L;
    private String writeName;
    private String readName;
    private boolean iAmServer;
    private boolean connected;
    private IOException connectException;
    private boolean connectFailed;
    private boolean created;
    private RuntimeException createException;
    private boolean createFailed;
    private IntBuffer numReadBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
    private IntBuffer numWrittenBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();

    public WindowsNamedPipe(long l, long l2, String string, String string2, boolean bl) {
        this.writeHandle = l;
        this.readHandle = l2;
        this.writeName = string;
        this.readName = string2;
        this.iAmServer = bl;
        if (bl) {
            this.startConnectThread();
        } else {
            this.startCreateThread();
        }
    }

    private void startConnectThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                try {
                    int n;
                    object = Windows.ConnectNamedPipe(WindowsNamedPipe.this.writeHandle, null);
                    if (!((Windows.BooleanResult)object).isSuccess() && (n = ((Windows.BooleanResult)object).errorCode()) != 535) {
                        throw new IOException("Error " + n + " connecting named pipe");
                    }
                    object = Windows.ConnectNamedPipe(WindowsNamedPipe.this.readHandle, null);
                    if (!((Windows.BooleanResult)object).isSuccess() && (n = ((Windows.BooleanResult)object).errorCode()) != 535) {
                        throw new IOException("Error " + n + " connecting named pipe");
                    }
                    WindowsNamedPipe windowsNamedPipe = WindowsNamedPipe.this;
                    synchronized (windowsNamedPipe) {
                        WindowsNamedPipe.this.connected = true;
                    }
                }
                catch (IOException iOException) {
                    WindowsNamedPipe windowsNamedPipe = WindowsNamedPipe.this;
                    synchronized (windowsNamedPipe) {
                        WindowsNamedPipe.this.connectException = iOException;
                        WindowsNamedPipe.this.connectFailed = true;
                    }
                }
                object = WindowsNamedPipe.this;
                synchronized (object) {
                    WindowsNamedPipe.this.notifyAll();
                }
            }
        }, "Pipe Connector Thread").start();
    }

    private void startCreateThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WindowsNamedPipe windowsNamedPipe;
                do {
                    try {
                        if (WindowsNamedPipe.this.writeHandle == -1L && !WindowsNamedPipe.this.createFailed) {
                            WindowsNamedPipe.this.writeHandle = Windows.CreateFileA("\\\\.\\pipe\\" + WindowsNamedPipe.this.writeName, 2, 0, null, 3, 128, 0L, true);
                            if (WindowsNamedPipe.this.writeHandle == 0L) {
                                throw new RuntimeException("Error opening named pipe \"\\\\.\\pipe\\" + WindowsNamedPipe.this.writeName + "\"  for writing");
                            }
                        }
                        if (WindowsNamedPipe.this.readHandle == -1L && !WindowsNamedPipe.this.createFailed) {
                            WindowsNamedPipe.this.readHandle = Windows.CreateFileA("\\\\.\\pipe\\" + WindowsNamedPipe.this.readName, 1, 0, null, 3, 128, 0L, true);
                            if (WindowsNamedPipe.this.readHandle == 0L) {
                                throw new RuntimeException("Error opening named pipe \"\\\\.\\pipe\\" + WindowsNamedPipe.this.readName + "\" for reading");
                            }
                        }
                        windowsNamedPipe = WindowsNamedPipe.this;
                        synchronized (windowsNamedPipe) {
                            if (WindowsNamedPipe.this.writeHandle != -1L && WindowsNamedPipe.this.readHandle != -1L) {
                                WindowsNamedPipe.this.created = true;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        WindowsNamedPipe windowsNamedPipe2 = WindowsNamedPipe.this;
                        synchronized (windowsNamedPipe2) {
                            WindowsNamedPipe.this.createException = runtimeException;
                            WindowsNamedPipe.this.createFailed = true;
                        }
                    }
                } while (!WindowsNamedPipe.this.created && !WindowsNamedPipe.this.createFailed);
                windowsNamedPipe = WindowsNamedPipe.this;
                synchronized (windowsNamedPipe) {
                    WindowsNamedPipe.this.notifyAll();
                }
            }
        }, "Pipe Create Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnection() throws IOException {
        if (this.iAmServer) {
            WindowsNamedPipe windowsNamedPipe = this;
            synchronized (windowsNamedPipe) {
                while (!this.connected) {
                    if (this.connectFailed) {
                        if (this.connectException != null) {
                            throw this.connectException;
                        }
                        throw new IOException("Never received connection from client side");
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        WindowsNamedPipe windowsNamedPipe = this;
        synchronized (windowsNamedPipe) {
            while (!this.created) {
                if (this.createFailed) {
                    if (this.createException != null) {
                        throw this.createException;
                    }
                    throw new IOException("Never received connection from client side");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public int read(ByteBufferWrapper byteBufferWrapper) throws IOException {
        this.waitForConnection();
        int n = byteBufferWrapper.remaining();
        int n2 = 0;
        do {
            long l = SystemUtils.microTime();
            Windows.BooleanResult booleanResult = Windows.ReadFile(this.readHandle, byteBufferWrapper.getBuffer(), n, this.numReadBuffer, null);
            n2 = this.numReadBuffer.get(0);
            if (booleanResult.isSuccess()) continue;
            long l2 = SystemUtils.microTime();
            throw new IOException("Error " + booleanResult.errorCode() + " reading from " + this + ", numRead " + n2 + ", ReadFile ts: " + l + ", now ts: " + l2 + ", dT " + (l2 - l));
        } while (n2 == 0);
        byteBufferWrapper.position(byteBufferWrapper.position() + n2);
        return n2;
    }

    @Override
    public int write(ByteBufferWrapper byteBufferWrapper) throws IOException {
        this.waitForConnection();
        int n = byteBufferWrapper.remaining();
        while (byteBufferWrapper.hasRemaining()) {
            long l = SystemUtils.microTime();
            Windows.BooleanResult booleanResult = Windows.WriteFile(this.writeHandle, byteBufferWrapper.getBuffer(), n, this.numWrittenBuffer, null);
            int n2 = this.numWrittenBuffer.get(0);
            if (!booleanResult.isSuccess()) {
                long l2 = SystemUtils.microTime();
                throw new IOException("Error " + booleanResult.errorCode() + " writing to " + this + ": numWritten " + n2 + ", WriteFile ts: " + l + ", now ts: " + l2 + ", dT " + (l2 - l));
            }
            byteBufferWrapper.position(byteBufferWrapper.position() + n2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object;
        Object object2;
        if (this.writeHandle == 0L || this.readHandle == 0L) {
            throw new IOException("Already closed");
        }
        if (this.iAmServer) {
            object2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    Windows.DisconnectNamedPipe(WindowsNamedPipe.this.writeHandle);
                    Windows.DisconnectNamedPipe(WindowsNamedPipe.this.readHandle);
                }
            }, "Pipe Disconnector Thread");
            ((Thread)object2).start();
            try {
                ((Thread)object2).join(500L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.createFailed = true;
        }
        object2 = new boolean[1];
        Runnable runnable = new Runnable((boolean[])object2){
            final /* synthetic */ boolean[] val$resBox;
            {
                this.val$resBox = blArray;
            }

            @Override
            public void run() {
                boolean bl = Windows.CloseHandle(WindowsNamedPipe.this.writeHandle);
                boolean bl2 = Windows.CloseHandle(WindowsNamedPipe.this.readHandle);
                this.val$resBox[0] = bl && bl2;
            }
        };
        if (this.iAmServer) {
            object = new Thread(runnable, "Pipe Closer Thread");
            ((Thread)object).start();
            try {
                ((Thread)object).join(500L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            runnable.run();
        }
        this.writeHandle = 0L;
        this.readHandle = 0L;
        object = this;
        synchronized (object) {
            this.connectFailed = true;
            this.notifyAll();
        }
        if (object2[0] == false) {
            throw new IOException("Error closing " + this);
        }
    }

    @Override
    public boolean isOpen() {
        return this.writeHandle != 0L && this.readHandle != 0L;
    }

    @Override
    public String toString() {
        return "WindowsNamedPipe: server: " + this.iAmServer + "; readPipe: " + this.readName + ", readBufferSz: " + 4096 + "; writePipe: " + this.writeName + ", writeBufferSz: " + 4096;
    }

    @Override
    public Map<String, String> getChildProcessParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("write_pipe_name", this.readName);
        hashMap.put("read_pipe_name", this.writeName);
        return hashMap;
    }
}

