/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.deploy.config.OSType;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.impl.awt.ui.AWTDialog;
import com.sun.deploy.uitoolkit.ui.AbstractDialog;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import sun.awt.AWTAccessor;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.SunToolkit;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.main.client.ModalityInterface;
import sun.plugin2.os.windows.FLASHWINFO;
import sun.plugin2.os.windows.Windows;
import sun.plugin2.uitoolkit.ui.ModalityHelper;

public class AWTModalityHelper
implements ModalityHelper {
    private final LinkedList<Plugin2Manager> managersShowingSystemDialogs = new LinkedList();
    private static Reactivator reactivator;

    AWTModalityHelper() {
    }

    @Override
    public boolean installModalityListener(ModalityInterface modality) {
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (tk instanceof SunToolkit) {
                SunToolkit stk = (SunToolkit)tk;
                stk.addModalityListener(new PluginModalityListener(modality));
                Trace.println((String)"Added plugin modalityListener", (TraceLevel)TraceLevel.UI);
                return true;
            }
            Trace.println((String)("Not a SunToolkit: " + tk), (TraceLevel)TraceLevel.UI);
        }
        catch (Throwable t) {
            Trace.ignored((Throwable)t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushManagerShowingSystemDialog() {
        Plugin2Manager manager = Plugin2Manager.getCurrentManager();
        LinkedList<Plugin2Manager> linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            this.managersShowingSystemDialogs.addFirst(manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plugin2Manager getManagerShowingSystemDialog() {
        LinkedList<Plugin2Manager> linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            if (!this.managersShowingSystemDialogs.isEmpty()) {
                return this.managersShowingSystemDialogs.getFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popManagerShowingSystemDialog() {
        Plugin2Manager manager = Plugin2Manager.getCurrentManager();
        LinkedList<Plugin2Manager> linkedList = this.managersShowingSystemDialogs;
        synchronized (linkedList) {
            Iterator iter = this.managersShowingSystemDialogs.iterator();
            while (iter.hasNext()) {
                if (iter.next() != manager) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public void reactivateDialog(AbstractDialog dialog) {
        if (dialog instanceof AWTDialog) {
            this.getReactivator().reactivate(((AWTDialog)dialog).getDialog());
        } else {
            Trace.println((String)"reactivateDialog: not an AWTDialog");
        }
    }

    private Reactivator getReactivator() {
        if (reactivator == null) {
            reactivator = OSType.isWin() ? new WindowsReactivator() : new NoopReactivator();
        }
        return reactivator;
    }

    static class PluginModalityListener
    implements ModalityListener {
        private ModalityInterface modality;

        PluginModalityListener(ModalityInterface modality) {
            this.modality = modality;
        }

        @Override
        public void modalityPushed(ModalityEvent ev) {
            this.modality.modalityPushed((AbstractDialog)AWTDialog.getAWTDialog((Dialog)((Dialog)ev.getSource())));
        }

        @Override
        public void modalityPopped(ModalityEvent ev) {
            this.modality.modalityPopped((AbstractDialog)AWTDialog.getAWTDialog((Dialog)((Dialog)ev.getSource())));
        }
    }

    static class WindowsReactivator
    implements Reactivator {
        private Method getHWndMethod;

        WindowsReactivator() {
        }

        @Override
        public void reactivate(Dialog dialog) {
            if (this.getHWndMethod == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            try {
                                Class<?> c = Class.forName("sun.awt.windows.WComponentPeer");
                                Method m = c.getDeclaredMethod("getHWnd", new Class[0]);
                                getHWndMethod = m;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long hWnd = 0L;
            try {
                Object peer = AWTAccessor.getComponentAccessor().getPeer(dialog);
                hWnd = (Long)this.getHWndMethod.invoke(peer, (Object[])null);
                Windows.MessageBeep(0);
                FLASHWINFO info = FLASHWINFO.create();
                info.cbSize(FLASHWINFO.size());
                info.hwnd(hWnd);
                info.dwFlags(1);
                info.uCount(3);
                info.dwTimeout(64);
                Windows.FlashWindowEx(info);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class NoopReactivator
    implements Reactivator {
        NoopReactivator() {
        }

        @Override
        public void reactivate(Dialog dialog) {
        }
    }

    static interface Reactivator {
        public void reactivate(Dialog var1);
    }
}

