/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.uitoolkit.impl.awt;

import com.sun.applet2.Applet2Host;
import com.sun.deploy.trace.Trace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.ImageObserver;
import sun.plugin.util.UIUtil;
import sun.plugin2.uitoolkit.impl.awt.AWTAnimationPanel2;

class AWTGrayBoxPanel
extends Panel
implements ComponentListener,
ImageObserver {
    private static final long serialVersionUID = 8418107633233369368L;
    private static final Color LOADING_BORDER = new Color(153, 153, 153);
    private Color backgroundColor;
    private Color foregroundColor;
    private AWTAnimationPanel2 m_panel = null;
    private Container m_parent;
    private int m_maxValue;
    private boolean m_boxBorder = true;
    private Image m_image = null;
    private boolean m_imageIsCentered = false;
    private boolean m_animateImage = true;
    long startTimeMillis;
    int endSequenceMillis = 2000;
    private Image backBufferImage;
    private int backBufferImageWidth;
    private int backBufferImageHeight;

    public AWTGrayBoxPanel(Container parent) {
        this(parent, Color.WHITE);
    }

    public AWTGrayBoxPanel(Container parent, Color bgColor) {
        this(parent, bgColor, Color.BLACK);
    }

    public AWTGrayBoxPanel(Container parent, Color bgColor, Color fgColor) {
        this(parent, bgColor, fgColor, null);
    }

    public AWTGrayBoxPanel(Container parent, Color bgColor, Color fgColor, Applet2Host h) {
        this.m_parent = parent;
        this.setBgColor(bgColor);
        this.setFgColor(fgColor);
        this.setLayout(new BorderLayout());
        UIUtil.disableBackgroundErase(this);
    }

    public void setCustomImage(Image image, boolean centered) {
        this.setImage(image, centered);
    }

    public void setBgColor(Color bgColor) {
        this.backgroundColor = bgColor;
        this.setBackground(bgColor);
        if (this.m_panel != null) {
            this.m_panel.setBoxBGColor(bgColor);
        }
    }

    public void setFgColor(Color fgColor) {
        this.foregroundColor = fgColor;
        this.setForeground(fgColor);
        if (this.m_panel != null) {
            this.m_panel.setBoxFGColor(fgColor);
        }
    }

    public void setBoxBorder(boolean drawBorder) {
        this.m_boxBorder = drawBorder;
    }

    public void stopOnError() {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
            this.removeAll();
            this.m_panel = null;
            this.validate();
        }
    }

    public void setMaxProgressValue(int max) {
        this.m_maxValue = max;
    }

    public void progress(int curValue) {
        long timeLeftMillis = (long)(this.m_maxValue - curValue) * (System.currentTimeMillis() - this.startTimeMillis) / (long)(curValue + 1);
        if (this.m_panel != null) {
            float value = (float)curValue / (float)this.m_maxValue;
            if (timeLeftMillis > (long)this.endSequenceMillis) {
                this.m_panel.setProgressValue(value);
            } else {
                this.m_panel.fadeAway();
            }
        } else {
            this.repaint();
        }
    }

    public void start() {
        if (this.m_panel == null && this.m_image == null) {
            this.m_panel = new AWTAnimationPanel2();
            this.m_panel.setCursor(new Cursor(12));
            this.add((Component)this.m_panel, "Center");
            this.m_panel.setBoxBGColor(this.backgroundColor);
            this.m_panel.setBoxFGColor(this.foregroundColor);
        }
        this.startTimeMillis = System.currentTimeMillis();
        if (this.m_panel != null) {
            this.m_panel.startAnimation();
        } else if (this.m_image != null) {
            this.m_animateImage = true;
            this.repaint();
        }
        this.m_parent.addComponentListener(this);
    }

    public void stop() {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
        }
        this.m_animateImage = false;
        this.m_parent.removeComponentListener(this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        try {
            Dimension d = this.m_parent.getSize();
            if (this.m_panel != null) {
                this.m_panel.repaint();
            } else {
                if (this.backBufferImage == null || this.backBufferImageWidth != d.width || this.backBufferImageHeight != d.height) {
                    if (this.backBufferImage != null) {
                        this.backBufferImage.flush();
                    }
                    int w = Math.max(1, d.width);
                    int h = Math.max(1, d.height);
                    this.backBufferImage = this.createImage(w, h);
                    this.backBufferImageWidth = w;
                    this.backBufferImageHeight = h;
                }
                Graphics bbg = this.backBufferImage.getGraphics();
                bbg.setColor(this.backgroundColor);
                bbg.fillRect(0, 0, this.backBufferImageWidth, this.backBufferImageHeight);
                if (this.m_image != null) {
                    int imgWidth = this.m_image.getWidth(this);
                    int imgHeight = this.m_image.getHeight(this);
                    if (this.m_imageIsCentered && imgWidth >= 0 && imgHeight >= 0) {
                        this.drawImage(bbg, this.m_image, (this.backBufferImageWidth - imgWidth) / 2, (this.backBufferImageHeight - imgHeight) / 2);
                    } else if (d.width > 24 && d.height > 24) {
                        this.drawImage(bbg, this.m_image, 1, 1);
                    } else {
                        this.drawImage(bbg, this.m_image, 0, 0);
                    }
                }
                g.drawImage(this.backBufferImage, 0, 0, null);
            }
            if (this.m_boxBorder && d.width > 24 && d.height > 24) {
                this.drawBorder(g, d);
            }
        }
        catch (Exception e) {
            Trace.ignoredException((Exception)e);
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x10) != 0) {
            if (this.m_animateImage) {
                this.repaint();
            }
            return this.m_animateImage;
        }
        if ((infoflags & 0x20) != 0) {
            this.repaint();
        }
        return true;
    }

    private void drawImage(Graphics g, Image image, int x, int y) {
        g.drawImage(image, x, y, this.backgroundColor, this);
    }

    private void drawBorder(Graphics g, Dimension d) {
        Color color = LOADING_BORDER;
        Color oldColor = g.getColor();
        g.setColor(color);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        g.setColor(oldColor);
    }

    private synchronized void setImage(Image image, boolean centered) {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
            this.removeAll();
            this.m_panel = null;
        }
        this.m_image = image;
        this.m_imageIsCentered = centered;
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension d = this.m_parent.getSize();
        this.setSize(d);
        if (this.m_panel != null) {
            this.m_panel.setSize(d);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

