/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.BasicService;
import sun.awt.DesktopBrowse;

public final class BasicServiceImpl
implements BasicService {
    private URL _codebase = null;
    private String _codebaseProtocol = null;
    private boolean _isWebBrowserSupported;
    private static BasicServiceImpl _sharedInstance = null;
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write,delete,execute"));
            ((PermissionCollection)perms).add(new SocketPermission("*", "connect,resolve"));
            if (Config.isJavaVersionAtLeast18()) {
                ((PermissionCollection)perms).add(new URLPermission("http:*", "*:*"));
                ((PermissionCollection)perms).add(new URLPermission("https:*", "*:*"));
            }
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    private BasicServiceImpl(URL codebase, boolean isWebBrowserSupported, String codebaseProtocol) {
        this._codebaseProtocol = codebaseProtocol;
        this._codebase = codebase;
        this._isWebBrowserSupported = isWebBrowserSupported;
        try {
            DesktopBrowse.setInstance((DesktopBrowse)new BasicServiceBrowser());
        }
        catch (IllegalStateException e) {
            if (Config.getDebug()) {
                e.printStackTrace(System.out);
            }
        }
        catch (Throwable t) {
            Trace.ignored((Throwable)t);
        }
    }

    public static BasicServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static void initialize(URL codebase, boolean isWebBrowserSupported, String codebaseProtocol) {
        if (_sharedInstance == null) {
            _sharedInstance = new BasicServiceImpl(codebase, isWebBrowserSupported, codebaseProtocol);
        }
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    public boolean isOffline() {
        return DeployOfflineManager.isGlobalOffline();
    }

    private boolean isFileProtocolCodebase() {
        return this._codebaseProtocol != null && this._codebaseProtocol.equalsIgnoreCase("file");
    }

    private boolean isValidURL(URL url) {
        LaunchDesc ld = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        URL mainJarURL = ld.getMainJarURL();
        return mainJarURL == null || URLUtil.checkDocumentURL((URL)mainJarURL, (URL)url);
    }

    static boolean isArgumentOkay(String arg) {
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (' ' >= c || c >= '~') {
                return false;
            }
            if (c != '\\' && c != '\"') continue;
            return false;
        }
        return true;
    }

    public boolean showDocument(URL url) {
        if (url == null) {
            return false;
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException exc) {
            exc.printStackTrace();
            return false;
        }
        if (!URLUtil.checkDocumentURL((URL)this._codebase, (URL)url)) {
            return false;
        }
        DesktopBrowse browser = DesktopBrowse.getInstance();
        if (browser != null && !(browser instanceof BasicServiceBrowser)) {
            if (!this.isWebBrowserSupported()) {
                return false;
            }
            try {
                url = new URL(this._codebase, url.toString());
                if (!BasicServiceImpl.isArgumentOkay(url.toString())) {
                    return false;
                }
                if (!this.isValidURL(url)) {
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            browser.browse(url);
            return true;
        }
        return this.showDocumentHelper(url);
    }

    private boolean showDocumentHelper(final URL url) {
        boolean isJNLPSuffix = url.toString().toLowerCase().endsWith(".jnlp");
        boolean isCached = ResourceProvider.get().isCached(url, null);
        Boolean retValue = null;
        if ((isJNLPSuffix || isCached) && (retValue = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                URL filtered = URLUtil.filterProtocols((URL)url);
                if (DownloadEngine.isJnlpURL((URL)filtered)) {
                    try {
                        String path;
                        Resource r = ResourceProvider.get().getResource(filtered, null, false, 1, null);
                        String string = path = r != null ? r.getResourceFilename() : url.toString();
                        if (path != null && BasicServiceImpl.isArgumentOkay(path)) {
                            String[] cmd = new String[]{Environment.getJavawsCommand(), "-Xnosplash", path};
                            Runtime.getRuntime().exec(cmd);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Trace.ignored((Throwable)e);
                    }
                }
                return false;
            }
        }, ACC_FILE_INSTANCE)) != null && retValue.booleanValue()) {
            return true;
        }
        if (!this.isWebBrowserSupported()) {
            return false;
        }
        try {
            final URL absURL = new URL(this._codebase, url.toString());
            if (!BasicServiceImpl.isArgumentOkay(absURL.toString())) {
                return false;
            }
            if (!this.isValidURL(absURL)) {
                return false;
            }
            retValue = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Platform.get().showDocument(absURL);
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return retValue == null ? false : retValue;
    }

    public boolean isWebBrowserSupported() {
        return this._isWebBrowserSupported;
    }

    public void logPerfStartMessage(String msg) {
    }

    public void logPerfEndMessage(String msg) {
    }

    public void logPerfTime(String msg) {
    }

    private class BasicServiceBrowser
    extends DesktopBrowse {
        private BasicServiceBrowser() {
        }

        public void browse(URL url) {
            BasicServiceImpl.this.showDocument(url);
        }
    }
}

