/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.exceptions;

import com.sun.javaws.jnl.LaunchDesc;

public abstract class JNLPException
extends Exception {
    private static final long serialVersionUID = 909208916002358615L;
    private static LaunchDesc _defaultLaunchDesc = null;
    private LaunchDesc _exceptionLaunchDesc = null;
    private String _categoryMsg = null;

    public JNLPException(String category) {
        this(category, null, null);
    }

    public JNLPException(String category, LaunchDesc ld) {
        this(category, ld, null);
    }

    public JNLPException(String category, Throwable exception) {
        this(category, null, exception);
    }

    public JNLPException(String category, LaunchDesc ld, Throwable wrappedException) {
        super(wrappedException);
        this._categoryMsg = category;
        this._exceptionLaunchDesc = ld;
    }

    public static void setDefaultLaunchDesc(LaunchDesc ld) {
        _defaultLaunchDesc = ld;
    }

    public static LaunchDesc getDefaultLaunchDesc() {
        return _defaultLaunchDesc;
    }

    @Override
    public String getMessage() {
        return this.getRealMessage();
    }

    public String getBriefMessage() {
        return null;
    }

    protected abstract String getRealMessage();

    public LaunchDesc getLaunchDesc() {
        return this._exceptionLaunchDesc != null ? this._exceptionLaunchDesc : _defaultLaunchDesc;
    }

    public String getLaunchDescSource() {
        LaunchDesc ld = this.getLaunchDesc();
        if (ld == null) {
            return null;
        }
        return ld.getSource();
    }

    public String getCategory() {
        return this._categoryMsg;
    }

    public Throwable getWrappedException() {
        return this.getCause();
    }

    @Override
    public String toString() {
        return "JNLPException[category: " + this._categoryMsg + " : Exception: " + this.getCause() + " : LaunchDesc: " + (String)(this._exceptionLaunchDesc == null || this._exceptionLaunchDesc.getXmlNode() == null ? "null" : this._exceptionLaunchDesc.getXmlNode().toString(true) + " ]");
    }
}

