/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.impl.awt.AWTAppContext;
import java.net.URLPermission;
import java.security.Permission;
import java.util.HashSet;
import sun.awt.AWTSecurityManager;
import sun.plugin2.applet.SecurityManagerHelper;
import sun.plugin2.uitoolkit.impl.awt.AWTDragHelper;

public class AWTAppletSecurityManager
extends AWTSecurityManager {
    private final AppContext mainAppContext;
    private final SecurityManager awtSM = new AWTSecurityManager();
    private final HashSet<String> restrictedPackages = new HashSet();

    public AWTAppletSecurityManager() {
        SecurityManagerHelper.resetHelper(this.restrictedPackages);
        this.mainAppContext = ToolkitStore.get().getAppContext();
    }

    public void checkConnect(String string, int n) {
        SecurityManagerHelper.checkConnectHelper(this.awtSM, string, n, null, false, this.getClassContext());
    }

    public void checkConnect(String string, int n, Object object) {
        SecurityManagerHelper.checkConnectHelper(this.awtSM, string, n, object, true, this.getClassContext());
    }

    public void checkPermission(Permission permission) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.awtSM, permission, null, false, this.getClassContext());
            return;
        }
        super.checkPermission(permission);
        SecurityManagerHelper.checkPermissionHelper(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.awtSM, permission, object, true, this.getClassContext());
            return;
        }
        super.checkPermission(permission, object);
    }

    public void checkAccess(Thread thread) {
        SecurityManagerHelper.checkAccessHelper(thread, this.awtSM, this.getCurrentClassLoader(), this.getClassContext());
    }

    public void checkAccess(ThreadGroup threadGroup) {
        SecurityManagerHelper.checkAccessHelper(threadGroup, this.awtSM, this.getCurrentClassLoader(), this.getClassContext());
    }

    public void checkPackageAccess(String string) {
        SecurityManagerHelper.checkPackageAccessHelper(this.awtSM, string, this.restrictedPackages);
    }

    public void checkPrintJobAccess() {
        SecurityManagerHelper.checkPrintJobAccessHelper(this.awtSM);
    }

    public void checkSecurityAccess(String string) {
        SecurityManagerHelper.checkSecurityAccessHelper(this.awtSM, string);
    }

    public sun.awt.AppContext getAppContext() {
        AppContext appContext = SecurityManagerHelper.getAppContextHelper(this.getCurrentClassLoader(), this.getClassContext());
        if (appContext instanceof AWTAppContext) {
            return ((AWTAppContext)appContext).getAWTAppContext();
        }
        return null;
    }

    public ThreadGroup getThreadGroup() {
        return SecurityManagerHelper.getThreadGroupHelper(this.awtSM, this.getCurrentClassLoader(), this.getClassContext());
    }

    public boolean checkTopLevelWindow(Object object) {
        if (object == null) {
            throw new NullPointerException("window can't be null");
        }
        if (object instanceof AWTDragHelper.DraggedAppletJFrame || object instanceof AWTDragHelper.DraggedAppletFrame) {
            return false;
        }
        return super.checkTopLevelWindow(object);
    }

    private ClassLoader getCurrentClassLoader() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }
}

