/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.plugin2.jvm.JVMEventListener;
import sun.plugin2.jvm.ProcessLauncher;

public class JVMLauncher
implements ProcessLauncher {
    private static final boolean DEBUG = Config.getDebug();
    private long jvmLaunchTime;
    private final long appletLaunchTime;
    private final String javaHome;
    private final JVMParameters params;
    private boolean isRelaunch = false;
    private JREInfo jreInfo = null;
    private Process process;
    private volatile boolean exited;
    private int exitCode = -1;
    private Exception error;
    private final ArrayList<JVMEventListener> listeners = new ArrayList();

    public JVMLauncher(long l, String string, JVMParameters jVMParameters, boolean bl) {
        this.appletLaunchTime = l;
        this.javaHome = string;
        this.jreInfo = JREInfo.findByJREPath((String)string);
        this.params = jVMParameters;
        this.isRelaunch = bl;
    }

    @Override
    public synchronized void addJVMEventListener(JVMEventListener jVMEventListener) {
        this.listeners.add(jVMEventListener);
    }

    @Override
    public void start() {
        ProcessBuilder processBuilder;
        Object object;
        Iterator iterator;
        Object object2;
        List list;
        Object object3;
        Object object4;
        Object object5;
        boolean bl = Config.useSecureLaunch((JREInfo)this.jreInfo);
        this.jvmLaunchTime = SystemUtils.microTime();
        if (DEBUG) {
            System.out.println("JVMLauncher.start: launcher params:");
            object5 = this.params.getCommandLineArguments(this.jreInfo, true);
            object4 = object5.iterator();
            while (object4.hasNext()) {
                System.out.println("\t<" + (String)object4.next() + ">");
            }
        }
        if (DEBUG) {
            System.out.println("JVMLauncher.start(): now - user.startApplet(): " + (this.jvmLaunchTime - this.appletLaunchTime) + " us");
        }
        object5 = "-D__applet_launched=" + this.appletLaunchTime;
        object4 = "-D__jvm_launched=" + this.jvmLaunchTime;
        String string = null;
        this.exited = false;
        this.error = null;
        if (bl) {
            string = Config.getJavaCommand();
            if (string == null) {
                throw new RuntimeException("Unable to locate the java launcher in java.home");
            }
            object3 = Platform.get().findSecureLauncher(null);
            if (object3 == null) {
                throw new RuntimeException("Unable to locate the Java Plug-In's custom launcher in java.home \"" + System.getProperty("java.home") + "\"");
            }
            list = this.params.getCommandLineArguments(this.jreInfo, false, true, true, true, true);
            list.add(0, object3);
            list.add(1, object4);
            list.add(2, object5);
        } else {
            int n;
            string = Config.getJavaCommand((String)this.javaHome);
            if (string == null) {
                throw new RuntimeException("Unable to locate the java launcher in \"" + this.javaHome + "\"");
            }
            list = this.params.getCommandLineArguments(this.jreInfo, false, true, true, true, false);
            object2 = null;
            iterator = list.iterator();
            int n2 = list.size();
            for (n = 0; n < n2 && JVMParameters.isJVMCommandLineArgument((String)(object2 = (String)iterator.next())); ++n) {
                if (!((String)object2).equals("--add-modules") || !iterator.hasNext()) continue;
                iterator.next();
            }
            if (n == n2) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: no main class found");
                this.fireJVMExited();
                return;
            }
            if (object2 != null && !((String)object2).equals("sun.plugin2.main.client.PluginMain") && !((String)object2).equals("jdk.plugin/sun.plugin2.main.client.PluginMain")) {
                this.exited = true;
                this.error = new RuntimeException("Invalid arguments: PluginMain main class not found");
                this.fireJVMExited();
                return;
            }
            list.add(0, string);
            list.add(1, object4);
            list.add(2, object5);
        }
        object3 = list;
        if (bl) {
            JVMParameters jVMParameters = null;
            object2 = this.params.getCommandLineArguments(null, false, false, false, this.isRelaunch, false);
            iterator = object2.iterator();
            while (iterator.hasNext() && !((String)(object = (String)iterator.next())).equals("sun.plugin2.main.client.PluginMain") && !((String)object).equals("-m")) {
                if (this.jreInfo.getVmArgs() != null && this.jreInfo.getVmArgs().contains((CharSequence)object)) {
                    if (!DEBUG) continue;
                    System.out.println("skip: " + (String)object);
                    continue;
                }
                if (jVMParameters == null) {
                    jVMParameters = new JVMParameters();
                }
                jVMParameters.setIncludeExtendedASCIIValues(true);
                jVMParameters.addArgument((String)object);
            }
            if (DEBUG) {
                System.out.println("JVMLauncher, added secureJvmParms: " + jVMParameters);
            }
            object3 = ArgumentParsingUtil.getSecureLaunchArgs((JREInfo)this.jreInfo, (List)list, jVMParameters, (boolean)this.isRelaunch, (boolean)true);
        }
        if ((iterator = (String)(object2 = (processBuilder = new ProcessBuilder((List<String>)object3)).environment()).get("LD_LIBRARY_PATH")) != null) {
            object = ((String)((Object)iterator)).split(File.pathSeparator);
            String string2 = Config.getJREHome();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!((String)object[i]).startsWith(string2)) continue;
                object[i] = null;
            }
            Object object6 = null;
            for (Object object7 : object) {
                if (object7 == null) continue;
                object6 = object6 == null ? object7 : (String)object6 + File.pathSeparator + (String)object7;
            }
            object2.put("LD_LIBRARY_PATH", object6);
        }
        if (OSType.isMac()) {
            object2.put("LC_CTYPE", "UTF-8");
        }
        object2.remove("CLASSPATH");
        try {
            this.process = Platform.get().startProcessBuilder(processBuilder);
            this.afterStart();
        }
        catch (Exception exception) {
            this.exited = true;
            this.error = exception;
        }
    }

    protected void afterStart() {
        System.out.println("JVMLauncher.afterStart(): starting JVM process watcher");
        new Thread(new JVMWatcher()).start();
    }

    public JVMParameters getParameters() {
        return this.params;
    }

    @Override
    public void addParameter(String string) {
        this.params.addArgument(string);
    }

    @Override
    public void clearUserArguments() {
        this.params.clearUserArguments();
    }

    @Override
    public boolean exited() {
        return this.exited;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public Exception getErrorDuringStartup() {
        return this.error;
    }

    @Override
    public void destroy() {
        this.process.destroy();
    }

    @Override
    public InputStream getInputStream() {
        if (this.process != null) {
            return this.process.getInputStream();
        }
        return null;
    }

    @Override
    public InputStream getErrorStream() {
        if (this.process != null) {
            return this.process.getErrorStream();
        }
        return null;
    }

    @Override
    public long getJVMLaunchTime() {
        return this.jvmLaunchTime;
    }

    public long getAppletLaunchTime() {
        return this.appletLaunchTime;
    }

    private synchronized List<JVMEventListener> copyListeners() {
        return (List)this.listeners.clone();
    }

    private void fireJVMExited() {
        for (JVMEventListener jVMEventListener : this.copyListeners()) {
            jVMEventListener.jvmExited(this);
        }
    }

    class JVMWatcher
    implements Runnable {
        JVMWatcher() {
        }

        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    JVMLauncher.this.exitCode = JVMLauncher.this.process.waitFor();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    Trace.printException((Throwable)interruptedException);
                }
            }
            JVMLauncher.this.exited = true;
            JVMLauncher.this.fireJVMExited();
        }
    }
}

