/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.XMLUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class EmbeddedJNLPValidation {
    private final LaunchDesc jnlp;
    private final URL codebase;

    public EmbeddedJNLPValidation(LaunchDesc jnlp, URL derivedCodebase) {
        String host;
        if (derivedCodebase == null || jnlp == null) {
            throw new IllegalArgumentException("Should have jnlp and derivedCodebase.");
        }
        if (derivedCodebase.getProtocol().equals("http") && ((host = derivedCodebase.getHost()) == null || host.length() == 0)) {
            throw new IllegalArgumentException("Bad derivedCodebase: " + derivedCodebase);
        }
        this.jnlp = jnlp;
        this.codebase = derivedCodebase;
    }

    public void validate() throws BadFieldException {
        String codebaseAttr = this.getCodebase();
        if (codebaseAttr != null && codebaseAttr.trim().length() > 0) {
            throw new RuntimeException("Embbeded JNLP should not have non-empty codebase. Got: " + codebaseAttr);
        }
        String href = this.getHref();
        href = href == null ? "" : href.trim();
        try {
            URL url = new URL(href);
            throw new RuntimeException("Absolute href not allowed with embbedded JNLP: " + href);
        }
        catch (MalformedURLException url) {
            try {
                URL derived = new URL(this.codebase, href);
                if (!URLUtil.sameBase((URL)this.codebase, (URL)derived)) {
                    throw new RuntimeException("Invalid 'href' value in embedded JNLP: " + href);
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Invalid URL derived with href: " + href, ex);
            }
            return;
        }
    }

    private String getCodebase() throws BadFieldException {
        return XMLUtils.getAttribute(this.jnlp.getXmlNode(), "", "codebase");
    }

    private String getHref() throws BadFieldException {
        return XMLUtils.getAttribute(this.jnlp.getXmlNode(), "", "href");
    }
}

