/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.ui;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.SafeThreadFactory;

public final class ConsoleTraceListener
implements TraceListener {
    private static final long MIN_CONSOLE_OUTPUT_INTERVAL = 100L;
    private ConsoleWindow console = null;
    private final BoundedStringBuffer buffer;
    private Thread writerThread;
    private ConsoleWriter writer;
    private boolean running;

    public ConsoleTraceListener() {
        this(1048575);
    }

    public ConsoleTraceListener(int n) {
        this.buffer = new BoundedStringBuffer(n);
    }

    @Override
    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void setConsole(ConsoleWindow consoleWindow) {
        if (this.console == consoleWindow) {
            return;
        }
        if (consoleWindow == null) {
            Trace.println("Calling ConsoleTraceListener.setConsole() with null console", TraceLevel.UI);
            this.cleanupWriter();
            return;
        }
        if (this.console != null || this.writer != null) {
            Trace.println("Calling ConsoleTraceListener.setConsole() when console already set", TraceLevel.UI);
            this.cleanupWriter();
        }
        this.buffer.setBound(0);
        this.console = consoleWindow;
        this.running = true;
        this.writerThread = SafeThreadFactory.createThread(new ConsoleWriter(), "ConsoleTraceListener");
        this.writerThread.setDaemon(true);
        this.writerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        BoundedStringBuffer boundedStringBuffer = this.buffer;
        synchronized (boundedStringBuffer) {
            boolean bl = this.buffer.length() == 0;
            this.buffer.append(string);
            if (bl && this.console != null) {
                this.buffer.notifyAll();
            }
        }
    }

    private void cleanupWriter() {
        if (this.writerThread != null && this.writerThread.isAlive()) {
            this.running = false;
            this.writerThread.interrupt();
            this.writerThread = null;
        }
    }

    String getTraceMessages() {
        return this.buffer.toString();
    }

    void stopWriter() {
        if (this.writerThread != null) {
            this.running = false;
            this.writerThread.interrupt();
        }
    }

    static class BoundedStringBuffer {
        private int bound;
        private final StringBuffer sb = new StringBuffer();

        BoundedStringBuffer(int n) {
            this.bound = n;
        }

        public String toString() {
            return this.sb.toString();
        }

        public boolean equals(Object object) {
            return this.sb.equals(object);
        }

        public int hashCode() {
            return this.sb.hashCode();
        }

        int length() {
            return this.sb.length();
        }

        void append(String string) {
            if (this.bound == 0) {
                this.sb.append(string);
                return;
            }
            int n = 0;
            int n2 = this.sb.length() + string.length();
            if (n2 > this.bound) {
                n = n2 - this.bound;
            }
            if (n > this.sb.length()) {
                this.clear();
            } else {
                this.sb.delete(0, n);
            }
            this.sb.append(string);
        }

        void clear() {
            this.sb.delete(0, this.sb.length());
        }

        void setBound(int n) {
            this.bound = n;
        }
    }

    class ConsoleWriter
    implements Runnable {
        ConsoleWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = System.currentTimeMillis();
            while (ConsoleTraceListener.this.running) {
                String string;
                long l2 = System.currentTimeMillis();
                BoundedStringBuffer boundedStringBuffer = ConsoleTraceListener.this.buffer;
                synchronized (boundedStringBuffer) {
                    if (l2 - l < 100L || ConsoleTraceListener.this.buffer.length() <= 0) {
                        try {
                            if (ConsoleTraceListener.this.buffer.length() == 0) {
                                ConsoleTraceListener.this.buffer.wait();
                            } else {
                                ConsoleTraceListener.this.buffer.wait(100L - (l2 - l));
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    string = ConsoleTraceListener.this.buffer.toString();
                    ConsoleTraceListener.this.buffer.clear();
                    l = l2;
                }
                ConsoleTraceListener.this.console.append(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            String string;
            BoundedStringBuffer boundedStringBuffer = ConsoleTraceListener.this.buffer;
            synchronized (boundedStringBuffer) {
                if (ConsoleTraceListener.this.buffer.length() <= 0) {
                    return;
                }
                string = ConsoleTraceListener.this.buffer.toString();
                ConsoleTraceListener.this.buffer.clear();
            }
            ConsoleTraceListener.this.console.append(string);
        }
    }
}

