/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.LoggerTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class FileTraceListener
implements TraceListener {
    private static FileTraceListener sharedInstance;
    private File logFile;
    private PrintStream fileTraceStream;
    private boolean append;

    public static synchronized FileTraceListener getOrCreateSharedInstance(File file, File file2, String string, String string2, boolean bl, boolean bl2) {
        if (sharedInstance == null || bl2) {
            file = LoggerTraceListener.ensureLogFileAvailable(file, file2, string, string2);
            sharedInstance = new FileTraceListener(file, bl);
        }
        return sharedInstance;
    }

    public FileTraceListener(File file, boolean bl) {
        this.append = bl;
        this.logFile = file;
        this.init();
    }

    private void init() {
        try {
            this.fileTraceStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile.getPath(), this.append)));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
            this.print("Log started: " + simpleDateFormat.format(new Date()) + "\n");
            this.print(Trace.getIntro());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void print(String string) {
        try {
            if (this.logFile.length() >= (long)(Config.getIntProperty("deployment.max.output.file.size") * 0x100000)) {
                int n;
                this.fileTraceStream.close();
                File file = File.createTempFile("javaws", ".temp", this.logFile.getParentFile());
                long l = this.logFile.length() / 4L;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedReader.skip(l * 3L);
                while ((n = bufferedReader.read()) != -1) {
                    bufferedWriter.write(n);
                }
                bufferedReader.close();
                bufferedWriter.close();
                if (this.logFile.delete()) {
                    file.renameTo(this.logFile);
                    this.init();
                }
            }
            this.fileTraceStream.print(string);
            this.fileTraceStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void flush() {
    }
}

