/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ref;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SystemUtils;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.List;

public class CodeRef {
    private final URL jarLocation;
    private final String jarVersion;
    private final CodeSigner[] signers;
    private String checksum;
    private String checksumAlg;
    private final boolean isCodebase;
    private final boolean pack200Enabled;
    private static final AccessControlContext ACC_FILE_INSTANCE;

    public CodeRef(URL uRL, String string, boolean bl, boolean bl2) {
        this.jarLocation = uRL;
        this.jarVersion = string;
        this.isCodebase = bl;
        this.pack200Enabled = bl2;
        this.signers = null;
        this.checksum = null;
        this.checksumAlg = null;
    }

    public CodeRef(URL uRL, String string, CodeSigner[] codeSignerArray, String string2, String string3) {
        this.jarLocation = uRL;
        this.jarVersion = string;
        this.isCodebase = false;
        this.pack200Enabled = false;
        this.signers = codeSignerArray;
        this.checksum = string2;
        String string4 = this.checksumAlg = string2 == null ? null : "SHA-256";
        if (string3 != null && !string3.equalsIgnoreCase("SHA-256")) {
            System.out.println("Warning: invalid checksum algorithm in CodeRef constructor: " + string3);
        }
    }

    public URL getJarLocation() {
        return this.jarLocation;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof CodeRef)) {
            return false;
        }
        CodeRef codeRef = (CodeRef)object;
        boolean bl2 = this.jarLocation == null ? codeRef.jarLocation == null : (bl = this.jarLocation.toExternalForm().equals(codeRef.jarLocation.toExternalForm()));
        boolean bl3 = this.jarVersion == null ? codeRef.jarVersion == null : this.jarVersion.equals(codeRef.jarVersion);
        return bl && bl3;
    }

    public int hashCode() {
        return (this.jarLocation == null ? 0 : this.jarLocation.toExternalForm().hashCode()) + (this.jarVersion == null ? 0 : this.jarVersion.hashCode());
    }

    public CodeSigner[] getCodeSigners() throws IOException {
        Resource resource;
        if (this.signers == null && !this.isCodebase && (resource = this.getResource()) != null) {
            return resource.getCodeSigners();
        }
        return this.signers;
    }

    public Certificate[] getCerts(CodeSigner codeSigner) {
        List<? extends Certificate> list = codeSigner.getSignerCertPath().getCertificates();
        return list.toArray(new Certificate[0]);
    }

    private Resource getResource() throws IOException {
        boolean bl = !DeployOfflineManager.isForcedOffline();
        int n = this.pack200Enabled ? 4352 : 1;
        try {
            return ResourceProvider.get().getResource(this.jarLocation, this.jarVersion, bl, n, null);
        }
        catch (Exception exception) {
            return ResourceProvider.get().getResource(this.jarLocation, this.jarVersion, false, n, null);
        }
    }

    public String getChecksum(String string) throws IOException {
        if (this.checksum == null && !this.isCodebase) {
            if (string != null && !string.equalsIgnoreCase("SHA-256")) {
                throw new IOException("Invalid checksum algorithm: " + string);
            }
            final String[] stringArray = new String[]{""};
            try {
                final Resource resource = this.getResource();
                if (resource != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            stringArray[0] = SystemUtils.getFileChecksum(resource.getDataFile(), "SHA-256");
                            return null;
                        }
                    }, ACC_FILE_INSTANCE);
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            this.checksum = stringArray[0];
        }
        return this.checksum;
    }

    public String toString() {
        String string = this.isCodebase ? "\n        codebase: " + this.jarLocation : "\n        jar location: " + this.jarLocation + "\n        jar version: " + this.jarVersion;
        return string;
    }

    static {
        Permissions permissions = new Permissions();
        FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)permissions).add(filePermission);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

