/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class CacheUpgradeHelper {
    private static final boolean DEBUG = Config.getDebug();
    private static List<CacheUpgradeHelper> helpers = new ArrayList<CacheUpgradeHelper>();

    protected synchronized void register() {
        if (!helpers.contains(this)) {
            helpers.add(this);
        }
    }

    public static void upgradeLocalAppProperties(CacheEntry cacheEntry, CacheEntry cacheEntry2) {
        for (int i = 0; i < helpers.size(); ++i) {
            CacheUpgradeHelper cacheUpgradeHelper = helpers.get(i);
            if (!cacheUpgradeHelper.canProcess(cacheEntry2.getCacheVersion())) continue;
            cacheUpgradeHelper.processLocalAppProperties(cacheEntry, cacheEntry2);
        }
    }

    public abstract void processLocalAppProperties(CacheEntry var1, CacheEntry var2);

    public boolean canProcess(int n) {
        return true;
    }

    protected static Properties loadProperties(File file) {
        try {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(Cache.getLapBytes(file)));
            return properties;
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            return null;
        }
    }

    protected static String getLapFileName(CacheEntry cacheEntry) {
        return cacheEntry.getResourceFilename() + "6.0" + Cache.getVersionTag(cacheEntry.getVersion()) + ".lap";
    }

    protected static Properties getProperties(CacheEntry cacheEntry) {
        File file = new File(CacheUpgradeHelper.getLapFileName(cacheEntry));
        if (file.isFile()) {
            return CacheUpgradeHelper.loadProperties(file);
        }
        return null;
    }

    static String getHelperJarPaths() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < helpers.size(); ++i) {
            String string = SystemUtils.getJarPath(helpers.get(i).getClass());
            if (DEBUG && !new File(string).exists()) {
                System.out.println("Wrong path: " + string);
            }
            stringBuffer.append(string);
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }
}

