/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;

public class Environment {
    public static final int ENV_PLUGIN = 0;
    public static final int ENV_JAVAWS = 1;
    private static int environmentType = 0;
    private static boolean _isWebJava = true;
    private static boolean _isJavawsAppletLifecycle = false;
    private static boolean _isOldPlugin = false;
    private static boolean _isGlobalException = false;
    public static final String JRE_EXPIRED = "JRE_EXPIRED";
    public static final String JRE_NOTEXPIRED = "JRE_NOTEXPIRED";
    public static final String JAVA_AUTOUPDATE = "JAVA_AUTOUPDATE";
    public static final String DEPLOY_DEBUG = "DEPLOY_DEBUG";
    public static final String DEPLOY_VERBOSE = "DEPLOY_VERBOSE";
    public static final String PLUGIN_DEBUG = "JPI_PLUGIN2_DEBUG";
    public static final String PLUGIN_VERBOSE = "JPI_PLUGIN2_VERBOSE";
    public static final String USERPROFILE = "USERPROFILE";
    public static final String USER_JPI_PROFILE = "USER_JPI_PROFILE";
    public static final String NO_HEARTBEAT = "JPI_PLUGIN2_NO_HEARTBEAT";
    public static final String FORCED_CLIENTVM_ARGS = "FORCED_CLIENTVM_ARGS";
    public static final String JPI_VM_OPTIONS = "_JPI_VM_OPTIONS";
    public static final String FORCED_DEPLOY_ROOT = "FORCED_DEPLOY_ROOT";
    public static final String FORCED_JRE_ROOT = "FORCED_JRE_ROOT";
    public static final String FORCED_BOOTCLASSPATH = "FORCED_BOOTCLASSPATH";
    public static final String FORCED_BROWSERLIB = "FORCED_OVERRIDE_BROWSERLIB";
    public static final String PIPE_LOGDIR = "JPI2_PIPE_LOGDIR";
    public static final String FORCE_DRAGGABLE = "JPI_PLUGIN2_FORCE_DRAGGABLE";
    public static final String JPI_INJECT = "JPI_PLUGIN2_INJECT_PLUGIN2MANAGER";
    public static final String MOZILLA_HOME = "MOZILLA_HOME";
    public static final String NO_XEMBED = "JPI_PLUGIN2_NO_XEMBED";
    public static final String XDG_DATA_HOME = "XDG_DATA_HOME";
    public static final String DISABLE_406251_WORKAROUND = "JPI_PLUGIN2_DISABLE_406251_WORKAROUND";
    private static String codebaseOverride = null;
    private static URL codebase = null;
    private static Date timestamp = null;
    private static Date expiration = null;
    private static String userAgent = null;
    private static boolean isSystemCache = false;
    private static boolean isSilentMode = false;
    private static boolean isImportMode = false;
    private static boolean isInstallMode = false;
    private static boolean _getenvSupported = true;
    private static String _javaHome;
    private static File deployment_home;
    private static String deploy_home_path;

    public static boolean isGlobalException() {
        return _isGlobalException;
    }

    public static void setGlobalException(boolean bl) {
        _isGlobalException = bl;
    }

    public static boolean isJavawsAppletLifecycle() {
        return _isJavawsAppletLifecycle;
    }

    public static void setJavawsAppletLifecycle(boolean bl) {
        _isJavawsAppletLifecycle = bl;
    }

    public static boolean isWebJava() {
        return _isWebJava;
    }

    public static void setIsWebJava(boolean bl) {
        _isWebJava = bl;
    }

    public static boolean isOldPlugin() {
        return _isOldPlugin;
    }

    public static void setOldPlugin(boolean bl) {
        _isOldPlugin = bl;
    }

    public static void setEnvironmentType(int n) {
        environmentType = n;
    }

    public static boolean isJavaWebStart() {
        return environmentType == 1;
    }

    public static boolean isJavaPlugin() {
        return environmentType == 0;
    }

    public static void setImportModeTimestamp(Date date) {
        timestamp = date != null ? new Date(date.getTime()) : null;
    }

    public static Date getImportModeTimestamp() {
        return timestamp != null ? new Date(timestamp.getTime()) : null;
    }

    public static void setImportModeExpiration(Date date) {
        expiration = date != null ? new Date(date.getTime()) : null;
    }

    public static Date getImportModeExpiration() {
        return expiration != null ? new Date(expiration.getTime()) : null;
    }

    public static void setImportModeCodebase(URL uRL) {
        codebase = uRL;
    }

    public static void setImportModeCodebaseOverride(String string) {
        if (string != null && !string.endsWith("/")) {
            string = string + "/";
        }
        codebaseOverride = string;
    }

    public static URL getImportModeCodebase() {
        return codebase;
    }

    public static String getImportModeCodebaseOverride() {
        return codebaseOverride;
    }

    public static void setUserAgent(String string) {
        userAgent = string;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static boolean isSystemCacheMode() {
        return isSystemCache;
    }

    public static void setSystemCacheMode(boolean bl) {
        isSystemCache = bl;
    }

    public static boolean isSilentMode() {
        return isSilentMode;
    }

    public static void setSilentMode(boolean bl) {
        isSilentMode = bl;
    }

    public static boolean isImportMode() {
        return isImportMode;
    }

    public static void setImportMode(boolean bl) {
        isImportMode = bl;
    }

    public static boolean isInstallMode() {
        return isInstallMode;
    }

    public static void setInstallMode(boolean bl) {
        isInstallMode = bl;
    }

    public static String getenv(final String string) {
        try {
            if (_getenvSupported && string != null) {
                return AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getenv(string);
                    }
                });
            }
        }
        catch (Error error) {
            _getenvSupported = false;
        }
        return null;
    }

    public static String getForcedJreRoot() {
        return Environment.getenv(FORCED_JRE_ROOT);
    }

    public static String getForcedDeployRoot() {
        String string = Environment.getenv(FORCED_DEPLOY_ROOT);
        try {
            return new File(string).getCanonicalPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getForcedBootClassPath() {
        return Environment.getenv(FORCED_BOOTCLASSPATH);
    }

    public static boolean isForcedJreRoot(String string) {
        return Environment.getForcedJreRoot() != null && string != null && string.startsWith(Environment.getForcedJreRoot());
    }

    public static String getJavaHome() {
        if (_javaHome == null) {
            String string = Environment.getForcedDeployRoot();
            if (string != null) {
                _javaHome = string;
            } else {
                string = System.getProperty("jnlpx.home");
                if (string == null) {
                    string = System.getProperty("java.home");
                }
                _javaHome = string;
            }
        }
        return _javaHome;
    }

    public static void setJavaHome(String string) {
        _javaHome = string;
    }

    public static String getJavawsCommand() {
        String string = Environment.getDeploymentHomePath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "bin" + File.separator + "javaws" + Platform.get().getPlatformExtension();
        return string;
    }

    private static File constructJavawPath(File file) {
        boolean bl = Config.getOSName().contains("Windows");
        return new File(file, "bin" + File.separator + (bl ? "javaw" : "java") + Platform.get().getPlatformExtension());
    }

    public static String getJavawCommand() {
        File file = Environment.constructJavawPath(new File(Environment.getJavaHome()));
        return file.getPath();
    }

    public static File getDeploymentHome() {
        Object object;
        if (null != deployment_home) {
            return deployment_home;
        }
        String string = Environment.getForcedDeployRoot();
        if (string != null && ((object = new File(string)).exists() || object.isDirectory())) {
            Trace.println("Use deploy home from FORCED_DEPLOY_ROOT: " + string, TraceLevel.BASIC);
            deployment_home = object;
            return deployment_home;
        }
        string = System.getProperty("sun.boot.class.path");
        if (string != null) {
            try {
                object = string.split(File.pathSeparator);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                object = StringUtils.splitString(string, File.pathSeparator);
            }
            for (String string2 : object) {
                if (!string2.endsWith("deploy.jar")) continue;
                deployment_home = new File(string2).getParentFile().getParentFile();
                Trace.println("Derive deploy home from bootclasspath: " + string2, TraceLevel.BASIC);
                return deployment_home;
            }
        }
        if ((string = System.getProperty("jdk.module.path")) != null) {
            deployment_home = new File(string).getParentFile();
            Trace.println("Derive deploy home from jdk.module.path: " + deployment_home, TraceLevel.BASIC);
            return deployment_home;
        }
        try {
            object = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Environment.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                }
            });
            String string3 = URLDecoder.decode((String)object, "UTF-8");
            deployment_home = new File(string3).getParentFile().getParentFile();
            if (deployment_home.exists()) {
                return deployment_home;
            }
            deployment_home = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string = Environment.getJavaHome();
        Trace.println("Assume Java home: " + string, TraceLevel.BASIC);
        deployment_home = new File(string);
        return deployment_home;
    }

    public static String getDeploymentHomePath() {
        if (deploy_home_path == null) {
            try {
                deploy_home_path = Environment.getDeploymentHome().getCanonicalPath();
            }
            catch (Exception exception) {
                deploy_home_path = Environment.getDeploymentHome().getPath();
            }
        }
        return deploy_home_path;
    }

    static {
        deployment_home = null;
        deploy_home_path = null;
    }
}

