/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.TrustedLibraries;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SimpleJarVerifier
extends JarVerifier {
    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        return new SimpleJarVerifier(uRL, string, file, file2);
    }

    private SimpleJarVerifier(URL uRL, String string, File file, File file2) {
        super(uRL, string, file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(DownloadDelegate downloadDelegate) throws IOException, JARSigningException {
        JarFile jarFile = JarUtil.createJarFile(this.jarFile, true);
        this.manifest = jarFile.getManifest();
        try {
            int n = jarFile.size();
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            Enumeration<JarEntry> enumeration = jarFile.entries();
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, 0, n);
            }
            while (enumeration.hasMoreElements()) {
                ++n2;
                String string = null;
                JarEntry jarEntry = null;
                jarEntry = enumeration.nextElement();
                string = jarEntry.getName();
                if (!bl) {
                    try {
                        bl = BlackList.getInstance().checkJarEntry(jarFile, jarEntry);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new JARSigningException(this.jarLocation, this.jarVersion, 5, generalSecurityException);
                    }
                }
                if (!bl2) {
                    try {
                        bl2 = TrustedLibraries.checkJarEntry(jarFile, jarEntry);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        Attributes attributes = this.manifest.getMainAttributes();
                        attributes.putValue("Trusted-Library", Boolean.TRUE.toString());
                    }
                }
                if (JarUtil.canSkipEntry(jarEntry)) continue;
                this.authenticateJarEntry(jarFile, jarEntry);
                this.processCertificates(jarFile, jarEntry, string);
                this.processSigners(jarFile, jarEntry, string);
                if (downloadDelegate == null || n2 % 10 != 0 && n2 < n) continue;
                downloadDelegate.validating(this.jarLocation, n2, n);
            }
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, n, n);
            }
        }
        finally {
            jarFile.close();
            this.warnIfUnsigned();
        }
    }

    @Override
    protected void authenticateJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, JARSigningException {
        String string = jarEntry.getName();
        boolean bl = this.nativePath != null && string.indexOf("/") == -1 && string.indexOf("\\") == -1;
        try {
            SimpleJarVerifier.readAndMaybeSaveStreamTo(jarFile.getInputStream(jarEntry), bl, string, this.nativePath);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, securityException);
        }
    }
}

