/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.ImmutableCertStore;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;
import javax.swing.JDialog;

public class DeployClientAuthCertStore
implements CertStore {
    private static JDialog myParent = null;
    private static String _userFilename = null;
    private static String _systemFilename = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private KeyStore _deploymentUserClientCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemClientCerts = CertUtils.createEmptyKeyStore();
    private char[] keyPass = null;
    private boolean cancelFlag = false;
    private int certStoreType = 0;

    protected DeployClientAuthCertStore(JDialog jDialog, int n) {
        myParent = jDialog;
        this.certStoreType = n;
    }

    public static CertStore getCertStore(JDialog jDialog) {
        return new ImmutableCertStore(new DeployClientAuthCertStore(jDialog, 3));
    }

    public static DeployClientAuthCertStore getUserCertStore(JDialog jDialog) {
        return new DeployClientAuthCertStore(jDialog, 1);
    }

    public static CertStore getSystemCertStore(JDialog jDialog) {
        return new ImmutableCertStore(new DeployClientAuthCertStore(jDialog, 2));
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long l;
        if ((this.certStoreType & 1) == 1 && _userFilename != null && (l = CertUtils.getFileLastModified(_userFilename)) != this._userLastModified) {
            this._deploymentUserClientCerts = this.loadCertStore(_userFilename, bl);
            this._userLastModified = l;
        }
        if ((this.certStoreType & 2) == 2 && _systemFilename != null && (l = CertUtils.getFileLastModified(_systemFilename)) != this._sysLastModified) {
            this._deploymentSystemClientCerts = this.loadCertStore(_systemFilename, bl);
            this._sysLastModified = l;
        }
    }

    private KeyStore loadCertStore(final String string, final boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.loading", new Object[]{string});
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(string);
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        if (bl) {
                            DeployClientAuthCertStore.access$002(DeployClientAuthCertStore.this, DeployClientAuthCertStore.this.getPasswordDialog());
                            if (DeployClientAuthCertStore.this.keyPass != null) {
                                DeployClientAuthCertStore.this.cancelFlag = false;
                                keyStore.load(bufferedInputStream, DeployClientAuthCertStore.this.keyPass);
                            } else {
                                DeployClientAuthCertStore.this.cancelFlag = true;
                            }
                        } else {
                            keyStore.load(bufferedInputStream, null);
                        }
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.loaded", new Object[]{string});
        return keyStore;
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.saving", new Object[]{_userFilename});
        if (this.keyPass != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                        File file = new File(_userFilename);
                        file.getParentFile().mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        DeployClientAuthCertStore.this._deploymentUserClientCerts.store(bufferedOutputStream, DeployClientAuthCertStore.this.keyPass);
                        bufferedOutputStream.close();
                        fileOutputStream.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                if (exception instanceof KeyStoreException) {
                    throw (KeyStoreException)exception;
                }
                if (exception instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)exception;
                }
                Trace.securityPrintException(privilegedActionException);
            }
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.saved", new Object[]{_userFilename});
    }

    @Override
    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, null, false);
    }

    @Override
    public boolean add(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.adding");
        String string2 = this._deploymentUserClientCerts.getCertificateAlias(certificate);
        if (string2 == null) {
            Random random = new Random();
            boolean bl2 = false;
            String string3 = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._deploymentUserClientCerts.getCertificate(string3 = "clientauthcert" + random.nextLong())) != null) continue;
                bl2 = true;
            } while (!bl2);
            this._deploymentUserClientCerts.setCertificateEntry(string3, certificate);
            Trace.msgSecurityPrintln("clientauthcertstore.cert.added", new Object[]{string3});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCertKey(Certificate[] certificateArray, Key key) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        String string = this._deploymentUserClientCerts.getCertificateAlias(certificateArray[0]);
        if (string == null) {
            Serializable serializable;
            Random random = new Random();
            boolean bl = false;
            String string2 = null;
            do {
                if ((serializable = this._deploymentUserClientCerts.getCertificate(string2 = "clientauthcert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            if (this.keyPass == null && !this.cancelFlag) {
                this.keyPass = this.getPasswordDialog();
            }
            if (this.keyPass != null) {
                serializable = new File(_userFilename);
                if (((File)serializable).exists()) {
                    FileInputStream fileInputStream = new FileInputStream(_userFilename);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    try {
                        this._deploymentUserClientCerts.load(bufferedInputStream, this.keyPass);
                        this._deploymentUserClientCerts.setKeyEntry(string2, key, this.keyPass, certificateArray);
                    }
                    catch (Exception exception) {
                        Trace.securityPrintException(exception);
                        boolean bl2 = false;
                        return bl2;
                    }
                    finally {
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                } else {
                    this._deploymentUserClientCerts.setKeyEntry(string2, key, this.keyPass, certificateArray);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Certificate[] certificateArray = new Certificate[]{certificate};
        return this.remove(certificateArray);
    }

    public boolean remove(Certificate[] certificateArray) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.removing");
        String string = null;
        if (this.keyPass != null) {
            try {
                File file = new File(_userFilename);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new BufferedInputStream(new FileInputStream(file)), this.keyPass);
                for (int i = 0; i < certificateArray.length; ++i) {
                    string = this._deploymentUserClientCerts.getCertificateAlias(certificateArray[i]);
                    if (string == null) continue;
                    this._deploymentUserClientCerts.deleteEntry(string);
                }
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof KeyStoreException) {
                    throw (KeyStoreException)exception;
                }
                Trace.securityPrintException(exception);
                return false;
            }
        } else {
            return false;
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.removed", new Object[]{string});
        return true;
    }

    @Override
    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, null, false);
    }

    @Override
    public boolean contains(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.instore");
        String string2 = null;
        string2 = this._deploymentSystemClientCerts.getCertificateAlias(certificate);
        if (string2 != null) {
            return true;
        }
        string2 = this._deploymentUserClientCerts.getCertificateAlias(certificate);
        return string2 != null;
    }

    @Override
    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.canverify");
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        if ((this.certStoreType & 1) == 1) {
            hashSet.addAll(this.getCertificates(1));
        }
        if ((this.certStoreType & 2) == 2) {
            hashSet.addAll(this.getCertificates(2));
        }
        return hashSet;
    }

    private Collection<X509Certificate> getCertificates(int n) throws KeyStoreException {
        Object object;
        Trace.msgSecurityPrintln("clientauthcertstore.cert.getcertificates");
        KeyStore keyStore = null;
        keyStore = n == 1 ? this._deploymentUserClientCerts : this._deploymentSystemClientCerts;
        Enumeration<String> enumeration = keyStore.aliases();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)object)) continue;
            treeSet.add(object);
        }
        object = new ArrayList();
        for (String string : treeSet) {
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            if (certificateArray == null) continue;
            for (Certificate certificate : certificateArray) {
                object.add((X509Certificate)certificate);
            }
        }
        return object;
    }

    protected char[] getPasswordDialog() {
        CredentialInfo credentialInfo = ToolkitStore.getUI().showPasswordDialog(myParent, DeployClientAuthCertStore.getMessage("password.dialog.title"), DeployClientAuthCertStore.getMessage("clientauth.user.password.dialog.text"), false, false, null, false, null);
        if (credentialInfo == null) {
            return null;
        }
        return credentialInfo.getPassword();
    }

    private static String getMessage(String string) {
        return ResourceManager.getString(string);
    }

    static /* synthetic */ char[] access$002(DeployClientAuthCertStore deployClientAuthCertStore, char[] cArray) {
        deployClientAuthCertStore.keyPass = cArray;
        return cArray;
    }

    static {
        _userFilename = Config.getUserClientAuthCertFile();
        _systemFilename = Config.getSystemClientAuthCertFile();
    }
}

