/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.VersionString;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;

public class JREDesc
implements ResourceType {
    private String _version;
    private int _versionType;
    public static final int PRODUCT_VERSION = 0;
    public static final int PLATFORM_VERSION = 1;
    private boolean _isSecure;
    private boolean _isForced;
    private long _maxHeap;
    private long _minHeap;
    private String _vmargs;
    private URL _href;
    private ResourcesDesc _resourceDesc;
    private LaunchDesc _extensioDesc;
    private boolean _invalidPlatform;
    private String _archList;

    public JREDesc(String string, long l, long l2, String string2, URL uRL, ResourcesDesc resourcesDesc, String string3) {
        this._version = string;
        this._versionType = uRL != null ? 0 : 1;
        this._maxHeap = l2;
        this._minHeap = l;
        this._vmargs = string2;
        this._href = uRL;
        this._resourceDesc = resourcesDesc;
        this._extensioDesc = null;
        this._invalidPlatform = false;
        this._isSecure = false;
        this._isForced = false;
        this._archList = string3;
        if (uRL == null) {
            VersionString versionString = new VersionString(string);
            String[] stringArray = new String[]{"9", "1.8", "1.7", "1.6", "1.5", "1.4", "1.3"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!versionString.contains(stringArray[i])) continue;
                return;
            }
            Trace.println((String)("WARNING - specified JRE version, " + string + " is invalid platform version"), (TraceLevel)TraceLevel.BASIC);
            this._invalidPlatform = true;
        }
    }

    public JREDesc(String string, boolean bl) {
        this._versionType = 0;
        if (string.equals("SECURE")) {
            this._isSecure = true;
            this._version = null;
        } else if (string.startsWith("SECURE-")) {
            this._isSecure = true;
            this._version = string.substring(7);
        } else {
            this._isSecure = false;
            this._version = string;
        }
        this._isForced = bl;
    }

    public String toString() {
        return "JREDesc[version " + this._version + ", versionType=" + this._versionType + ", secure=" + this._isSecure + ", heap=" + this._minHeap + "-" + this._maxHeap + ", args=" + this._vmargs + ", href=" + this._href + ", " + this._resourceDesc + ", " + this._extensioDesc + "]";
    }

    public String[] getArchList() {
        return GeneralUtil.getStringList((String)this._archList);
    }

    public int getVersionType() {
        return this._versionType;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public boolean isVersionForced() {
        return this._isForced;
    }

    public String getVersion() {
        return this._version;
    }

    public URL getHref() {
        return this._href;
    }

    public long getMinHeap() {
        return this._minHeap;
    }

    public long getMaxHeap() {
        return this._maxHeap;
    }

    public String getVmArgs() {
        return this._vmargs;
    }

    public ResourcesDesc getNestedResources() {
        return this._resourceDesc;
    }

    public LaunchDesc getExtensionDesc() {
        return this._extensioDesc;
    }

    public void setExtensionDesc(LaunchDesc launchDesc) {
        this._extensioDesc = launchDesc;
    }

    @Override
    public void visit(ResourceVisitor resourceVisitor) {
        resourceVisitor.visitJREDesc(this);
    }

    public String getSource() {
        if (this._href != null) {
            return this._href.getHost();
        }
        try {
            URL uRL = new URL(Config.getStringProperty((String)"deployment.javaws.installURL"));
            return uRL.getHost();
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
            return "";
        }
    }

    public boolean isInvalidPlatform() {
        return this._invalidPlatform;
    }

    public XMLNode asXML() {
        XMLNode xMLNode;
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        if (this._archList != null) {
            xMLAttributeBuilder.add("arch", this._archList);
        }
        if (this._minHeap > 0L) {
            xMLAttributeBuilder.add("initial-heap-size", this._minHeap);
        }
        if (this._maxHeap > 0L) {
            xMLAttributeBuilder.add("max-heap-size", this._maxHeap);
        }
        if (this._vmargs != null) {
            xMLAttributeBuilder.add("java-vm-args", this._vmargs);
        }
        xMLAttributeBuilder.add("href", this._href);
        if (this._version != null) {
            xMLAttributeBuilder.add("version", this._version);
        }
        XMLNode xMLNode2 = xMLNode = this._extensioDesc != null ? this._extensioDesc.asXML() : null;
        if (this._resourceDesc != null) {
            xMLNode = this._resourceDesc.asXML();
        }
        return new XMLNode("java", xMLAttributeBuilder.getAttributeList(), xMLNode, null);
    }
}

