/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.File;

public class NativeLibLoader {
    private static final boolean DEBUG = Config.getDebug();

    private NativeLibLoader() {
    }

    public static synchronized void load(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new InternalError("Wrong library name passed to load method");
        }
        String[] stringArray2 = NativeLibLoader.getPossibleSubdirs();
        String string = SystemPropertyUtil.getProperty((String)"sun.boot.class.path");
        String[] stringArray3 = new String[]{};
        if (string != null) {
            stringArray3 = string.split(File.pathSeparator);
        }
        String string2 = Environment.getForcedDeployRoot();
        if (!(string != null && (string2 != null && NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray2, string2 + File.separator + "lib" + File.separator + "deploy.jar") || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray2, NativeLibLoader.findGrandParent(stringArray3, "plugin.jar")) || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray2, NativeLibLoader.findGrandParent(stringArray3, "deploy.jar")) || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray2, NativeLibLoader.findGrandParent(stringArray3, "javaws.jar")) || NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray2, NativeLibLoader.findGrandParent(stringArray3, "modules"))))) {
            String string3 = System.getProperty("jdk.module.path");
            if (string3 != null && NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray2, string3 = new File(string3).getParent())) {
                return;
            }
            string3 = System.getProperty("java.home");
            if (string3 != null && !NativeLibLoader.tryLoadingFromJRE(stringArray, stringArray2, string3)) {
                throw new InternalError("Unable to find plugin native libraries");
            }
        }
    }

    private static boolean tryLoadingFromJRE(String[] stringArray, String[] stringArray2, String string) {
        if (string == null) {
            return false;
        }
        boolean bl = true;
        for (String string2 : stringArray) {
            File file;
            boolean bl2 = false;
            if (string2.equalsIgnoreCase("npjp2") || string2.equalsIgnoreCase("jp2iexp")) {
                Object object;
                block11: {
                    try {
                        object = Platform.get().getLoadedNativeLibPath(string2);
                        if (object != null) {
                            if (DEBUG) {
                                System.err.println("NativeLibLoader: resolving loaded " + (String)object);
                            }
                            if ((file = new File((String)object)).exists() && file.canRead()) {
                                System.load(file.getAbsolutePath());
                                if (!DEBUG) continue;
                                System.err.println("   (Succeeded)");
                                continue;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG) break block11;
                        throwable.printStackTrace();
                    }
                }
                if ((Environment.getenv((String)"FORCED_DEPLOY_ROOT") != null || Environment.getenv((String)"FORCED_JRE_ROOT") != null) && Environment.getenv((String)"FORCED_OVERRIDE_BROWSERLIB") == null) {
                    object = new File(System.getProperty("java.home"));
                    for (int i = 0; i < stringArray2.length && !bl2; ++i) {
                        bl2 = NativeLibLoader.tryLoading(string2, (File)object, stringArray2[i]);
                    }
                    if (bl2) continue;
                    bl = false;
                    continue;
                }
            }
            for (int i = 0; i < stringArray2.length && !bl2; ++i) {
                file = new File(string);
                bl2 = NativeLibLoader.tryLoading(string2, file, stringArray2[i]);
            }
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    private static String[] getPossibleSubdirs() {
        String string;
        String string2 = SystemPropertyUtil.getProperty((String)"sun.boot.library.path");
        if (!string2.startsWith(string = Environment.getJavaHome())) {
            throw new InternalError("sun.boot.library.path (\"" + string2 + "\") did not start with java.home (\"" + string + "\")");
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith(File.separator)) {
            string3 = string3.substring(1);
        }
        String string4 = "jre" + File.separator + string3;
        String string5 = string3 + File.separator + "plugin2";
        String string6 = string4 + File.separator + "plugin2";
        return new String[]{string3, string4, string5, string6};
    }

    private static boolean tryLoading(String string, File file, String string2) {
        File file2;
        if (file == null) {
            return false;
        }
        File file3 = file;
        if (string2 != null) {
            file3 = new File(file, string2);
        }
        if (!(file2 = new File(file3, System.mapLibraryName(string))).exists()) {
            if (DEBUG) {
                System.err.println("NativeLibLoader: " + file2.getAbsolutePath() + " doesn't exist");
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("NativeLibLoader: trying to load " + file2.getAbsolutePath());
        }
        System.load(file2.getAbsolutePath());
        if (DEBUG) {
            System.err.println("  (Succeeded)");
        }
        return true;
    }

    private static String findGrandParent(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            File file;
            if (!string2.endsWith(string) || (file = new File(string2).getParentFile()) == null) continue;
            if ("modules".equals(file.getName().toLowerCase())) {
                File file2 = file.getParentFile();
                if (file2 == null) continue;
                return file2.getParent();
            }
            return file.getParent();
        }
        return null;
    }
}

