/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.File;

public class NativeLibLoader {
    private static final boolean DEBUG = Config.getDebug();

    private NativeLibLoader() {
    }

    public static synchronized void load(String[] libs) {
        if (libs == null || libs.length == 0) {
            throw new InternalError("Wrong library name passed to load method");
        }
        String[] possibleSubdirs = NativeLibLoader.getPossibleSubdirs();
        String bootClassPath = SystemPropertyUtil.getProperty((String)"sun.boot.class.path");
        String[] bootClassPaths = new String[]{};
        if (bootClassPath != null) {
            bootClassPaths = bootClassPath.split(File.pathSeparator);
        }
        String forcedDeployRoot = Environment.getForcedDeployRoot();
        if (!(bootClassPath != null && (forcedDeployRoot != null && NativeLibLoader.tryLoadingFromJRE(libs, possibleSubdirs, forcedDeployRoot + File.separator + "lib" + File.separator + "deploy.jar") || NativeLibLoader.tryLoadingFromJRE(libs, possibleSubdirs, NativeLibLoader.findGrandParent(bootClassPaths, "plugin.jar")) || NativeLibLoader.tryLoadingFromJRE(libs, possibleSubdirs, NativeLibLoader.findGrandParent(bootClassPaths, "deploy.jar")) || NativeLibLoader.tryLoadingFromJRE(libs, possibleSubdirs, NativeLibLoader.findGrandParent(bootClassPaths, "javaws.jar")) || NativeLibLoader.tryLoadingFromJRE(libs, possibleSubdirs, NativeLibLoader.findGrandParent(bootClassPaths, "modules"))))) {
            String pathToJRE = System.getProperty("jdk.module.path");
            if (pathToJRE != null && NativeLibLoader.tryLoadingFromJRE(libs, possibleSubdirs, pathToJRE = new File(pathToJRE).getParent())) {
                return;
            }
            pathToJRE = System.getProperty("java.home");
            if (pathToJRE != null && !NativeLibLoader.tryLoadingFromJRE(libs, possibleSubdirs, pathToJRE)) {
                throw new InternalError("Unable to find plugin native libraries");
            }
        }
    }

    private static boolean tryLoadingFromJRE(String[] libs, String[] possibleSubdirs, String pathToJRE) {
        if (pathToJRE == null) {
            return false;
        }
        boolean foundAll = true;
        for (String lib : libs) {
            File f;
            boolean gotCurrent = false;
            if (lib.equalsIgnoreCase("npjp2") || lib.equalsIgnoreCase("jp2iexp")) {
                block11: {
                    try {
                        String loadedLib = Platform.get().getLoadedNativeLibPath(lib);
                        if (loadedLib != null) {
                            if (DEBUG) {
                                System.err.println("NativeLibLoader: resolving loaded " + loadedLib);
                            }
                            if ((f = new File(loadedLib)).exists() && f.canRead()) {
                                System.load(f.getAbsolutePath());
                                if (!DEBUG) continue;
                                System.err.println("   (Succeeded)");
                                continue;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (!DEBUG) break block11;
                        ex.printStackTrace();
                    }
                }
                if ((Environment.getenv((String)"FORCED_DEPLOY_ROOT") != null || Environment.getenv((String)"FORCED_JRE_ROOT") != null) && Environment.getenv((String)"FORCED_OVERRIDE_BROWSERLIB") == null) {
                    File dir = new File(System.getProperty("java.home"));
                    for (int j = 0; j < possibleSubdirs.length && !gotCurrent; ++j) {
                        gotCurrent = NativeLibLoader.tryLoading(lib, dir, possibleSubdirs[j]);
                    }
                    if (gotCurrent) continue;
                    foundAll = false;
                    continue;
                }
            }
            for (int j = 0; j < possibleSubdirs.length && !gotCurrent; ++j) {
                f = new File(pathToJRE);
                gotCurrent = NativeLibLoader.tryLoading(lib, f, possibleSubdirs[j]);
            }
            if (gotCurrent) continue;
            foundAll = false;
        }
        return foundAll;
    }

    private static String[] getPossibleSubdirs() {
        String javaHome;
        String bootLibraryPath = SystemPropertyUtil.getProperty((String)"sun.boot.library.path");
        if (!bootLibraryPath.startsWith(javaHome = Environment.getJavaHome())) {
            throw new InternalError("sun.boot.library.path (\"" + bootLibraryPath + "\") did not start with java.home (\"" + javaHome + "\")");
        }
        String bootSubdir = bootLibraryPath.substring(javaHome.length());
        if (bootSubdir.startsWith(File.separator)) {
            bootSubdir = bootSubdir.substring(1);
        }
        String bootJreSubdir = "jre" + File.separator + bootSubdir;
        String newPluginBootSubdir = bootSubdir + File.separator + "plugin2";
        String newPluginBootJreSubdir = bootJreSubdir + File.separator + "plugin2";
        return new String[]{bootSubdir, bootJreSubdir, newPluginBootSubdir, newPluginBootJreSubdir};
    }

    private static boolean tryLoading(String libName, File dir, String baseSubdir) {
        File file;
        if (dir == null) {
            return false;
        }
        File tmpDir = dir;
        if (baseSubdir != null) {
            tmpDir = new File(dir, baseSubdir);
        }
        if (!(file = new File(tmpDir, System.mapLibraryName(libName))).exists()) {
            if (DEBUG) {
                System.err.println("NativeLibLoader: " + file.getAbsolutePath() + " doesn't exist");
            }
            return false;
        }
        if (DEBUG) {
            System.err.println("NativeLibLoader: trying to load " + file.getAbsolutePath());
        }
        System.load(file.getAbsolutePath());
        if (DEBUG) {
            System.err.println("  (Succeeded)");
        }
        return true;
    }

    private static String findGrandParent(String[] strs, String str) {
        for (String str1 : strs) {
            File dir;
            if (!str1.endsWith(str) || (dir = new File(str1).getParentFile()) == null) continue;
            if ("modules".equals(dir.getName().toLowerCase())) {
                File dirParent = dir.getParentFile();
                if (dirParent == null) continue;
                return dirParent.getParent();
            }
            return dir.getParent();
        }
        return null;
    }
}

