/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet.viewer;

import com.sun.applet2.AppletParameters;
import com.sun.deploy.Environment;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.Window;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.SystemUtils;
import com.sun.javaws.Globals;
import com.sun.javaws.HtmlOptions;
import com.sun.javaws.IconUtil;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.ui.LaunchErrorDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.text.html.parser.ParserDelegator;
import sun.plugin2.applet.Applet2Environment;
import sun.plugin2.applet.Applet2Listener;
import sun.plugin2.applet.JNLP2Manager;
import sun.plugin2.applet.JNLP2Tag;
import sun.plugin2.applet.ManagerCache;
import sun.plugin2.applet.Plugin2ConsoleController;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.applet.context.InitialJNLPExecutionContext;
import sun.plugin2.applet.viewer.util.AppletTagParser;
import sun.plugin2.main.client.Applet2DragContext;
import sun.plugin2.main.client.DisconnectedExecutionContext;
import sun.plugin2.main.client.PluginCookieSelector;
import sun.plugin2.main.client.PluginMain;
import sun.plugin2.uitoolkit.DragContext;
import sun.plugin2.uitoolkit.DragListener;
import sun.plugin2.uitoolkit.PluginUIToolkit;

public class JNLP2Viewer {
    private static final boolean DEBUG = Config.getDebug();
    private boolean _isDraggedApplet;
    private boolean _isAssociation;
    private boolean _isAppletDescApplet;
    private String _jnlpFile;

    public static void main(String[] args) throws Exception {
        Environment.setEnvironmentType((int)0);
        PluginUIToolkit.initPluginToolkit();
        PluginCookieSelector.initialize();
        new JNLP2Viewer().run(args);
    }

    private void run(String[] args) throws Exception {
        JNLP2Manager manager = this.parseAndInitialize(args);
        this.start(manager);
    }

    JNLP2Manager parseAndInitialize(String[] args) throws Exception {
        AppletParameters params = new AppletParameters();
        String jnlpFile = null;
        URL documentbase = null;
        String codebase = null;
        String documentbaseArg = null;
        String associationFilename = null;
        if (args.length > 5 || args.length < 1) {
            System.out.println("Usage: JNLP2Viewer [url to HTML page containing <applet> tag with " + JNLP2Tag.JNLP_HREF + " parameter,]");
            System.out.println("                   [url to a jnlp file direct.]");
            System.out.println("Views the first applet on the specified HTML page.");
            System.exit(1);
        }
        int idx = 0;
        do {
            if (args[idx].equals("-open") || args[idx].equals("-print")) {
                this._isAssociation = true;
                associationFilename = args[++idx];
                jnlpFile = args[++idx];
                continue;
            }
            if (args[idx].equals("-codebase")) {
                this._isAppletDescApplet = true;
                codebase = args[++idx];
                continue;
            }
            if (args[idx].equals("-documentbase")) {
                this._isAppletDescApplet = true;
                documentbaseArg = args[++idx];
                continue;
            }
            if (args[idx].equals("-draggedApplet")) {
                this._isDraggedApplet = true;
                continue;
            }
            jnlpFile = args[idx];
        } while (++idx < args.length);
        if (DEBUG) {
            for (int j = 0; j < args.length; ++j) {
                System.out.println("\tJNLP2Viewer args[" + j + "] = " + args[j]);
            }
        }
        if (this._isAppletDescApplet || this._isDraggedApplet || this._isAssociation) {
            LaunchDesc ld = null;
            try {
                ld = LaunchDescFactory.buildDescriptor((File)new File(jnlpFile), (URL)new URL(codebase), null, null);
            }
            catch (Exception e2) {
                Trace.ignoredException((Exception)e2);
            }
            if (ld != null) {
                documentbase = ld.getInformation().getHome();
            }
        } else {
            block37: {
                try {
                    documentbase = new URL(jnlpFile);
                }
                catch (Exception e) {
                    if (jnlpFile.startsWith("http") || jnlpFile.startsWith("file")) break block37;
                    try {
                        documentbase = new URL("file:///" + jnlpFile);
                        jnlpFile = documentbase.toString();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            InputStream stream = documentbase.openStream();
            if (stream == null) {
                throw new RuntimeException("Error opening URL " + documentbase);
            }
            AppletTagParser finder = new AppletTagParser();
            new ParserDelegator().parse(new InputStreamReader(stream), finder, true);
            stream.close();
            if (!finder.foundApplet()) {
                if (DEBUG) {
                    System.out.println("No applet found on web page, try as JNLP direct");
                }
            } else {
                params = finder.getParameters();
                try {
                    jnlpFile = (String)params.get((Object)JNLP2Tag.JNLP_HREF);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jnlpFile == null) {
                    System.out.println("No <" + JNLP2Tag.JNLP_HREF + "> parameter given in applet tag, bail out\n");
                    System.exit(1);
                }
                try {
                    codebase = (String)params.get((Object)"java_codebase");
                    if (codebase == null) {
                        codebase = (String)params.get((Object)"codebase");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        JVMParameters jvmParams = new JVMParameters();
        jvmParams.addEncodedArguments(JnlpxArgs.getVMArgs(), true, true, false);
        JREInfo homeJre = JREInfo.getHomeJRE();
        if (homeJre != null && !homeJre.isModularJRE()) {
            jvmParams.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        }
        jvmParams.setDefault(true);
        JVMParameters.setRunningJVMParameters((JVMParameters)jvmParams);
        if (DEBUG) {
            System.out.println("Initializing Applet2Environment");
        }
        InitialJNLPExecutionContext initialContext = new InitialJNLPExecutionContext(params);
        Applet2Environment.initialize(null, true, false, new Plugin2ConsoleController(null, null), initialContext, null);
        JNLP2Manager.initializeExecutionEnvironment();
        if (this._isAppletDescApplet && documentbaseArg != null) {
            documentbase = new URL(documentbaseArg);
        }
        LocalApplicationProperties lap = null;
        ResourceObject ro = ResourceProvider.get().getResourceObject(jnlpFile);
        if (this._isDraggedApplet && ro != null && (lap = ResourceProvider.get().getLocalApplicationProperties(ro.getResourceURL(), ro.getResourceVersion(), true)) != null) {
            codebase = lap.getCodebase();
            documentbase = new URL(lap.getDocumentBase());
        }
        String cachedJNLPFilePath = null;
        if (this._isAppletDescApplet || this._isDraggedApplet || this._isAssociation) {
            cachedJNLPFilePath = jnlpFile;
            if (ro != null) {
                jnlpFile = ro.getResourceURL().toString();
            } else if (DEBUG) {
                System.err.println("Unable to obtain the CacheEntry from file " + jnlpFile + ".idx");
            }
        }
        this._jnlpFile = jnlpFile;
        if (this._isAssociation) {
            params.put((Object)"_numargs", (Object)"1");
            params.put((Object)"_arg0", (Object)associationFilename);
        }
        JNLP2Manager manager = new JNLP2Manager(new ManagerCache(), codebase, documentbase, jnlpFile, JnlpxArgs.getIsRelaunch());
        if (this._isAppletDescApplet || this._isDraggedApplet || this._isAssociation) {
            manager.setCachedJNLPFilePath(cachedJNLPFilePath);
        }
        manager.setAppletExecutionContext(new DisconnectedExecutionContext(params, documentbase.toExternalForm(), initialContext));
        return manager;
    }

    private void start(final JNLP2Manager manager) {
        LocalApplicationProperties lap = this.getLapFile();
        final boolean isDraggedApplet = lap != null ? lap.isDraggedApplet() : this._isDraggedApplet;
        final boolean isAssociation = this._isAssociation;
        final boolean isAppletDescApplet = this._isAppletDescApplet;
        final ThreadGroup mainThreadGroup = Thread.currentThread().getThreadGroup();
        AppContext appContext = manager.getAppletAppContext();
        appContext.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame appFrame;
                Window appWindow;
                int fh;
                int fw;
                try {
                    manager.initialize();
                }
                catch (Exception e) {
                    if (DEBUG) {
                        System.err.println("Error while initializing manager: " + e + ", bail out");
                    }
                    Environment.setEnvironmentType((int)1);
                    LaunchErrorDialog.show(null, (Throwable)e, (boolean)true);
                }
                AppletParameters params = manager.getAppletExecutionContext().getAppletParameters();
                final LaunchDesc launchDesc = manager.getLaunchDesc();
                Rectangle screen = UIFactory.getMouseScreenBounds();
                try {
                    fw = SystemUtils.parsePercent((String)((String)params.get((Object)"width")), (int)((int)screen.getWidth()));
                }
                catch (Exception e) {
                    fw = 512;
                }
                try {
                    fh = SystemUtils.parsePercent((String)((String)params.get((Object)"height")), (int)((int)screen.getHeight()));
                }
                catch (Exception e) {
                    fh = 512;
                }
                if (DEBUG) {
                    System.out.println("Starting applet (" + fw + "x" + fh + ") with parameters:");
                }
                if (DEBUG) {
                    params.dump();
                }
                String title = null;
                if (launchDesc != null) {
                    title = launchDesc.getInformation().getTitle();
                }
                if (title == null) {
                    title = "JNLPApplet2Viewer";
                }
                manager.setAppletSize(fw, fh);
                if (!launchDesc.isFXApp()) {
                    appWindow = ToolkitStore.getWindowFactory().createWindow();
                    appFrame = (Frame)appWindow.getWindowObject();
                    appFrame.setTitle(title);
                    boolean undecorated = manager.getUndecorated();
                    appFrame.setUndecorated(undecorated);
                    appFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            JNLP2Viewer.this.stopAndExit(mainThreadGroup, manager);
                        }
                    });
                    manager.setAppletParent(appWindow);
                    appFrame.pack();
                    Insets insets = appFrame.getInsets();
                    appFrame.setSize(fw + insets.left + insets.right, fh + insets.right + insets.top);
                    if (isAppletDescApplet) {
                        appFrame.setResizable(false);
                    }
                } else {
                    JNLP2Manager.setEmbeddedMode(false);
                    appWindow = null;
                    appFrame = null;
                }
                final Applet2DragContext dragContext = Applet2DragContext.getDragContext(manager);
                if (isDraggedApplet) {
                    PluginUIToolkit ptk = (PluginUIToolkit)ToolkitStore.get();
                    ptk.getDragHelper().register(dragContext, new DragListener(){

                        @Override
                        public void appletDraggingToDesktop(DragContext context) {
                        }

                        @Override
                        public void appletDroppedOntoDesktop(DragContext ctx) {
                        }

                        @Override
                        public void appletExternalWindowClosed(DragContext ctx) {
                            JNLP2Viewer.this.stopAndExit(mainThreadGroup, manager);
                        }
                    });
                }
                manager.addAppletListener(new Applet2Listener(){

                    @Override
                    public boolean appletSSVValidation(Plugin2Manager hostingManager) throws ExitException {
                        boolean result = PluginMain.performSSVValidation(hostingManager);
                        if (!result && hostingManager instanceof JNLP2Manager) {
                            JNLP2Manager manager = (JNLP2Manager)hostingManager;
                            manager.clearRelaunchException();
                        }
                        if (DEBUG) {
                            System.out.println("JNLP2Viewer.appletSSVValidation return: " + result);
                        }
                        return result;
                    }

                    @Override
                    public boolean isAppletRelaunchSupported() {
                        return true;
                    }

                    @Override
                    public void appletJRERelaunch(Plugin2Manager hostingManager, String javaVersion, String jvmArgs) {
                        if (DEBUG) {
                            System.out.println("JNLP2Viewer.appletJRERelaunch:");
                            System.out.println("\tjava_version   : " + javaVersion);
                            System.out.println("\tjava_arguments : " + jvmArgs);
                            System.out.println("\thostingManager : " + hostingManager);
                        }
                        if (hostingManager instanceof JNLP2Manager) {
                            File f;
                            boolean secure;
                            JNLP2Manager manager = (JNLP2Manager)hostingManager;
                            LaunchDesc ld = manager.getLaunchDesc();
                            JREMatcher jreMatcher = ld.getJREMatcher();
                            JVMParameters jvmParams = jreMatcher.getSelectedJVMParameters();
                            JREInfo jreInfo = jreMatcher.getSelectedJREInfo();
                            JREDesc jreDesc = jreMatcher.getSelectedJREDesc();
                            boolean bl = secure = (ld.getSecurityModel() == 1 || ld.getSecurityModel() == 2) && ld.isSigned();
                            if (secure) {
                                JVMParameters jvmExtASCIIParams = new JVMParameters();
                                jvmExtASCIIParams.setIncludeExtendedASCIIValues(true);
                                jvmExtASCIIParams.parse(jreDesc.getVmArgs());
                                jvmParams.addArguments(jvmExtASCIIParams);
                            }
                            String[] args = new String[3];
                            args[0] = "-codebase";
                            args[1] = manager.getCodeBase().toString();
                            URL resourceURL = ld.getCanonicalHome();
                            if (resourceURL == null && JNLP2Viewer.this._jnlpFile != null) {
                                try {
                                    resourceURL = new URL(JNLP2Viewer.this._jnlpFile);
                                }
                                catch (MalformedURLException ex) {
                                    Trace.ignored((Throwable)ex);
                                }
                            }
                            if (resourceURL != null && (f = ResourceProvider.get().getCachedJNLPFile(resourceURL, ld.getVersion())) != null) {
                                args[2] = f.getAbsolutePath();
                            }
                            if (args[2] == null) {
                                args[2] = JNLP2Viewer.this._jnlpFile;
                            }
                            try {
                                this.relaunch(jreInfo, jreDesc, ld, args, jvmParams, secure);
                            }
                            catch (Exception e) {
                                Trace.ignoredException((Exception)e);
                            }
                        }
                    }

                    private String[] insertApplicationArgs(String[] args) {
                        String[] progArgs = Globals.getApplicationArgs();
                        if (progArgs == null) {
                            return args;
                        }
                        String[] ret = new String[progArgs.length + args.length];
                        for (int i = 0; i < progArgs.length; ++i) {
                            ret[i] = progArgs[i];
                        }
                        for (int j = 0; j < args.length; ++j) {
                            ret[i++] = args[j];
                        }
                        return ret;
                    }

                    private void relaunch(JREInfo jreInfo, JREDesc jreDesc, LaunchDesc ld, String[] args, JVMParameters jvmParams, boolean secure) throws ExitException {
                        File f;
                        if (OSType.isMac()) {
                            String iconPath;
                            String utf8title;
                            String title = ld.getInformation().getTitle();
                            Charset charset = Charset.forName("UTF-8");
                            CharsetDecoder decoder = charset.newDecoder();
                            CharsetEncoder encoder = charset.newEncoder();
                            try {
                                ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(title));
                                CharBuffer cbuf = decoder.decode(bbuf);
                                utf8title = cbuf.toString();
                            }
                            catch (CharacterCodingException e) {
                                utf8title = null;
                            }
                            if (title != null) {
                                System.setProperty("macosx.jnlpx.dock.name", utf8title);
                            }
                            if ((iconPath = IconUtil.getIconPath((LaunchDesc)ld)) == null) {
                                iconPath = Platform.get().getDefaultIconPath();
                            }
                            if (iconPath != null) {
                                System.setProperty("macosx.jnlpx.dock.icon", iconPath);
                            }
                        }
                        long minHeap = jreDesc.getMinHeap();
                        long maxHeap = jreDesc.getMaxHeap();
                        HtmlOptions o = HtmlOptions.get();
                        if (o != null) {
                            try {
                                File tmpLaunchProps = File.createTempFile("zzjnl", ".tmp");
                                o.export((OutputStream)new FileOutputStream(tmpLaunchProps));
                                args = new String[]{"-nocodebase", tmpLaunchProps.getAbsolutePath()};
                            }
                            catch (IOException ioe) {
                                throw new ExitException("Failed to relaunch. Can not save launch file.", (Throwable)ioe);
                            }
                        }
                        if ((f = SessionState.save()) != null) {
                            System.setProperty("jnlpx.session.data", f.getAbsolutePath());
                        }
                        try {
                            args = this.insertApplicationArgs(args);
                            JnlpxArgs.execProgram((JREInfo)jreInfo, (String[])args, (long)minHeap, (long)maxHeap, (JVMParameters)jvmParams, (boolean)secure, (boolean)ld.isFXApp(), (boolean)ld.needFX());
                        }
                        catch (IOException ioe) {
                            if (DEBUG) {
                                System.err.println("Caught exception trying to relaunch: " + ioe);
                            }
                            throw new ExitException((Throwable)new JreExecException(jreInfo.getPath(), (Exception)ioe), 3);
                        }
                        if (JnlpxArgs.shouldRemoveArgumentFile()) {
                            JnlpxArgs.setShouldRemoveArgumentFile((String)String.valueOf(false));
                        }
                        if (Platform.get().getRunInNativeSandbox()) {
                            Platform.get().waitForNativeSandboxProcess();
                            Platform.get().setRunInNativeSandbox(false);
                            JNLP2Viewer.this.stopAndExit(mainThreadGroup, manager);
                            PluginMain.sureExit(0);
                        } else {
                            JNLP2Viewer.this.stopAndExit(mainThreadGroup, manager);
                        }
                    }

                    @Override
                    public void appletLoaded(Plugin2Manager hostingManager) {
                    }

                    @Override
                    public void appletReady(Plugin2Manager hostingManager) {
                        if (isAssociation && SingleInstanceManager.isServerRunning((String)launchDesc.getCanonicalHome().toString())) {
                            SingleInstanceManager.connectToServer((String)launchDesc.toString());
                        }
                        if (appFrame != null) {
                            appFrame.setVisible(true);
                        }
                        if (isDraggedApplet) {
                            PluginUIToolkit ptk = (PluginUIToolkit)ToolkitStore.get();
                            ptk.getDragHelper().makeDisconnected(dragContext, appWindow);
                        }
                    }

                    @Override
                    public void appletErrorOccurred(Plugin2Manager hostingManager) {
                    }

                    @Override
                    public String getBestJREVersion(Plugin2Manager hostingManager, String javaVersionStr, String jfxVersionStr) {
                        return null;
                    }
                });
                manager.start();
            }
        });
    }

    private void stopAndExit(final ThreadGroup group, final Plugin2Manager manager) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread t = SafeThreadFactory.createThread((ThreadGroup)group, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        manager.stop(null, null);
                        Trace.flush();
                        System.exit(0);
                    }
                }, (String)"Manager Exit Thread");
                t.setDaemon(true);
                t.start();
                return null;
            }
        });
    }

    private LocalApplicationProperties getLapFile() {
        LocalApplicationProperties lap = null;
        try {
            URL jnlpURL = new URL(this._jnlpFile);
            lap = ResourceProvider.get().getLocalApplicationProperties(jnlpURL, null, true);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (lap == null) {
            lap = Cache.getLocalApplicationProperties((String)this._jnlpFile);
        }
        return lap;
    }
}

