/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class XMLEncoding {
    private static final int BOM_LENGTH = 4;
    private static final int MAX_ENC_NAME = 512;
    private static final int SPACE = 32;
    private static final int TAB = 9;
    private static final int LINEFEED = 10;
    private static final int RETURN = 13;
    private static final int EQUAL = 61;
    private static final int DOUBLE_QUOTE = 34;
    private static final int SINGLE_QUOTE = 39;
    private static final int UTF_32_BE_BOM = 65279;
    private static final int UTF_32_LE_BOM = -131072;
    private static final int UTF_16_BE_BOM = -16842752;
    private static final int UTF_16_LE_BOM = -131072;
    private static final int UTF_8_BOM = -272908544;
    private static final int UNUSUAL_OCTET_1 = 15360;
    private static final int UNUSUAL_OCTET_2 = 0x3C0000;
    private static final int UTF_16BE = 3932223;
    private static final int UTF_16LE = 1006649088;
    private static final int EBCDIC = 1282385812;
    private static final int XML_DECLARATION = 1010792557;
    private static final String UTF_32_ENC = "UTF-32";
    private static final String UTF_16_ENC = "UTF-16";
    private static final String UTF_16BE_ENC = "UTF-16BE";
    private static final String UTF_16LE_ENC = "UTF-16LE";
    private static final String UTF_8_ENC = "UTF-8";
    private static final String IBM037_ENC = "IBM037";
    private static final String XML_DECL_START = "<?xml";
    private static final String ENCODING_DECL = "encoding";

    public static String decodeXML(byte[] data) throws IOException {
        int start = 0;
        String encoding = null;
        if (data.length < 4) {
            throw new EOFException(ResourceManager.getString("encoding.error.not.xml"));
        }
        int firstFour = 0xFF000000 & data[0] << 24 | 0xFF0000 & data[1] << 16 | 0xFF00 & data[2] << 8 | 0xFF & data[3];
        block0 : switch (firstFour) {
            case 1282385812: {
                encoding = XMLEncoding.examineEncodingDeclaration(data, IBM037_ENC);
                break;
            }
            case 1010792557: {
                encoding = XMLEncoding.examineEncodingDeclaration(data, UTF_8_ENC);
                break;
            }
            case 3932223: {
                encoding = UTF_16BE_ENC;
                Trace.println("Detected UTF-16BE encoding from first four bytes", TraceLevel.BASIC);
                break;
            }
            case 1006649088: {
                encoding = UTF_16LE_ENC;
                Trace.println("Detected UTF-16LE encoding from first four bytes", TraceLevel.BASIC);
                break;
            }
            case 15360: 
            case 0x3C0000: {
                throw new UnsupportedEncodingException(ResourceManager.getString("encoding.error.unusual.octet"));
            }
            case -131072: 
            case 65279: {
                encoding = UTF_32_ENC;
                break;
            }
            default: {
                int firstThree = firstFour & 0xFFFFFF00;
                switch (firstThree) {
                    case -272908544: {
                        start = 3;
                        encoding = UTF_8_ENC;
                        break block0;
                    }
                }
                int firstTwo = firstFour & 0xFFFF0000;
                switch (firstTwo) {
                    case -16842752: 
                    case -131072: {
                        encoding = UTF_16_ENC;
                        break block0;
                    }
                }
                encoding = UTF_8_ENC;
            }
        }
        return new String(data, start, data.length - start, encoding);
    }

    private static String examineEncodingDeclaration(byte[] data, String encoding) throws IOException {
        boolean loop = false;
        boolean recognized = false;
        boolean almost = false;
        boolean question = false;
        boolean done = false;
        boolean found = false;
        int pos = 0;
        int ch = -1;
        InputStreamReader reader = null;
        String result = encoding != null ? encoding : UTF_8_ENC;
        reader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), result);
        ch = ((Reader)reader).read();
        for (int i = 0; i < XML_DECL_START.length() && !done; ++i) {
            if (ch != XML_DECL_START.charAt(i)) {
                done = true;
                break;
            }
            ch = ((Reader)reader).read();
        }
        loop = true;
        block10: while (loop && !done) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ch = ((Reader)reader).read();
                    continue block10;
                }
                case -1: {
                    done = true;
                    continue block10;
                }
            }
            loop = false;
        }
        loop = true;
        while (loop && !done) {
            if (ch == -1) {
                done = true;
                break;
            }
            if (recognized) {
                switch (ch) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    case 61: {
                        if (!almost) {
                            almost = true;
                            break;
                        }
                        recognized = false;
                        done = true;
                        break;
                    }
                    case 34: 
                    case 39: {
                        if (almost) {
                            loop = false;
                            break;
                        }
                        recognized = false;
                        done = true;
                        break;
                    }
                    default: {
                        recognized = false;
                        if (!almost) break;
                        done = true;
                    }
                }
                if (!recognized) {
                    pos = 0;
                    continue;
                }
            } else if (ch == ENCODING_DECL.charAt(pos++)) {
                if (ENCODING_DECL.length() == pos) {
                    recognized = true;
                }
            } else if (ch == 63) {
                question = true;
                pos = 0;
            } else {
                if (ch == 62 && question) {
                    done = true;
                    continue;
                }
                pos = 0;
            }
            ch = ((Reader)reader).read();
        }
        if (!done) {
            StringBuffer buffer = new StringBuffer(512);
            if ((ch >= 97 && ch <= 122) | (ch >= 65 && ch <= 90)) {
                buffer.append((char)ch);
                loop = true;
                while (loop && !done) {
                    ch = ((Reader)reader).read();
                    if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 95 || ch == 46 || ch == 45) {
                        buffer.append((char)ch);
                        continue;
                    }
                    if (ch == 34 || ch == 39) {
                        found = true;
                        done = true;
                        result = buffer.toString();
                        continue;
                    }
                    done = true;
                }
            } else {
                done = true;
            }
        }
        return result;
    }
}

