/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.util.VersionID;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class VersionString {
    private ArrayList<VersionID> _versionIds = new ArrayList();

    public VersionString(String vs) {
        if (vs != null) {
            StringTokenizer st = new StringTokenizer(vs, " ", false);
            while (st.hasMoreElements()) {
                this._versionIds.add(new VersionID(st.nextToken()));
            }
        }
    }

    public VersionString(VersionID id) {
        if (id != null) {
            this._versionIds.add(id);
        }
    }

    public boolean isSimpleVersion() {
        if (this._versionIds.size() == 1) {
            return this._versionIds.get(0).isSimpleVersion();
        }
        return false;
    }

    public boolean contains(VersionID m) {
        for (int i = 0; i < this._versionIds.size(); ++i) {
            VersionID vi = this._versionIds.get(i);
            boolean check = vi.match(m);
            if (!check) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String versionid) {
        return this.contains(new VersionID(versionid));
    }

    public boolean containsGreaterThan(VersionID m) {
        for (int i = 0; i < this._versionIds.size(); ++i) {
            VersionID vi = this._versionIds.get(i);
            boolean check = vi.isGreaterThan(m);
            if (!check) continue;
            return true;
        }
        return false;
    }

    public boolean containsGreaterThan(String versionid) {
        return this.containsGreaterThan(new VersionID(versionid));
    }

    public static boolean contains(String vs, String vi) {
        return new VersionString(vs).contains(vi);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._versionIds.size(); ++i) {
            sb.append(this._versionIds.get(i).toString());
            sb.append(' ');
        }
        return sb.toString();
    }

    public List<VersionID> getAllVersionIDs() {
        return this._versionIds;
    }
}

