/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public class GeneralUtil {
    public static boolean prefixMatch(String prefix, String target) {
        if (prefix == null) {
            return true;
        }
        if (target == null) {
            return false;
        }
        return target.startsWith(prefix);
    }

    public static boolean prefixMatchStringList(String[] prefixList, String target) {
        if (prefixList == null) {
            return true;
        }
        if (target == null) {
            return false;
        }
        for (int i = 0; i < prefixList.length; ++i) {
            if (!target.startsWith(prefixList[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean prefixMatchArch(String[] prefixList) {
        if (prefixList == null) {
            return true;
        }
        String arch = Config.getOSArch();
        for (int i = 0; i < prefixList.length; ++i) {
            if (!arch.startsWith(prefixList[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] getStringList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int length = str.length();
        StringBuffer sb = null;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                if (sb == null) continue;
                list.add(sb.toString());
                sb = null;
                continue;
            }
            if (ch == '\\') {
                if (i + 1 >= length) continue;
                ch = str.charAt(++i);
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(ch);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(ch);
        }
        if (sb != null) {
            list.add(sb.toString());
        }
        if (list.isEmpty()) {
            return null;
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    public static boolean matchLocale(String[] localeList, Locale locale) {
        if (localeList == null) {
            return true;
        }
        for (String localeList1 : localeList) {
            if (!GeneralUtil.matchLocale(localeList1, locale)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchLocale(String localeStr, Locale locale) {
        if (localeStr == null || localeStr.length() == 0) {
            return true;
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer st = new StringTokenizer(localeStr, "_", false);
        if (st.hasMoreElements() && locale.getLanguage().length() > 0 && !(language = st.nextToken()).equalsIgnoreCase(locale.getLanguage())) {
            return false;
        }
        if (st.hasMoreElements() && locale.getCountry().length() > 0 && !(country = st.nextToken()).equalsIgnoreCase(locale.getCountry())) {
            return false;
        }
        return !st.hasMoreElements() || locale.getVariant().length() <= 0 || (variant = st.nextToken()).equalsIgnoreCase(locale.getVariant());
    }

    public static long heapValToLong(String heapValue) {
        if (heapValue == null) {
            return -1L;
        }
        long multiplier = 1L;
        if (heapValue.toLowerCase().lastIndexOf(109) != -1) {
            multiplier = 0x100000L;
            heapValue = heapValue.substring(0, heapValue.length() - 1);
        } else if (heapValue.toLowerCase().lastIndexOf(107) != -1) {
            multiplier = 1024L;
            heapValue = heapValue.substring(0, heapValue.length() - 1);
        }
        long theValue = -1L;
        try {
            theValue = Long.parseLong(heapValue);
            theValue *= multiplier;
        }
        catch (NumberFormatException e) {
            theValue = -1L;
        }
        return theValue;
    }

    public static Frame getActiveTopLevelFrame() {
        Frame[] frames = Frame.getFrames();
        int index = -1;
        if (frames == null) {
            return null;
        }
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].getFocusOwner() == null) continue;
            index = i;
        }
        return index >= 0 ? frames[index] : null;
    }
}

