/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.security.util.BitArray;

public final class BlackList {
    private static BlackList INSTANCE = null;
    private static final String DIGEST_MANIFEST = "-DIGEST-MANIFEST";
    private static final String CACHE_VERSION = "v2";
    private static final int BITLEN = 65536;
    private static final int WORDLEN = 2;
    private static final int NEED_CREATE = 0;
    private static final int NEED_LOAD = 1;
    private static final int IN_MEMORY = 2;
    private static final String[] stateStrings = new String[]{"NEED_CREATE", "NEED_LOAD", "IN_MEMORY"};
    private List<File> rawBlacklistFiles;
    private Cache cachedBlacklistFile;
    private SmartBitArray cache;
    private long lastModified;
    private boolean isEmpty;
    private int state;

    private static BlackList createDefaultInstance() {
        BlackList bl = null;
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.enabled");
            bl = new BlackList(false);
        }
        if (bl == null) {
            bl = new BlackList(true);
        }
        return bl;
    }

    public static synchronized BlackList getInstance() {
        if (INSTANCE == null) {
            INSTANCE = BlackList.createDefaultInstance();
        }
        return INSTANCE;
    }

    static String getCachePath() {
        return BlackList.getInstance().cachedBlacklistFile.file.getPath();
    }

    private BlackList(boolean isEmpty) {
        this.isEmpty = isEmpty;
        if (isEmpty) {
            this.lastModified = 0L;
        } else {
            String _dynamicBlacklistFilename = Config.getDynamicBlacklistFile();
            String _systemBlacklistFilename = Config.getSystemBlacklistFile();
            String _userBlacklistFilename = Config.getUserBlacklistFile();
            this.rawBlacklistFiles = new ArrayList<File>();
            this.rawBlacklistFiles.add(new File(_dynamicBlacklistFilename));
            this.rawBlacklistFiles.add(new File(_systemBlacklistFilename));
            this.rawBlacklistFiles.add(new File(_userBlacklistFilename));
            StringBuilder sb = new StringBuilder();
            sb.append(CACHE_VERSION).append('|');
            Iterator<File> itor = this.rawBlacklistFiles.iterator();
            boolean rawFound = false;
            while (itor.hasNext()) {
                File f = itor.next();
                sb.append(f.getPath()).append('|');
                long lm = f.lastModified();
                if (lm != 0L) {
                    rawFound = true;
                }
                sb.append(lm).append('|');
            }
            if (!rawFound) {
                this.isEmpty = true;
                this.lastModified = 0L;
                Trace.println("blacklist: no raw file", TraceLevel.SECURITY);
                return;
            }
            this.cachedBlacklistFile = new Cache(sb.toString().hashCode());
            if (this.cachedBlacklistFile.exists()) {
                this.state = 1;
                this.lastModified = this.cachedBlacklistFile.lastModified();
            } else {
                this.state = 0;
                this.lastModified = new Date().getTime();
            }
        }
        Trace.println("blacklist: created: " + stateStrings[this.state] + ", lastModified: " + this.lastModified, TraceLevel.SECURITY);
    }

    public synchronized boolean contains(String attribute, String hash) {
        if (this.isEmpty) {
            return false;
        }
        Trace.println("blacklist: check contains " + hash + ", state now " + stateStrings[this.state], TraceLevel.SECURITY);
        if (this.state == 0) {
            return this.checkInRaw(attribute, hash, true);
        }
        try {
            if (this.state == 1) {
                this.cache = this.cachedBlacklistFile.loadCache();
                this.state = 2;
            }
        }
        catch (IOException ioe) {
            return this.checkInRaw(attribute, hash, true);
        }
        boolean found = this.checkInCache(hash);
        Trace.println("blacklist: " + (found ? "" : "not ") + " found in cache", TraceLevel.SECURITY);
        if (found) {
            return this.checkInRaw(attribute, hash, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateCache() {
        BlackList bl = BlackList.getInstance();
        if (bl.state == 0) {
            BlackList blackList = bl;
            synchronized (blackList) {
                bl.checkInRaw(null, null, true);
            }
            return true;
        }
        return false;
    }

    private boolean checkInCache(String hash) {
        byte[] data = BlackList.debase64(hash);
        if (data.length == 0) {
            return false;
        }
        int i = 0;
        while (i + 2 <= data.length) {
            int pos = 0;
            for (int j = 0; j < 2; ++j) {
                pos <<= 8;
                pos |= data[i + j] & 0xFF;
            }
            if (!this.cache.get(pos)) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private boolean checkInRaw(String attr, String hash, boolean createCache) {
        if (createCache) {
            this.cache = new SmartBitArray(65536);
        }
        Iterator<File> itor = this.rawBlacklistFiles.iterator();
        boolean found = false;
        while (itor.hasNext()) {
            File f = itor.next();
            if (found) {
                this.checkInOneRaw(f, null, null, true);
                Trace.println("blacklist: read raw " + f, TraceLevel.SECURITY);
            } else {
                found = this.checkInOneRaw(f, attr, hash, createCache);
                Trace.println("blacklist: check raw " + f + ", " + found, TraceLevel.SECURITY);
            }
            if (!found || createCache) continue;
            return true;
        }
        if (createCache) {
            this.saveCache();
        }
        return found;
    }

    private void saveCache() {
        if (this.cache.isEmpty()) {
            this.isEmpty = true;
            Trace.println("blacklist: raw files are all empty", TraceLevel.SECURITY);
            this.cachedBlacklistFile.delete();
        } else {
            this.cachedBlacklistFile.save(this.cache);
        }
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInOneRaw(final File file, String attr, String hash, boolean createCache) {
        boolean found;
        block27: {
            if (!file.exists()) {
                return false;
            }
            BufferedReader r = null;
            found = false;
            try {
                String word;
                FileInputStream fis = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws Exception {
                        return new FileInputStream(file);
                    }
                });
                r = new BufferedReader(new InputStreamReader(fis));
                StreamTokenizer st = new StreamTokenizer(r);
                this.setupTokenizer(st);
                while (true) {
                    int token;
                    if ((token = st.nextToken()) == -1) {
                        break block27;
                    }
                    if (token == 10) continue;
                    if (token != -3) {
                        throw new IOException("Unexpected token: " + st);
                    }
                    word = st.sval;
                    if (!word.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST)) break;
                    String attribute = st.sval;
                    this.parseColon(st);
                    st.wordChars(61, 61);
                    token = st.nextToken();
                    if (token != -3) {
                        throw new IOException("Unexpected value: " + st);
                    }
                    st.ordinaryChar(61);
                    String h = st.sval;
                    if (h == null) {
                        throw new IOException("hash must be specified");
                    }
                    if (h.equals(hash) && attribute.equalsIgnoreCase(attr)) {
                        found = true;
                        if (!createCache) {
                            boolean bl = found;
                            return bl;
                        }
                    }
                    if (!createCache) continue;
                    this.encode(h);
                }
                throw new IOException("Unknown attribute `" + word + "', line " + st.lineno());
            }
            catch (PrivilegedActionException pae) {
                Trace.println("blacklist: PrivilegedActionException: " + pae, TraceLevel.SECURITY);
            }
            catch (IOException ioe) {
                Trace.println("blacklist: " + ioe, TraceLevel.SECURITY);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException ioe) {
                        Trace.println("blacklist: Cannot close reader for " + file, TraceLevel.SECURITY);
                    }
                }
            }
        }
        return found;
    }

    private void encode(String hash) {
        byte[] data = BlackList.debase64(hash);
        int i = 0;
        while (i + 2 <= data.length) {
            int pos = 0;
            for (int j = 0; j < 2; ++j) {
                pos <<= 8;
                pos |= data[i + j] & 0xFF;
            }
            this.cache.set(pos, true);
            i += 2;
        }
    }

    private static byte[] debase64(String s) {
        try {
            return Base64Wrapper.decodeFromString(s);
        }
        catch (IOException ioe) {
            Trace.println("blacklist: Cannot decode " + s, TraceLevel.SECURITY);
            return new byte[0];
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private void setupTokenizer(StreamTokenizer st) {
        st.resetSyntax();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(95, 95);
        st.wordChars(43, 43);
        st.wordChars(47, 47);
        st.whitespaceChars(0, 32);
        st.commentChar(35);
        st.eolIsSignificant(true);
    }

    private void parseColon(StreamTokenizer st) throws IOException {
        int token = st.nextToken();
        if (token != 58) {
            throw new IOException("Expected ':', read " + st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes readAttributes(JarFile f, JarEntry e) throws IOException {
        if (f.getJarEntry(e.getName()) == null) {
            return null;
        }
        final InputStream is = f.getInputStream(e);
        if (is == null) {
            return null;
        }
        try {
            Attributes attributes = AccessController.doPrivileged(new PrivilegedExceptionAction<Attributes>(){

                @Override
                public Attributes run() throws Exception {
                    Manifest mf = new Manifest(is);
                    return mf.getMainAttributes();
                }
            });
            return attributes;
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        finally {
            is.close();
        }
        return null;
    }

    public boolean checkJarEntry(JarFile jar, JarEntry entry) throws IOException, GeneralSecurityException {
        if (this.isEmpty() || entry == null) {
            return true;
        }
        if (!entry.getName().toUpperCase(Locale.ENGLISH).endsWith(".SF")) {
            return false;
        }
        Attributes mainAttrs = BlackList.readAttributes(jar, entry);
        if (mainAttrs == null) {
            return false;
        }
        Iterator<Object> iterAttr = mainAttrs.keySet().iterator();
        while (iterAttr.hasNext()) {
            Attributes.Name sha1AttrName;
            String hash;
            String key = iterAttr.next().toString();
            if (!key.toUpperCase(Locale.ENGLISH).endsWith(DIGEST_MANIFEST) || !INSTANCE.contains(key, hash = mainAttrs.getValue(sha1AttrName = new Attributes.Name(key)))) continue;
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.found", new Object[]{jar.getName()});
            throw new GeneralSecurityException("blacklisted entry!");
        }
        Trace.msgSecurityPrintln("downloadengine.check.blacklist.notfound");
        return false;
    }

    public boolean checkJarFile(JarFile jar) throws IOException {
        if (this.isEmpty()) {
            Trace.msgSecurityPrintln("downloadengine.check.blacklist.notexist");
            return false;
        }
        List<Object> digests = BlackList.getManifestDigests(jar);
        if (digests != null && digests.size() > 0) {
            try {
                Iterator<Object> itor = digests.iterator();
                while (itor.hasNext()) {
                    String hash;
                    String key = (String)itor.next();
                    if (!INSTANCE.contains(key, hash = (String)itor.next())) continue;
                    Trace.msgSecurityPrintln("downloadengine.check.blacklist.found", new Object[]{jar.getName()});
                    return true;
                }
                return false;
            }
            catch (NoSuchElementException itor) {
                // empty catch block
            }
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String uname = entry.getName().toUpperCase(Locale.ENGLISH);
            if (!uname.startsWith("META-INF/") && !uname.startsWith("/META-INF/")) continue;
            try {
                if (!this.checkJarEntry(jar, entry)) continue;
                return false;
            }
            catch (GeneralSecurityException ge) {
                return true;
            }
        }
        Trace.msgSecurityPrintln("downloadengine.check.blacklist.notsigned");
        return false;
    }

    public boolean hasBeenModifiedSince(long tm) {
        Trace.println("blacklist: hasBeenModifiedSince " + tm + " (we have " + this.lastModified + ")", TraceLevel.SECURITY);
        return this.lastModified >= tm;
    }

    private static List<Object> getManifestDigests(JarFile jar) {
        try {
            DeployJavaUtilJarAccess access = DeployJavaUtilJarAccess.instance();
            return access.getManifestDigests(jar);
        }
        catch (NoSuchMethodError e) {
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
    }

    private static class Cache {
        File file = new File(Config.getSecurityCacheDir(), "blacklist.cache");
        int signature;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Cache(int signature) {
            this.signature = signature;
            FileInputStream ins = null;
            boolean isOld = false;
            try {
                ins = new FileInputStream(this.file);
                if (new DataInputStream(ins).readInt() != signature) {
                    isOld = true;
                }
            }
            catch (IOException ioe) {
                isOld = true;
            }
            finally {
                try {
                    if (ins != null) {
                        ins.close();
                    }
                }
                catch (IOException e) {
                    Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                }
            }
            if (isOld) {
                Trace.println("blacklist: Reconstruct cache", TraceLevel.SECURITY);
                this.file.delete();
            }
        }

        long lastModified() {
            return this.file.lastModified();
        }

        boolean exists() {
            return this.file.exists();
        }

        void delete() {
            this.file.delete();
        }

        SmartBitArray loadCache() throws IOException {
            Trace.println("blacklist: loadCache", TraceLevel.SECURITY);
            byte[] data = new byte[8192];
            try (FileInputStream fin = null;){
                fin = new FileInputStream(this.file);
                fin.read(data, 0, 4);
                fin.read(data);
            }
            return new SmartBitArray(65536, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(SmartBitArray cache) {
            Trace.println("blacklist: save cache to " + this.file, TraceLevel.SECURITY);
            FileOutputStream fout = null;
            try {
                new File(Config.getSecurityCacheDir()).mkdir();
                fout = new FileOutputStream(this.file);
                new DataOutputStream(fout).writeInt(this.signature);
                fout.write(cache.toByteArray());
            }
            catch (IOException ioe) {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e2) {
                        Trace.println("blacklist: Cannot close " + this.file, TraceLevel.SECURITY);
                    }
                    fout = null;
                }
                this.file.delete();
                Trace.println("blacklist: Cannot save cache", TraceLevel.SECURITY);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class SmartBitArray
    extends BitArray {
        private boolean isEmpty = true;

        SmartBitArray(int len) {
            super(len);
        }

        SmartBitArray(int len, byte[] data) {
            super(len, data);
            this.isEmpty = false;
        }

        @Override
        public void set(int i, boolean bln) throws ArrayIndexOutOfBoundsException {
            super.set(i, bln);
            this.isEmpty = false;
        }

        boolean isEmpty() {
            return this.isEmpty;
        }
    }
}

