/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import java.util.Enumeration;
import java.util.TreeSet;

public final class ConsoleHelper {
    public static void dumpAllStacks(ConsoleController controller) {
        if (!controller.isDumpStackSupported()) {
            return;
        }
        Trace.println(ConsoleHelper.dumpAllStacksImpl());
    }

    private static native String dumpAllStacksImpl();

    public static void dumpThreadGroup(ThreadGroup tg) {
        if (tg != null) {
            try {
                if (tg.activeCount() == 0 && tg.activeGroupCount() == 0 && !tg.isDestroyed()) {
                    tg.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Group ").append(tg.getName());
            sb.append(",ac=").append(tg.activeCount());
            sb.append(",agc=").append(tg.activeGroupCount());
            sb.append(",pri=").append(tg.getMaxPriority());
            if (tg.isDestroyed()) {
                sb.append(",destoyed");
            }
            if (tg.isDaemon()) {
                sb.append(",daemon");
            }
            Trace.println(sb.toString());
            Thread[] tt = new Thread[1000];
            tg.enumerate(tt, false);
            for (int i = 0; i < tt.length; ++i) {
                if (tt[i] == null) continue;
                sb = new StringBuffer();
                sb.append("    ");
                sb.append(tt[i].getName());
                sb.append(",");
                sb.append(tt[i].getPriority());
                if (tt[i].isAlive()) {
                    sb.append(",alive");
                } else {
                    sb.append(",not alive");
                }
                if (tt[i].isDaemon()) {
                    sb.append(",daemon");
                }
                if (tt[i].isInterrupted()) {
                    sb.append(",interrupted");
                }
                Trace.println(sb.toString());
            }
            ThreadGroup[] tgArray = new ThreadGroup[1000];
            tg.enumerate(tgArray, false);
            for (int i = 0; i < tgArray.length; ++i) {
                if (tgArray[i] == null) continue;
                ConsoleHelper.dumpThreadGroup(tgArray[i]);
            }
        }
    }

    public static void displayHelp(ConsoleController controller, ConsoleWindow console) {
        console.append(ResourceManager.getString("console.menu.text.top"));
        console.append(ResourceManager.getString("console.menu.text.c"));
        console.append(ResourceManager.getString("console.menu.text.f"));
        console.append(ResourceManager.getString("console.menu.text.g"));
        console.append(ResourceManager.getString("console.menu.text.h"));
        if (controller.isDumpClassLoaderSupported()) {
            console.append(ResourceManager.getString("console.menu.text.l"));
        }
        console.append(ResourceManager.getString("console.menu.text.m"));
        if (controller.isLoggingSupported()) {
            console.append(ResourceManager.getString("console.menu.text.o"));
        }
        if (controller.isProxyConfigReloadSupported()) {
            console.append(ResourceManager.getString("console.menu.text.p"));
        }
        console.append(ResourceManager.getString("console.menu.text.q"));
        if (controller.isSecurityPolicyReloadSupported()) {
            console.append(ResourceManager.getString("console.menu.text.r"));
        }
        console.append(ResourceManager.getString("console.menu.text.s"));
        console.append(ResourceManager.getString("console.menu.text.t"));
        if (controller.isDumpStackSupported()) {
            console.append(ResourceManager.getString("console.menu.text.v"));
        }
        if (controller.isClearClassLoaderSupported()) {
            console.append(ResourceManager.getString("console.menu.text.x"));
        }
        console.append(ResourceManager.getString("console.menu.text.0"));
        console.append(ResourceManager.getString("console.menu.text.tail"));
    }

    public static void displayVersion(ConsoleController controller, ConsoleWindow console) {
        console.append(Trace.getIntro());
    }

    public static void displaySystemProperties() {
        String value;
        TreeSet<String> keys = new TreeSet<String>();
        Config config = Config.get();
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (config.containsKey(key)) continue;
            keys.add(key);
        }
        Trace.print(ResourceManager.getString("console.dump.system.properties"));
        Trace.print(ResourceManager.getString("console.menu.text.top"));
        for (String key : keys) {
            value = System.getProperty(key);
            if (value != null) {
                if (value.equals("\n")) {
                    value = "\\n";
                } else if (value.equals("\r")) {
                    value = "\\r";
                } else if (value.equals("\r\n")) {
                    value = "\\r\\n";
                } else if (value.equals("\n\r")) {
                    value = "\\n\\r";
                } else if (value.equals("\n\n")) {
                    value = "\\n\\n";
                } else if (value.equals("\r\r")) {
                    value = "\\r\\r";
                }
            }
            Trace.println(key + " = " + value);
        }
        Trace.print(ResourceManager.getString("console.menu.text.tail"));
        keys.clear();
        e = config.propertyNames();
        while (e.hasMoreElements()) {
            keys.add((String)e.nextElement());
        }
        Trace.print(ResourceManager.getString("console.dump.deployment.properties"));
        Trace.print(ResourceManager.getString("console.menu.text.top"));
        for (String key : keys) {
            value = Config.getStringProperty(key);
            if (value != null) {
                if (value.equals("\n")) {
                    value = "\\n";
                } else if (value.equals("\r")) {
                    value = "\\r";
                } else if (value.equals("\r\n")) {
                    value = "\\r\\n";
                } else if (value.equals("\n\r")) {
                    value = "\\n\\r";
                } else if (value.equals("\n\n")) {
                    value = "\\n\\n";
                } else if (value.equals("\r\r")) {
                    value = "\\r\\r";
                }
            }
            Trace.println(key + " = " + value);
        }
        Trace.print(ResourceManager.getString("console.menu.text.tail"));
        Trace.print(ResourceManager.getString("console.done"));
    }

    public static void setTraceLevel(int level) {
        Trace.setEnabled(TraceLevel.BASIC, level >= 1);
        Trace.setEnabled(TraceLevel.CACHE, level >= 2);
        Trace.setEnabled(TraceLevel.NETWORK, level >= 3);
        Trace.setEnabled(TraceLevel.SECURITY, level >= 3);
        Trace.setEnabled(TraceLevel.LIVECONNECT, level >= 5);
        Trace.setEnabled(TraceLevel.TEMP, level >= 5);
        Trace.setEnabled(TraceLevel.UI, level >= 5);
        Trace.setEnabled(TraceLevel.PRELOADER, level >= 5);
        Trace.setEnabled(TraceLevel.RULESET, level >= 5);
        Trace.print(ResourceManager.getString("console.trace.level." + Integer.toString(level)));
    }
}

