/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AboutDialog;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.ProgressDialog;
import com.sun.deploy.ui.SSV3DialogContent;
import com.sun.deploy.uitoolkit.ui.DialogHook;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.SystemUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.SwingUtilities;

public class UIFactory {
    public static final int ERROR = -1;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int ALWAYS = 2;
    public static final int ASK_ME_LATER = 3;
    public static final int OK_OLD_JRE = 0;
    public static final int OK_LATEST_JRE = 2;
    private static long tsLastActive = 0L;
    private static DialogListener dialogListener = null;
    private static DialogHook dialogHook;
    private static int visibleDialogs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showSecurityDialog(final AppInfo ainfo, final String title, final String topText, final String publisher, final URL appFrom, final boolean showAlways, final boolean checkAlways, final String okBtnStr, final String cancelBtnStr, final String[] securityAlerts, final String[] securityInfo, final boolean showMoreInfo, final Certificate[] certs, final int start, final int end, final boolean majorWarning, final boolean httpsDialog, final boolean sandboxApp, final boolean selfSigned) {
        final Component parent = UIFactory.beforeDialog(null);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    String[] info = new String[]{};
                    if (securityInfo != null) {
                        info = securityInfo;
                    }
                    int securityInfoCount = info.length;
                    info = UIFactory.addDetail(info, ainfo, true, true);
                    ainfo.setVendor(publisher);
                    ainfo.setFrom(appFrom);
                    DialogTemplate template = new DialogTemplate(ainfo, parent, title, topText);
                    String acceptTitle = "";
                    String acceptText = "";
                    if (majorWarning && !httpsDialog) {
                        acceptTitle = ResourceManager.getString("security.dialog.accept.title");
                        acceptText = ResourceManager.getString("security.dialog.accept.text");
                    }
                    template.setNewSecurityContent(showAlways, checkAlways, okBtnStr, cancelBtnStr, securityAlerts, info, securityInfoCount, showMoreInfo, certs, start, end, majorWarning, acceptTitle, acceptText, httpsDialog, sandboxApp, selfSigned);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showIntegrationDialog(Component owner, final AppInfo ainfo) {
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    String title = ResourceManager.getString("integration.title");
                    boolean doShortcut = ainfo.getDesktopHint() || ainfo.getMenuHint();
                    boolean doAssociation = ainfo.getAssociations() != null && ainfo.getAssociations().length > 0;
                    String key = "integration.text.shortcut";
                    if (doAssociation) {
                        key = doShortcut ? "integration.text.both" : "integration.text.association";
                    }
                    String topText = ResourceManager.getString(key);
                    String[] security = new String[]{};
                    String[] alerts = new String[]{};
                    alerts = UIFactory.addDetail(alerts, ainfo, false, true);
                    String[] info = new String[]{};
                    boolean showMoreInfo = alerts.length + (info = UIFactory.addDetail(info, ainfo, true, false)).length > 1;
                    String okBtnStr = ResourceManager.getString("common.ok_btn");
                    String cancelBtnStr = ResourceManager.getString("integration.skip.button");
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, topText);
                    template.setSecurityContent(false, false, okBtnStr, cancelBtnStr, alerts, info, 0, showMoreInfo, null, 0, 0, false);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showErrorDialog(Component owner, final AppInfo ainfo, final String title, final String masthead, final String message, final String okBtnStr, final String detailBtnStr, final Throwable throwable, final String detailString, final Certificate[] certs) {
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    template.setErrorContent(message, okBtnStr, detailBtnStr, throwable, detailString, certs, false);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showPublisherInfo(Component owner, final AppInfo ainfo, final String title, final String masthead, final String message, final String okBtnStr, final String detailBtnStr, final String detailString) {
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    template.setPublisherInfo(message, okBtnStr, detailBtnStr, detailString, false);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showBlockedDialog(Component owner, final AppInfo ainfo, final String title, final String masthead, final String reason, final String okBtnStr, final String detailBtnStr, final String detailString) {
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    String message = ainfo.getBlockedText();
                    template.setBlockedDialogInfo(reason, message, okBtnStr, detailBtnStr, detailString, false);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showErrorDialog(Component owner, final AppInfo ainfo, String titleStr, final String masthead, final String message, final String btnOneLabel, final String btnTwoLabel, final String btnThreeLabel) {
        final String title = titleStr == null ? ResourceManager.getString("error.default.title") : titleStr;
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead);
                    template.setMultiButtonErrorContent(message, btnOneLabel, btnTwoLabel, btnThreeLabel);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialInfo showPasswordDialog(Component parent, final String title, final String notes, final boolean showUsername, final boolean showDomain, final CredentialInfo info, final boolean saveEnabled, final String scheme, final String warning) {
        final Component fParent = UIFactory.beforeDialog(parent);
        try {
            CredentialInfo credentialInfo = (CredentialInfo)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() {
                    CredentialInfo result = null;
                    CredentialInfo input = info;
                    DialogTemplate template = new DialogTemplate(new AppInfo(), fParent, title, "");
                    if (input == null) {
                        input = new CredentialInfo();
                    }
                    template.setPasswordContent(notes, showUsername, showDomain, input.getUserName(), input.getDomain(), saveEnabled, input.getPassword(), scheme, warning);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int answer = template.getUserAnswer();
                    if (answer == 0 || answer == 2) {
                        result = new CredentialInfo();
                        result.setUserName(template.getUserName());
                        result.setDomain(template.getDomain());
                        result.setPassword(template.getPassword());
                        result.setPasswordSaveApproval(template.isPasswordSaved());
                    }
                    template.disposeDialog();
                    return result;
                }
            }, null);
            return credentialInfo;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    public static void showExceptionOCSPDialog(Component owner, Throwable throwable, String masthead, String msg, String title) {
        String closeBtnStr = ResourceManager.getString("common.close_btn");
        String detailBtnStr = ResourceManager.getString("dialog.template.more.info");
        if (msg == null) {
            msg = throwable.toString();
        }
        UIFactory.showErrorDialog(owner, new AppInfo(), title, masthead, msg, closeBtnStr, detailBtnStr, throwable, null, null);
    }

    public static void showExceptionDialog(Component owner, AppInfo ainfo, Throwable throwable, String masthead, String msg, String title) {
        String okBtnStr = ResourceManager.getString("common.ok_btn");
        String detailBtnStr = ResourceManager.getString("dialog.template.more.info");
        if (msg == null) {
            msg = SystemUtils.getSimpleName(throwable.getClass()) + ": " + throwable.getLocalizedMessage();
        }
        if (title == null) {
            title = ResourceManager.getString("error.default.title");
        }
        AppInfo appInfo = ainfo != null ? ainfo : new AppInfo();
        UIFactory.showErrorDialog(owner, appInfo, title, masthead, (String)msg, okBtnStr, detailBtnStr, throwable, null, null);
    }

    public static void showCertificateExceptionDialog(Component owner, AppInfo ainfo, Throwable throwable, String msg, String title, Certificate[] certs) {
        BlockedException e;
        String okBtnStr = ResourceManager.getString("common.ok_btn");
        String detailBtnStr = ResourceManager.getString("dialog.template.more.info");
        if (throwable instanceof BlockedException && (e = (BlockedException)throwable).getCause() instanceof CertificateRevokedException) {
            detailBtnStr = null;
        }
        if (msg == null) {
            msg = throwable.toString();
        }
        if (title == null) {
            title = ResourceManager.getString("security.badcert.caption");
        }
        UIFactory.showErrorDialog(owner, ainfo, title, msg, null, okBtnStr, detailBtnStr, throwable, null, certs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showContentDialog(Component owner, final AppInfo ainfo, final String title, final String content, final boolean scroll, final String okBtnStr, final String cancelBtnStr) {
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, null);
                    template.setSimpleContent(content, scroll, null, okBtnStr, cancelBtnStr, false, false);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showConfirmDialog(Component owner, AppInfo appInfo, final String title, final String message, final String info, final String okBtnStr, final String cancelBtnStr, final boolean useWarning) {
        final AppInfo ainfo = appInfo == null ? new AppInfo() : appInfo;
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, message);
                    template.setSimpleContent(null, false, info, okBtnStr, cancelBtnStr, true, useWarning);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showMixedCodeDialog(Component owner, AppInfo appInfo, final String title, final String masthead, final String message, final String info, final String okBtnStr, final String cancelBtnStr, final boolean useWarning, final String showAlways) {
        final boolean isJsToJava = appInfo != null;
        final AppInfo ainfo = appInfo == null ? new AppInfo() : appInfo;
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    int defaultButton = isJsToJava ? 1 : 0;
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead, true, defaultButton);
                    template.setMixedCodeContent(null, false, message, info, okBtnStr, cancelBtnStr, true, useWarning, isJsToJava, showAlways);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    public static void showInformationDialog(final Component parent, final String masthead, final String text, final String title) {
        final String okBtnStr = ResourceManager.getString("common.ok_btn");
        final AppInfo ainfo = new AppInfo();
        try {
            DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() {
                    DialogTemplate template = new DialogTemplate(ainfo, parent, title, masthead);
                    template.setInfoContent(text, okBtnStr);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    return null;
                }
            }, null);
        }
        catch (Throwable e) {
            Trace.ignored(e);
        }
    }

    public static int showDeprecationWarningDialog(final Component parent, final AppInfo ainfo, final String masthead, final String text, final String title, final String showAlways) {
        final String okBtnStr = ResourceManager.getString("common.ok_btn");
        try {
            return (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() {
                    DialogTemplate template = new DialogTemplate(ainfo, parent, title, masthead);
                    template.setDeprecationWarningContent(text, okBtnStr, showAlways);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
        }
        catch (Throwable e) {
            Trace.ignored(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showApiDialog(Component owner, AppInfo appInfo, final String title, final String message, final String label, final String files, final String always, final boolean checked) {
        final String okBtnStr = ResourceManager.getString("common.ok_btn");
        final String cancelBtnStr = ResourceManager.getString("common.cancel_btn");
        final AppInfo ainfo = appInfo == null ? new AppInfo() : appInfo;
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, message);
                    template.setApiContent(files, label, always, checked, okBtnStr, cancelBtnStr);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    public static ProgressDialog createProgressDialog(final AppInfo ainfo, final Component owner, final String title, final String contentStr, final boolean okBtn) {
        final String dialogClassName = System.getProperty("test.progressdialog");
        if (dialogClassName == null) {
            try {
                return (ProgressDialog)DeploySysRun.execute(new DeploySysAction(){

                    @Override
                    public Object execute() throws Exception {
                        return new ProgressDialog(ainfo, owner, title, contentStr, okBtn);
                    }
                });
            }
            catch (Throwable e) {
                Trace.ignored(e);
                return null;
            }
        }
        try {
            return (ProgressDialog)DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    Class<?> progressDialogClass = Class.forName(dialogClassName, false, null);
                    Class[] clazz = new Class[]{AppInfo.class, Component.class, String.class, String.class, Boolean.TYPE, Integer.TYPE};
                    Object[] obj = new Object[]{new AppInfo(), null, "dialog title", "string", false, 0};
                    return progressDialogClass.getConstructor(clazz).newInstance(obj);
                }
            });
        }
        catch (Throwable e) {
            new RuntimeException("can't construct testProgressDialog for testing!!");
            e.printStackTrace();
            return null;
        }
    }

    public static int showProgressDialog(final ProgressDialog progressDialog) {
        UIFactory.beforeDialog(null);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    UIFactory.placeWindow(progressDialog.getDialog());
                    progressDialog.setVisible(true);
                    return progressDialog.getUserAnswer();
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    public static int hideProgressDialog(final ProgressDialog progressDialog) {
        try {
            return (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    progressDialog.setVisible(false);
                    return 0;
                }
            }, -1);
        }
        catch (Throwable e) {
            Trace.ignored(e);
            return -1;
        }
    }

    public static void showAboutJavaDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            UIFactory.internalShowAboutJavaDialog();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        UIFactory.internalShowAboutJavaDialog();
                    }
                });
            }
            catch (Exception e) {
                Trace.ignored(e);
            }
        }
    }

    private static synchronized void internalShowAboutJavaDialog() {
        if (System.currentTimeMillis() - tsLastActive > 500L && AboutDialog.shouldStartNewInstance()) {
            AboutDialog dlg = new AboutDialog((JFrame)null, true, true);
            dlg.pack();
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dd = dlg.getSize();
            dlg.setLocation((sd.width - dd.width) / 2, (sd.height - dd.height) / 2);
            dlg.setAlwaysOnTop(true);
            dlg.setVisible(true);
            tsLastActive = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showWarningDialog(Component owner, AppInfo appInfo, final String title, final String masthead, final String message, final String okBtnStr, final String cancelBtnStr, final URL moreURL, final String moreText, final int defaultButton) {
        final AppInfo ainfo = appInfo == null ? new AppInfo() : appInfo;
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    boolean cannotDL = moreURL != null && moreText != null;
                    DialogTemplate template = new DialogTemplate(ainfo, fOwner, title, masthead, true, defaultButton);
                    if (cannotDL) {
                        template.setCannotDownloadContent(okBtnStr, cancelBtnStr, moreURL, moreText);
                    } else {
                        template.setSimpleContent(message, false, null, okBtnStr, cancelBtnStr, true, true);
                    }
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showUpdateCheckDialog() {
        String yesBtnKey = "autoupdatecheck.buttonYes";
        String noBtnKey = "autoupdatecheck.buttonNo";
        String askBtnKey = "autoupdatecheck.buttonAskLater";
        final String title = ResourceManager.getString("autoupdatecheck.caption");
        final String infoStr = ResourceManager.getString("autoupdatecheck.message");
        final String masthead = ResourceManager.getString("autoupdatecheck.masthead");
        final AppInfo ainfo = new AppInfo();
        final Component owner = UIFactory.beforeDialog(null);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, owner, title, masthead);
                    template.setUpdateCheckContent(infoStr, "autoupdatecheck.buttonYes", "autoupdatecheck.buttonNo", "autoupdatecheck.buttonAskLater");
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, 3);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = 3;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showListDialog(Component owner, final String title, final String message, final String label, final boolean details, final JList<String> scrollList, final TreeMap<String, X509Certificate[]> clientAuthCertsMap) {
        final String okBtnStr = ResourceManager.getString("common.ok_btn");
        final String cancelBtnStr = ResourceManager.getString("common.cancel_btn");
        final Component fOwner = UIFactory.beforeDialog(owner);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(new AppInfo(), fOwner, title, message);
                    template.setListContent(label, scrollList, details, okBtnStr, cancelBtnStr, clientAuthCertsMap);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    private static String[] addDetail(String[] list, AppInfo ainfo, boolean doShortcut, boolean doAssociation) {
        AssociationDesc[] ad;
        String title = ainfo.getDisplayTitle();
        if (title == null) {
            title = "";
        }
        ArrayList<String> al = new ArrayList<String>();
        for (String list1 : list) {
            al.add(list1);
        }
        if (doAssociation && (ad = ainfo.getAssociations()) != null) {
            for (AssociationDesc ad1 : ad) {
                String extensions = ad1.getExtensions();
                String mimeType = ad1.getMimeType();
                String description = ad1.getMimeDescription();
                String message = ResourceManager.getString("association.dialog.ask", mimeType, extensions);
                al.add(message);
            }
        }
        if (doShortcut) {
            String message = null;
            if (ainfo.getDesktopHint() && ainfo.getMenuHint()) {
                message = Config.getOSName().equalsIgnoreCase("Windows") ? ResourceManager.getString("install.windows.both.message") : ResourceManager.getString("install.gnome.both.message");
            } else if (ainfo.getDesktopHint()) {
                message = ResourceManager.getString("install.desktop.message");
            } else if (ainfo.getMenuHint()) {
                message = Config.getOSName().equalsIgnoreCase("Windows") ? ResourceManager.getString("install.windows.menu.message") : ResourceManager.getString("install.gnome.menu.message");
            }
            if (message != null) {
                al.add(message);
            }
        }
        return al.toArray(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showSSVDialog(Object owner, final AppInfo ainfo, final String title, final String masthead, final String message, final String moreInfoText, final URL moreInfoURL, final String choiceText, final String choice1Label, final String choice2Label, final String btnOneLabel, final String btnTwoLabel) {
        final Component parent = UIFactory.beforeDialog(null);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, parent, title, masthead);
                    template.setSSVContent(message, moreInfoText, moreInfoURL, choiceText, choice1Label, choice2Label, btnOneLabel, btnTwoLabel);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = template.getUserAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showSSV3Dialog(Object owner, final AppInfo ainfo, int messageType, final String titleKey, final String mastheadKey, final String mainTextKey, final String locationKey, final String promptKey, final String multiPromptKey, final String multiTextKey, final String runKey, final String updateKey, final String cancelKey, final String alwaysTextKey, final URL updateURL) {
        final Component parent = UIFactory.beforeDialog(null);
        try {
            int n = (Integer)DeploySysRun.executePrivileged(new DeploySysAction(){

                @Override
                public Object execute() throws Exception {
                    DialogTemplate template = new DialogTemplate(ainfo, parent, ResourceManager.getString(titleKey), ResourceManager.getString(mastheadKey));
                    SSV3DialogContent content = new SSV3DialogContent(ainfo, titleKey, mastheadKey, mainTextKey, locationKey, promptKey, multiPromptKey, multiTextKey, runKey, updateKey, cancelKey, alwaysTextKey, updateURL, template);
                    template.setSSV3Content(content);
                    UIFactory.placeWindow(template.getDialog());
                    template.setVisible(true);
                    int userAnswer = content.getAnswer();
                    template.disposeDialog();
                    return userAnswer;
                }
            }, -1);
            return n;
        }
        catch (Throwable e) {
            Trace.ignored(e);
            int n = -1;
            return n;
        }
        finally {
            UIFactory.afterDialog();
        }
    }

    public static void placeWindow(Window window) {
        Rectangle ownerBounds;
        if (window == null) {
            return;
        }
        Window owner = window.getOwner();
        if (UIFactory.ignoreOwnerVisibility()) {
            owner = null;
        }
        boolean ownerVis = owner != null && owner.isVisible();
        Rectangle screenBounds = UIFactory.getMouseScreenBounds();
        Rectangle winBounds = window.getBounds();
        Rectangle rectangle = ownerBounds = owner == null || !owner.isVisible() ? screenBounds : owner.getBounds();
        if (ownerBounds.x + ownerBounds.width < 0) {
            ownerVis = false;
            ownerBounds = screenBounds;
        }
        double goldenOffset = (double)ownerBounds.height - (double)ownerBounds.height / 1.618;
        winBounds.x = ownerBounds.x + (ownerBounds.width - winBounds.width) / 2;
        int computedOffset = (int)(goldenOffset - (double)(winBounds.height / 2));
        int minOffset = ownerVis ? owner.getInsets().top : screenBounds.height / 2 - 2 * winBounds.height / 3;
        winBounds.y = ownerBounds.y + Math.max(computedOffset, minOffset);
        if (winBounds.x + winBounds.width > screenBounds.x + screenBounds.width) {
            winBounds.x = screenBounds.x + Math.max(screenBounds.width - winBounds.width, 0);
        }
        if (winBounds.y + winBounds.height > screenBounds.y + screenBounds.height) {
            winBounds.y = screenBounds.y + Math.max(screenBounds.height - winBounds.height, 0);
        }
        if (winBounds.y < 0 || winBounds.x < 0) {
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension wd = window.getSize();
            window.setLocation(Math.abs(sd.width - wd.width) / 2, Math.abs(sd.height - wd.height) / 2);
        } else {
            window.setLocation(winBounds.x, winBounds.y);
        }
    }

    public static Rectangle getMouseScreenBounds() {
        GraphicsDevice[] devices;
        Point mousePoint = MouseInfo.getPointerInfo().getLocation();
        for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (mousePoint.x < bounds.x || mousePoint.y < bounds.y || mousePoint.x > bounds.x + bounds.width || mousePoint.y > bounds.y + bounds.height) continue;
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            return bounds;
        }
        return new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static void setDialogListener(DialogListener dl) {
        dialogListener = dl;
    }

    public static DialogListener getDialogListener() {
        return dialogListener;
    }

    public static void setDialogHook(DialogHook hook) {
        dialogHook = hook;
    }

    public static DialogHook getDialogHook() {
        return dialogHook;
    }

    public static boolean hasVisibleDialogs() {
        return visibleDialogs > 0;
    }

    static Component beforeDialog(Component component) {
        ++visibleDialogs;
        if (dialogHook != null) {
            return (Component)dialogHook.beforeDialog(component);
        }
        return component;
    }

    private static boolean ignoreOwnerVisibility() {
        if (dialogHook != null) {
            return dialogHook.ignoreOwnerVisibility();
        }
        return false;
    }

    static void afterDialog() {
        --visibleDialogs;
        if (dialogHook != null) {
            dialogHook.afterDialog();
        }
    }

    static {
        visibleDialogs = 0;
    }
}

