/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class X509CertificateWrapper
extends X509Certificate {
    private static final long serialVersionUID = -5309994485439997412L;
    private final X509Certificate cert;
    private final String hostname;
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;

    X509CertificateWrapper(X509Certificate cert, String hostname) {
        this.cert = cert;
        this.hostname = hostname;
    }

    X509CertificateWrapper(X509Certificate cert) {
        this(cert, null);
    }

    @Override
    public int getBasicConstraints() {
        int bc = this.cert.getBasicConstraints();
        if (bc != -1) {
            return bc;
        }
        try {
            if (this.cert.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (CertUtils.getNetscapeCertTypeBit(this.cert, NSCT_SSL_CA) || CertUtils.getNetscapeCertTypeBit(this.cert, NSCT_S_MIME_CA) || CertUtils.getNetscapeCertTypeBit(this.cert, NSCT_OBJECT_SIGNING_CA))) {
                return Integer.MAX_VALUE;
            }
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return -1;
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.cert.getKeyUsage();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.cert.getSubjectUniqueID();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.cert.getIssuerUniqueID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.cert.getSigAlgParams();
    }

    @Override
    public String getSigAlgOID() {
        return this.cert.getSigAlgOID();
    }

    @Override
    public String getSigAlgName() {
        return this.cert.getSigAlgName();
    }

    @Override
    public byte[] getSignature() {
        return this.cert.getSignature();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    @Override
    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    @Override
    public Principal getSubjectDN() {
        return this.cert.getSubjectDN();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.cert.getTBSCertificate();
    }

    @Override
    public int getVersion() {
        return this.cert.getVersion();
    }

    @Override
    public Principal getIssuerDN() {
        return this.cert.getIssuerDN();
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    @Override
    public String toString() {
        return this.cert.toString();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        this.cert.verify(key);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        this.cert.verify(key, sigProvider);
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.cert.getExtensionValue(oid);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.cert.getNonCriticalExtensionOIDs();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.cert.getCriticalExtensionOIDs();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.cert.hasUnsupportedCriticalExtension();
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return this.cert.getExtendedKeyUsage();
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return this.cert.getIssuerAlternativeNames();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.cert.getIssuerX500Principal();
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        Collection<List<?>> certAltNames = this.cert.getSubjectAlternativeNames();
        if (this.hostname != null) {
            LinkedList altNames = new LinkedList();
            if (certAltNames != null) {
                altNames.addAll(certAltNames);
            }
            ArrayList<Object> ipAltName = new ArrayList<Object>();
            ipAltName.add(7);
            ipAltName.add(this.hostname);
            altNames.add(ipAltName);
            ArrayList<Object> dnsAltName = new ArrayList<Object>();
            dnsAltName.add(2);
            dnsAltName.add(this.hostname);
            altNames.add(dnsAltName);
            return altNames;
        }
        return certAltNames;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.cert.getSubjectX500Principal();
    }

    @Override
    public boolean equals(Object other) {
        return this.cert.equals(other);
    }

    @Override
    public int hashCode() {
        return this.cert.hashCode();
    }
}

